/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowInstancesByClassAction
extends DebuggerTreeAction {
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        ObjectReference ref;
        boolean enabled;
        if (node == null) {
            ShowInstancesByClassAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            ShowInstancesByClassAction.$$$reportNull$$$0(1);
        }
        boolean bl = enabled = (ref = this.getObjectReference(node)) != null && ref.virtualMachine().canGetInstanceInfo();
        if (enabled) {
            String text = String.format("Show %s Objects...", StringUtil.getShortName((String)ref.referenceType().name()));
            e.getPresentation().setText(text);
        }
        return enabled;
    }

    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project project2;
        if (nodeName == null) {
            ShowInstancesByClassAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) != null) {
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
            ObjectReference ref = this.getObjectReference(node);
            if (debugSession != null && ref != null) {
                ReferenceType referenceType = ref.referenceType();
                new InstancesWindow(debugSession, l -> {
                    List<ObjectReference> instances = referenceType.instances(l);
                    return instances == null ? Collections.emptyList() : ContainerUtil.map(instances, JavaReferenceInfo::new);
                }, referenceType.name()).show();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/action/ShowInstancesByClassAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

