/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class BreakpointWithHighlighter<P extends JavaBreakpointProperties>
extends Breakpoint<P> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter");
    @Nullable
    private SourcePosition mySourcePosition;
    private boolean myVisible;
    private volatile Icon myIcon;
    @Nullable
    private String myClassName;
    @Nullable
    private String myPackageName;
    @Nullable
    private String myInvalidMessage;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected Icon getInvalidIcon(boolean isMuted) {
        return AllIcons.Debugger.Db_invalid_breakpoint;
    }

    protected Icon getSetIcon(boolean isMuted) {
        return null;
    }

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        SourcePosition pos = this.getSourcePosition();
        if (pos != null && pos.getFile() instanceof JspFile) {
            return this.getClassName();
        }
        return super.getShortClassName();
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.myPackageName;
    }

    @Nullable
    public BreakpointWithHighlighter init() {
        if (!this.isValid()) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateUI();
        }
        return this;
    }

    private void updateCaches(@Nullable DebugProcessImpl debugProcess) {
        JavaDebugProcess process2;
        this.myIcon = this.calcIcon(debugProcess);
        if (this.isVisible() && this.isValid() && debugProcess != null && this.myXBreakpoint instanceof XLineBreakpoint && (process2 = debugProcess.getXdebugProcess()) != null) {
            process2.getSession().updateBreakpointPresentation((XLineBreakpoint)this.myXBreakpoint, this.myIcon, this.myInvalidMessage);
        }
        if (debugProcess != null && debugProcess.getVirtualMachineProxy().canBeModified()) {
            this.myClassName = JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.getSourcePosition());
            this.myPackageName = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcess, this.getSourcePosition());
        }
    }

    private Icon calcIcon(@Nullable DebugProcessImpl debugProcess) {
        boolean muted;
        boolean bl = muted = debugProcess != null && this.isMuted(debugProcess);
        if (!this.isEnabled()) {
            return this.getDisabledIcon(muted);
        }
        this.myInvalidMessage = "";
        if (!this.isValid()) {
            return this.getInvalidIcon(muted);
        }
        if (debugProcess == null) {
            return this.getSetIcon(muted);
        }
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        boolean isVerified = this.myCachedVerifiedState || requestsManager.isVerified(this);
        String warning = requestsManager.getWarning(this);
        if (warning != null) {
            this.myInvalidMessage = warning;
            if (!isVerified) {
                return this.getInvalidIcon(muted);
            }
            return this.getVerifiedWarningsIcon(muted);
        }
        if (isVerified) {
            return this.getVerifiedIcon(muted);
        }
        return this.getValidatingIcon(muted);
    }

    protected Icon getValidatingIcon(boolean muted) {
        Icon icon;
        if (this.myXBreakpoint != null && (icon = this.myXBreakpoint.getType().getPendingIcon()) != null) {
            return icon;
        }
        return this.getSetIcon(muted);
    }

    protected BreakpointWithHighlighter(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(0);
        }
        super(project2, xBreakpoint);
        this.myVisible = true;
        this.myIcon = this.getSetIcon(false);
        ApplicationManager.getApplication().runReadAction(this::reload);
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.myXBreakpoint.getSourcePosition());
    }

    protected static boolean isPositionValid(@Nullable XSourcePosition sourcePosition) {
        return (Boolean)ReadAction.compute(() -> sourcePosition != null && sourcePosition.getFile().isValid());
    }

    @Nullable
    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    @NotNull
    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDisplayName());
        if (this.isCountFilterEnabled()) {
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
            buf.append(this.getCountFilter());
        }
        if (this.isClassFiltersEnabled()) {
            ClassFilter[] classFilters;
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
            for (ClassFilter classFilter : classFilters = this.getClassFilters()) {
                buf.append(classFilter.getPattern()).append(" ");
            }
        }
        if (this.isInstanceFiltersEnabled()) {
            InstanceFilter[] instanceFilters;
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
            for (InstanceFilter instanceFilter : instanceFilters = this.getInstanceFilters()) {
                buf.append(instanceFilter.getId()).append(" ");
            }
        }
        String string = buf.toString();
        if (string == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void reload() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.mySourcePosition = DebuggerUtilsEx.toSourcePosition(this.myXBreakpoint.getSourcePosition(), this.myProject);
        if (this.mySourcePosition != null) {
            this.reload(null);
        }
    }

    @Nullable
    static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcess) {
        if (requestor == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(2);
        }
        if (debugProcess == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(3);
        }
        if (location != null) {
            RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
            BreakpointRequest request = requestsManager.createBreakpointRequest(requestor, location);
            requestsManager.enableRequest(request);
            return request;
        }
        return null;
    }

    @Override
    public void createRequest(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(4);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            this.createOrWaitPrepare(debugProcess, position);
        } else {
            XSourcePosition xPosition = this.myXBreakpoint.getSourcePosition();
            LOG.error("Unable to create request for breakpoint with null position: " + this.toString() + " at " + xPosition + ", file valid = " + (xPosition != null && xPosition.getFile().isValid()));
        }
        this.updateUI();
    }

    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(5);
        }
        return debugProcess.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType classType) {
        DebugProcessImpl process2 = (DebugProcessImpl)debugProcess;
        if (this.shouldCreateRequest(process2, true)) {
            this.createRequestForPreparedClass(process2, classType);
            this.updateUI();
        }
    }

    @Override
    public final void updateUI() {
        if (!this.isVisible() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        DebuggerInvocationUtil.swingInvokeLater(this.myProject, () -> {
            if (!this.isValid()) {
                return;
            }
            DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
            final DebugProcessImpl debugProcess = context.getDebugProcess();
            if (debugProcess == null || !debugProcess.isAttached()) {
                this.updateCaches(null);
            } else {
                debugProcess.getManagerThread().invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (!BreakpointWithHighlighter.this.myProject.isDisposed()) {
                                BreakpointWithHighlighter.this.updateCaches(debugProcess);
                            }
                        });
                    }
                });
            }
        });
    }

    public boolean isAt(@NotNull Document document, int offset) {
        if (document == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(6);
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        int line = document.getLineNumber(offset);
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        return position != null && position.getLine() == line && position.getFile().equals(file);
    }

    @Deprecated
    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(@Nullable SourcePosition sourcePosition) {
        return (PsiClass)ReadAction.compute(() -> JVMNameUtil.getClassAt(sourcePosition));
    }

    @Override
    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    protected boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    @Nullable
    public Document getDocument() {
        PsiFile file = DebuggerUtilsEx.getPsiFile(this.myXBreakpoint.getSourcePosition(), this.myProject);
        if (file != null) {
            return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        }
        return null;
    }

    public int getLineIndex() {
        XSourcePosition sourcePosition = this.myXBreakpoint.getSourcePosition();
        return sourcePosition != null ? sourcePosition.getLine() : -1;
    }

    protected String getFileName() {
        XSourcePosition sourcePosition = this.myXBreakpoint.getSourcePosition();
        return sourcePosition != null ? sourcePosition.getFile().getName() : "";
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        String packageName;
        if (breakpointNode == null) {
            BreakpointWithHighlighter.$$$reportNull$$$0(7);
        }
        super.readExternal(breakpointNode);
        String className = breakpointNode.getAttributeValue("class");
        if (className != null) {
            this.myClassName = className;
        }
        if ((packageName = breakpointNode.getAttributeValue("package")) != null) {
            this.myPackageName = packageName;
        }
    }

    public String toString() {
        return (String)ReadAction.compute(() -> "<html><body>" + this.getDescription() + "</body>" + "</html>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMuted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

