/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.testIntegration.TestFailedLineManager;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TestFailedLineInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            TestFailedLineInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                TestStateStorage.Record state = TestFailedLineManager.getInstance((Project)call.getProject()).getFailedLineState(call);
                if (state == null) {
                    return;
                }
                LocalQuickFix[] fixes = new LocalQuickFix[]{new DebugFailedTestFix((PsiElement)call, state.topStacktraceLine), new RunActionFix((PsiElement)call, DefaultRunExecutor.EXECUTOR_ID)};
                ProblemDescriptor descriptor2 = InspectionManager.getInstance((Project)call.getProject()).createProblemDescriptor(nameElement, state.errorMessage, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                descriptor2.setTextAttributes(CodeInsightColors.RUNTIME_ERROR);
                holder.registerProblem(descriptor2);
            }
        };
        if (javaElementVisitor == null) {
            TestFailedLineInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/TestFailedLineInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/TestFailedLineInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunActionFix
    implements LocalQuickFix,
    Iconable {
        private final ConfigurationContext myContext;
        private final Executor myExecutor;
        private final RunnerAndConfigurationSettings myConfiguration;

        RunActionFix(PsiElement element, String executorId) {
            this.myExecutor = ExecutorRegistry.getInstance().getExecutorById(executorId);
            this.myContext = new ConfigurationContext(element);
            this.myConfiguration = this.myContext.getConfiguration();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String text = this.myExecutor.getStartActionText(ProgramRunnerUtil.shortenName((String)this.myConfiguration.getName(), (int)0));
            String string = UIUtil.removeMnemonic((String)text);
            if (string == null) {
                RunActionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                RunActionFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                RunActionFix.$$$reportNull$$$0(2);
            }
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)this.myConfiguration, (Executor)this.myExecutor);
        }

        public Icon getIcon(int flags) {
            return this.myExecutor.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/TestFailedLineInspection$RunActionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/TestFailedLineInspection$RunActionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DebugFailedTestFix
    extends RunActionFix {
        private final String myTopStacktraceLine;

        DebugFailedTestFix(PsiElement element, String topStacktraceLine) {
            super(element, DefaultDebugExecutor.EXECUTOR_ID);
            this.myTopStacktraceLine = topStacktraceLine;
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Document document;
            StackTraceLine line;
            Location<PsiMethod> location;
            if (project2 == null) {
                DebugFailedTestFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DebugFailedTestFix.$$$reportNull$$$0(1);
            }
            if ((location = (line = new StackTraceLine(project2, this.myTopStacktraceLine)).getMethodLocation(project2)) != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(((PsiMethod)location.getPsiElement()).getContainingFile())) != null) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().addLineBreakpoint(document, line.getLineNumber());
            }
            super.applyFix(project2, descriptor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/testframework/TestFailedLineInspection$DebugFailedTestFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

