/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShortenCommandLineModeCombo
extends ComboBox<ShortenCommandLine> {
    private final Project myProject;

    public ShortenCommandLineModeCombo(Project project2, final JrePathEditor pathEditor, final ModuleDescriptionsComboBox component) {
        this.myProject = project2;
        this.initModel(null, pathEditor, component.getSelectedModule());
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ShortenCommandLine>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ShortenCommandLine> list, ShortenCommandLine value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    ShortenCommandLine defaultMode = ShortenCommandLine.getDefaultMethod((Project)ShortenCommandLineModeCombo.this.myProject, (String)ShortenCommandLineModeCombo.getJdkRoot(pathEditor, component.getSelectedModule()));
                    this.append("user-local default: " + defaultMode.getPresentableName()).append(" - " + defaultMode.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(value.getPresentableName()).append(" - " + value.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/ShortenCommandLineModeCombo$1", "customizeCellRenderer"));
            }
        });
        ActionListener updateModelListener = e -> {
            ShortenCommandLine item = this.getSelectedItem();
            this.initModel(item, pathEditor, component.getSelectedModule());
        };
        pathEditor.addActionListener(updateModelListener);
        component.addActionListener(updateModelListener);
    }

    private void initModel(ShortenCommandLine preselection, JrePathEditor pathEditor, Module module2) {
        this.removeAllItems();
        String jdkRoot = ShortenCommandLineModeCombo.getJdkRoot(pathEditor, module2);
        this.addItem(null);
        for (ShortenCommandLine mode : ShortenCommandLine.values()) {
            if (!mode.isApplicable(jdkRoot)) continue;
            this.addItem(mode);
        }
        this.setSelectedItem(preselection);
    }

    @Nullable
    private static String getJdkRoot(JrePathEditor pathEditor, Module module2) {
        if (!pathEditor.isAlternativeJreSelected() && module2 != null) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
            return sdk != null ? sdk.getHomePath() : null;
        }
        String jrePathOrName = pathEditor.getJrePathOrName();
        if (jrePathOrName != null) {
            Sdk configuredJdk = ProjectJdkTable.getInstance().findJdk(jrePathOrName);
            if (configuredJdk != null) {
                return configuredJdk.getHomePath();
            }
            return jrePathOrName;
        }
        return null;
    }

    @Nullable
    public ShortenCommandLine getSelectedItem() {
        return (ShortenCommandLine)super.getSelectedItem();
    }
}

