/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SourcePathsStep;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.JavaSettingsStep;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectJdkForModuleStep;
import com.intellij.ide.util.projectWizard.ProjectJdkStep;
import com.intellij.ide.util.projectWizard.ProjectNameStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectWizardStepFactoryImpl
extends ProjectWizardStepFactory {
    private static final Key<ProjectJdkStep> PROJECT_JDK_STEP_KEY = Key.create((String)"ProjectJdkStep");

    public ModuleWizardStep createNameAndLocationStep(WizardContext wizardContext) {
        return new ProjectNameStep(wizardContext);
    }

    public ModuleWizardStep createSourcePathsStep(WizardContext context, SourcePathsBuilder builder, Icon icon, @NonNls String helpId) {
        return new SourcePathsStep(builder, icon, helpId);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext context, SdkType type, final JavaModuleBuilder builder, final Computable<Boolean> isVisible, final Icon icon, @NonNls String helpId) {
        return new ProjectJdkForModuleStep(context, type, helpId){

            @Override
            public void updateDataModel() {
                super.updateDataModel();
                builder.setModuleJdk(this.getJdk());
            }

            public boolean isStepVisible() {
                return (Boolean)isVisible.compute();
            }

            @Override
            public Icon getIcon() {
                return icon;
            }

            public String getName() {
                return "Specify JDK";
            }
        };
    }

    public ModuleWizardStep createProjectJdkStep(final WizardContext wizardContext) {
        ProjectJdkStep projectSdkStep = (ProjectJdkStep)((Object)wizardContext.getUserData(PROJECT_JDK_STEP_KEY));
        if (projectSdkStep != null) {
            return projectSdkStep;
        }
        projectSdkStep = new ProjectJdkStep(wizardContext){

            public boolean isStepVisible() {
                Sdk newProjectJdk = AbstractProjectWizard.getProjectSdkByDefault(wizardContext);
                if (newProjectJdk == null) {
                    return true;
                }
                ProjectBuilder projectBuilder = wizardContext.getProjectBuilder();
                return projectBuilder != null && !projectBuilder.isSuitableSdk(newProjectJdk);
            }
        };
        wizardContext.putUserData(PROJECT_JDK_STEP_KEY, (Object)projectSdkStep);
        return projectSdkStep;
    }

    public ModuleWizardStep createJavaSettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> sdkFilter) {
        if (settingsStep == null) {
            ProjectWizardStepFactoryImpl.$$$reportNull$$$0(0);
        }
        if (moduleBuilder == null) {
            ProjectWizardStepFactoryImpl.$$$reportNull$$$0(1);
        }
        if (sdkFilter == null) {
            ProjectWizardStepFactoryImpl.$$$reportNull$$$0(2);
        }
        return new JavaSettingsStep(settingsStep, moduleBuilder, sdkFilter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settingsStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkFilter";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/projectWizard/ProjectWizardStepFactoryImpl";
        objectArray[2] = "createJavaSettingsStep";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

