/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.google.common.base.Strings;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.settings.DependencyExclusionEditor;
import com.intellij.jarRepository.settings.VersionItem;
import com.intellij.jarRepository.settings.VersionSelectorCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryPropertiesEditor {
    private static final Logger LOG = Logger.getInstance(RepositoryLibraryPropertiesEditor.class);
    @NotNull
    private final Project project;
    State currentState;
    List<String> versions;
    private final RepositoryLibraryPropertiesModel initialModel;
    private final RepositoryLibraryPropertiesModel model;
    private final RepositoryLibraryDescription repositoryLibraryDescription;
    private ComboBox<VersionItem> versionSelector;
    private JPanel mainPanel;
    private JButton myReloadButton;
    private JBCheckBox downloadSourcesCheckBox;
    private JBCheckBox downloadJavaDocsCheckBox;
    private JBCheckBox downloadAnnotationsCheckBox;
    private JBLabel mavenCoordinates;
    private final ThreeStateCheckBox myIncludeTransitiveDepsCheckBox;
    private JPanel myPropertiesPanel;
    private JPanel myTransitiveDependenciesPanel;
    @NotNull
    private final ModelChangeListener onChangeListener;
    private final SwingActionLink myManageDependenciesLink;

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description) {
        this(project2, model, description, true, new ModelChangeListener(){

            @Override
            public void onChange(@NotNull RepositoryLibraryPropertiesEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor$1", "onChange"));
            }
        });
    }

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, final RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description, boolean allowExcludingTransitiveDependencies, final @NotNull ModelChangeListener onChangeListener) {
        if (onChangeListener == null) {
            RepositoryLibraryPropertiesEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.initialModel = model.clone();
        this.model = model;
        this.project = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
        this.repositoryLibraryDescription = description;
        this.mavenCoordinates.setCopyable(true);
        this.myIncludeTransitiveDepsCheckBox = new ThreeStateCheckBox(UIUtil.replaceMnemonicAmpersand((String)"Include &transitive dependencies"));
        this.myIncludeTransitiveDepsCheckBox.setThirdStateEnabled(false);
        this.myTransitiveDependenciesPanel.add((Component)this.myIncludeTransitiveDepsCheckBox);
        this.myManageDependenciesLink = new SwingActionLink((Action)new AbstractAction("Configure..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.configureTransitiveDependencies();
            }
        });
        this.myManageDependenciesLink.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.myTransitiveDependenciesPanel.add((Component)this.myManageDependenciesLink);
        this.myTransitiveDependenciesPanel.setVisible(allowExcludingTransitiveDependencies);
        this.myReloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.reloadVersionsAsync();
            }
        });
        this.onChangeListener = new ModelChangeListener(){

            @Override
            public void onChange(@NotNull RepositoryLibraryPropertiesEditor editor) {
                if (editor == null) {
                    4.$$$reportNull$$$0(0);
                }
                onChangeListener.onChange(editor);
                RepositoryLibraryPropertiesEditor.this.mavenCoordinates.setText(RepositoryLibraryPropertiesEditor.this.repositoryLibraryDescription.getMavenCoordinates(model.getVersion()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor$4", "onChange"));
            }
        };
        this.versionSelector.setRenderer((ListCellRenderer)((Object)new VersionSelectorCellRenderer()));
        this.updateManageDependenciesLink();
        this.reloadVersionsAsync();
    }

    private void configureTransitiveDependencies() {
        String selectedVersion = this.getSelectedVersion();
        LOG.assertTrue(selectedVersion != null);
        ArtifactDependencyNode root = JarRepositoryManager.loadDependenciesTree(this.repositoryLibraryDescription, selectedVersion, this.project);
        if (root == null) {
            return;
        }
        Set<String> dependencies = new DependencyExclusionEditor(root, this.mainPanel).selectExcludedDependencies(this.model.getExcludedDependencies());
        if (dependencies != null) {
            this.model.setExcludedDependencies(dependencies);
            this.updateIncludeTransitiveDepsCheckBoxState();
            this.onChangeListener.onChange(this);
        }
    }

    private static VersionItem toVersionItem(String version) {
        if (Strings.isNullOrEmpty((String)version)) {
            return null;
        }
        if (version.equals("RELEASE")) {
            return VersionItem.LatestRelease.INSTANCE;
        }
        if (version.equals("LATEST")) {
            return VersionItem.LatestVersion.INSTANCE;
        }
        return new VersionItem.ExactVersion(version);
    }

    private void setState(State state) {
        this.currentState = state;
        ((CardLayout)this.myPropertiesPanel.getLayout()).show(this.myPropertiesPanel, state.name());
        this.onChangeListener.onChange(this);
    }

    private void reloadVersionsAsync() {
        this.setState(State.Loading);
        JarRepositoryManager.getAvailableVersions(this.project, this.repositoryLibraryDescription).onSuccess(result -> this.versionsLoaded(new ArrayList<String>((Collection<String>)result)));
    }

    private void initVersionsPanel() {
        CollectionComboBoxModel versionSelectorModel = new CollectionComboBoxModel();
        versionSelectorModel.add((Object)VersionItem.LatestRelease.INSTANCE);
        versionSelectorModel.add((Object)VersionItem.LatestVersion.INSTANCE);
        versionSelectorModel.add(ContainerUtil.map(this.versions, VersionItem.ExactVersion::new));
        this.versionSelector.setModel((ComboBoxModel)versionSelectorModel);
        this.versionSelector.setSelectedItem((Object)RepositoryLibraryPropertiesEditor.toVersionItem(this.model.getVersion()));
        this.setState(State.Loaded);
        this.versionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setVersion(RepositoryLibraryPropertiesEditor.this.getSelectedVersion());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
                RepositoryLibraryPropertiesEditor.this.updateManageDependenciesLink();
            }
        });
        this.downloadSourcesCheckBox.setSelected(this.model.isDownloadSources());
        this.downloadSourcesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadSources(RepositoryLibraryPropertiesEditor.this.downloadSourcesCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadJavaDocsCheckBox.setSelected(this.model.isDownloadJavaDocs());
        this.downloadJavaDocsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadJavaDocs(RepositoryLibraryPropertiesEditor.this.downloadJavaDocsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadAnnotationsCheckBox.setSelected(this.model.isDownloadAnnotations());
        this.downloadAnnotationsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadAnnotations(RepositoryLibraryPropertiesEditor.this.downloadAnnotationsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.updateIncludeTransitiveDepsCheckBoxState();
        this.myIncludeTransitiveDepsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.updateManageDependenciesLink();
                ThreeStateCheckBox.State state = RepositoryLibraryPropertiesEditor.this.myIncludeTransitiveDepsCheckBox.getState();
                if (state != ThreeStateCheckBox.State.DONT_CARE) {
                    RepositoryLibraryPropertiesEditor.this.model.setExcludedDependencies(Collections.emptyList());
                }
                RepositoryLibraryPropertiesEditor.this.model.setIncludeTransitiveDependencies(state != ThreeStateCheckBox.State.NOT_SELECTED);
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.updateManageDependenciesLink();
    }

    private void updateIncludeTransitiveDepsCheckBoxState() {
        this.myIncludeTransitiveDepsCheckBox.setState(!this.model.isIncludeTransitiveDependencies() ? ThreeStateCheckBox.State.NOT_SELECTED : (this.model.getExcludedDependencies().isEmpty() ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.DONT_CARE));
    }

    private void updateManageDependenciesLink() {
        boolean enable = this.myIncludeTransitiveDepsCheckBox.getState() != ThreeStateCheckBox.State.NOT_SELECTED && this.getSelectedVersion() != null;
        this.myManageDependenciesLink.setEnabled(enable);
    }

    private void versionsLoaded(@NotNull List<String> versions) {
        if (versions == null) {
            RepositoryLibraryPropertiesEditor.$$$reportNull$$$0(1);
        }
        this.versions = versions;
        if (versions.isEmpty()) {
            this.versionsFailedToLoad();
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::initVersionsPanel, ModalityState.any());
    }

    private void versionsFailedToLoad() {
        ApplicationManager.getApplication().invokeLater(() -> this.setState(State.FailedToLoad), ModalityState.any());
    }

    @Nullable
    public String getSelectedVersion() {
        VersionItem selectedItem = (VersionItem)this.versionSelector.getSelectedItem();
        return selectedItem != null ? selectedItem.getVersionId() : null;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isValid() {
        return this.currentState == State.Loaded;
    }

    public boolean hasChanges() {
        return !this.model.equals(this.initialModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChangeListener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "versionsLoaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox;
        JPanel jPanel2;
        JBLabel jBLabel;
        JPanel jPanel3;
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setMinimumSize(new Dimension(400, 128));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Maven:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mavenCoordinates = jBLabel = new JBLabel();
        jBLabel.setOpaque(false);
        jBLabel.setRequestFocusEnabled(true);
        jBLabel.setText("");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myPropertiesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, "Loaded");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Version:");
        jBLabel3.setDisplayedMnemonic('V');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.versionSelector = comboBox = new ComboBox();
        jPanel6.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.downloadSourcesCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setLabel("Download sources");
        jBCheckBox3.setText("Download sources");
        jBCheckBox3.setMnemonic('S');
        jBCheckBox3.setDisplayedMnemonicIndex(9);
        jPanel7.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel7.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.downloadJavaDocsCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setLabel("Download JavaDocs");
        jBCheckBox2.setText("Download JavaDocs");
        jBCheckBox2.setMnemonic('J');
        jBCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel7.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransitiveDependenciesPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.downloadAnnotationsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Download annotations");
        jBCheckBox.setMnemonic('N');
        jBCheckBox.setDisplayedMnemonicIndex(10);
        jPanel7.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, "Loading");
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setInheritsPopupMenu(true);
        jBLabel4.setText("Loading available versions...");
        jBLabel4.setDisplayedMnemonic('L');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel8.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel8.add((Component)spacer7, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel9, "FailedToLoad");
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Failed to load versions");
        jPanel9.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel9.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myReloadButton = jButton = new JButton();
        jButton.setText("Reload");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel9.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel9.add((Component)spacer9, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static enum State {
        Loading,
        FailedToLoad,
        Loaded;

    }

    public static interface ModelChangeListener {
        public void onChange(@NotNull RepositoryLibraryPropertiesEditor var1);
    }
}

