/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.IntegrationKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemFacadeManager {
    private static final int REMOTE_FAIL_RECOVERY_ATTEMPTS_NUMBER = 3;
    private final ConcurrentMap<IntegrationKey, RemoteExternalSystemFacade> myFacadeWrappers;
    private final Map<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>> myRemoteFacades;
    @NotNull
    private final Lock myLock;
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;
    @NotNull
    private final RemoteExternalSystemCommunicationManager myRemoteCommunicationManager;
    @NotNull
    private final InProcessExternalSystemCommunicationManager myInProcessCommunicationManager;

    public ExternalSystemFacadeManager(@NotNull ExternalSystemProgressNotificationManager notificationManager, @NotNull RemoteExternalSystemCommunicationManager remoteCommunicationManager, @NotNull InProcessExternalSystemCommunicationManager inProcessCommunicationManager) {
        if (notificationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(0);
        }
        if (remoteCommunicationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(1);
        }
        if (inProcessCommunicationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(2);
        }
        this.myFacadeWrappers = ContainerUtil.newConcurrentMap();
        this.myRemoteFacades = ContainerUtil.newConcurrentMap();
        this.myLock = new ReentrantLock();
        this.myProgressManager = (RemoteExternalSystemProgressNotificationManager)((Object)notificationManager);
        this.myRemoteCommunicationManager = remoteCommunicationManager;
        this.myInProcessCommunicationManager = inProcessCommunicationManager;
    }

    @NotNull
    private static Project findProject(@NotNull IntegrationKey key) {
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(3);
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project2 : projectManager.getOpenProjects()) {
            if (!key.getIdeProjectName().equals(project2.getName()) || !key.getIdeProjectLocationHash().equals(project2.getLocationHash())) continue;
            Project project3 = project2;
            if (project3 == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(4);
            }
            return project3;
        }
        Project project4 = projectManager.getDefaultProject();
        if (project4 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(5);
        }
        return project4;
    }

    public void onProjectRename(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(7);
        }
        ExternalSystemFacadeManager.onProjectRename(this.myFacadeWrappers, oldName, newName);
        ExternalSystemFacadeManager.onProjectRename(this.myRemoteFacades, oldName, newName);
    }

    private static <V> void onProjectRename(@NotNull Map<IntegrationKey, V> data, @NotNull String oldName, @NotNull String newName) {
        if (data == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(8);
        }
        if (oldName == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(10);
        }
        HashSet keys = ContainerUtilRt.newHashSet(data.keySet());
        for (IntegrationKey key : keys) {
            if (!key.getIdeProjectName().equals(oldName)) continue;
            IntegrationKey newKey = new IntegrationKey(newName, key.getIdeProjectLocationHash(), key.getExternalSystemId(), key.getExternalProjectConfigPath());
            V value = data.get(key);
            data.put(newKey, value);
            data.remove(key);
            if (!(value instanceof Consumer)) continue;
            ((Consumer)value).consume((Object)newKey);
        }
    }

    @NotNull
    public RemoteExternalSystemFacade getFacade(@Nullable Project project2, @NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId) {
        IntegrationKey key;
        RemoteExternalSystemFacade facade;
        if (externalProjectPath == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(11);
        }
        if (externalSystemId == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        if ((facade = (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key = new IntegrationKey(project2, externalSystemId, externalProjectPath))) == null) {
            RemoteExternalSystemFacade newFacade = (RemoteExternalSystemFacade)Proxy.newProxyInstance(ExternalSystemFacadeManager.class.getClassLoader(), new Class[]{RemoteExternalSystemFacade.class, Consumer.class}, (InvocationHandler)new MyHandler(key));
            this.myFacadeWrappers.putIfAbsent(key, newFacade);
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key);
        if (remoteExternalSystemFacade == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(13);
        }
        return remoteExternalSystemFacade;
    }

    public Object doInvoke(@NotNull IntegrationKey key, @NotNull Project project2, Method method, Object[] args, int invocationNumber) throws Throwable {
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(15);
        }
        RemoteExternalSystemFacade facade = this.doGetFacade(key, project2);
        try {
            return method.invoke((Object)facade, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RemoteException && invocationNumber > 0) {
                Thread.sleep(1000L);
                return this.doInvoke(key, project2, method, args, invocationNumber - 1);
            }
            throw e;
        }
    }

    public ExternalSystemCommunicationManager getCommunicationManager(@NotNull ProjectSystemId externalSystemId) {
        boolean currentInProcess;
        if (externalSystemId == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(16);
        }
        return (currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)externalSystemId)) ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private RemoteExternalSystemFacade doGetFacade(@NotNull IntegrationKey key, @NotNull Project project2) throws Exception {
        boolean currentInProcess;
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(18);
        }
        ExternalSystemCommunicationManager myCommunicationManager = (currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)key.getExternalSystemId())) ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)key.getExternalSystemId());
        if (project2.isDisposed() || manager == null) {
            RemoteExternalSystemFacade<?> remoteExternalSystemFacade = RemoteExternalSystemFacade.NULL_OBJECT;
            if (remoteExternalSystemFacade == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(19);
            }
            return remoteExternalSystemFacade;
        }
        Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair2 = this.myRemoteFacades.get(key);
        if (pair2 != null && this.prepare(myCommunicationManager, project2, key, pair2)) {
            RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair2.first;
            if (remoteExternalSystemFacade == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(20);
            }
            return remoteExternalSystemFacade;
        }
        this.myLock.lock();
        pair2 = this.myRemoteFacades.get(key);
        if (pair2 != null && this.prepare(myCommunicationManager, project2, key, pair2)) {
            RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair2.first;
            RemoteExternalSystemFacade remoteExternalSystemFacade2 = remoteExternalSystemFacade;
            if (remoteExternalSystemFacade2 == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(21);
            }
            return remoteExternalSystemFacade2;
        }
        if (pair2 != null) {
            this.myFacadeWrappers.clear();
            this.myRemoteFacades.clear();
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade = this.doCreateFacade(key, project2, myCommunicationManager);
        RemoteExternalSystemFacade remoteExternalSystemFacade3 = remoteExternalSystemFacade;
        if (remoteExternalSystemFacade3 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(22);
        }
        return remoteExternalSystemFacade3;
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    private RemoteExternalSystemFacade doCreateFacade(@NotNull IntegrationKey key, @NotNull Project project2, @NotNull ExternalSystemCommunicationManager communicationManager) throws Exception {
        RemoteExternalSystemFacade facade;
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(23);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(24);
        }
        if (communicationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(25);
        }
        if ((facade = communicationManager.acquire(key.getExternalProjectConfigPath(), key.getExternalSystemId())) == null) {
            throw new IllegalStateException("Can't obtain facade to working with external api at the remote process. Project: " + project2);
        }
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                ExternalSystemFacadeManager.this.myFacadeWrappers.clear();
                ExternalSystemFacadeManager.this.myRemoteFacades.clear();
            }
        });
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> result = new ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings>(facade, this.myProgressManager);
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)key.getExternalProjectConfigPath(), (ProjectSystemId)key.getExternalSystemId());
        Pair newPair = Pair.create(result, (Object)settings);
        this.myRemoteFacades.put(key, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)newPair);
        result.applySettings((ExternalSystemExecutionSettings)newPair.second);
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> externalSystemFacadeWrapper = result;
        if (externalSystemFacadeWrapper == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(26);
        }
        return externalSystemFacadeWrapper;
    }

    private boolean prepare(@NotNull ExternalSystemCommunicationManager communicationManager, @NotNull Project project2, @NotNull IntegrationKey key, @NotNull Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair2) {
        if (communicationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(27);
        }
        if (project2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(28);
        }
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(29);
        }
        if (pair2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(30);
        }
        if (!communicationManager.isAlive((RemoteExternalSystemFacade)pair2.first)) {
            return false;
        }
        try {
            ExternalSystemExecutionSettings currentSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project2, (String)key.getExternalProjectConfigPath(), (ProjectSystemId)key.getExternalSystemId());
            if (!currentSettings.equals(pair2.second)) {
                ((RemoteExternalSystemFacade)pair2.first).applySettings(currentSettings);
                this.myRemoteFacades.put(key, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)Pair.create((Object)pair2.first, (Object)currentSettings));
            }
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskActive(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(31);
        }
        HashMap copy = ContainerUtilRt.newHashMap(this.myRemoteFacades);
        for (Map.Entry entry : copy.entrySet()) {
            try {
                if (!((RemoteExternalSystemFacade)((Pair)entry.getValue()).first).isTaskInProgress(id)) continue;
                return true;
            }
            catch (RemoteException e) {
                this.myLock.lock();
                try {
                    this.myRemoteFacades.remove(entry.getKey());
                    this.myFacadeWrappers.remove(entry.getKey());
                }
                finally {
                    this.myLock.unlock();
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCommunicationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inProcessCommunicationManager";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 15: 
            case 18: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "communicationManager";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacade";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFacade";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onProjectRename";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFacade";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommunicationManager";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetFacade";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFacade";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isTaskActive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyHandler
    implements InvocationHandler {
        @NotNull
        private final AtomicReference<IntegrationKey> myKey;

        MyHandler(IntegrationKey key) {
            if (key == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            this.myKey = new AtomicReference();
            this.myKey.set(key);
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("consume".equals(method.getName())) {
                this.myKey.set((IntegrationKey)args[0]);
                return null;
            }
            Project project2 = ExternalSystemFacadeManager.findProject(this.myKey.get());
            return ExternalSystemFacadeManager.this.doInvoke(this.myKey.get(), project2, method, args, 3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager$MyHandler", "<init>"));
        }
    }
}

