/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryEditingUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil");

    private LibraryEditingUtil() {
    }

    public static boolean libraryAlreadyExists(LibraryTable.ModifiableModel table, String libraryName) {
        Iterator it = table.getLibraryIterator();
        while (it.hasNext()) {
            Library library = (Library)it.next();
            String libName = table instanceof LibrariesModifiableModel ? ((LibrariesModifiableModel)table).getLibraryEditor(library).getName() : library.getName();
            if (!libraryName.equals(libName)) continue;
            return true;
        }
        return false;
    }

    public static String suggestNewLibraryName(LibraryTable.ModifiableModel table, String baseName) {
        String candidateName = baseName;
        int idx = 1;
        while (LibraryEditingUtil.libraryAlreadyExists(table, candidateName)) {
            candidateName = baseName + idx++;
        }
        return candidateName;
    }

    public static Predicate<Library> getNotAddedSuitableLibrariesCondition(ModuleRootModel rootModel, FacetsProvider facetsProvider) {
        OrderEntry[] orderEntries = rootModel.getOrderEntries();
        HashSet<Library> result = new HashSet<Library>(orderEntries.length);
        for (OrderEntry orderEntry : orderEntries) {
            Library library2;
            if (!(orderEntry instanceof LibraryOrderEntry) || !orderEntry.isValid() || (library2 = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
            if (library2 instanceof LibraryImpl) {
                Library source = ((LibraryImpl)library2).getSource();
                result.add(source != null ? source : library2);
                continue;
            }
            result.add(library2);
        }
        return library -> {
            LibraryType type;
            Library source;
            if (result.contains(library)) {
                return false;
            }
            if (library instanceof LibraryImpl && (source = ((LibraryImpl)library).getSource()) != null && result.contains(source)) {
                return false;
            }
            PersistentLibraryKind kind = ((LibraryEx)library).getKind();
            return kind == null || (type = LibraryType.findByKind((LibraryKind)kind)).isSuitableModule(rootModel.getModule(), facetsProvider);
        };
    }

    public static void copyLibrary(LibraryEx from, Map<String, String> rootMapping, LibraryEx.ModifiableModelEx target) {
        target.setProperties(from.getProperties());
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            String[] urls;
            for (String url : urls = from.getUrls(type)) {
                String targetUrl;
                String pathInJar;
                String localPath;
                String protocol = VirtualFileManager.extractProtocol((String)url);
                if (protocol == null) continue;
                String fullPath = VirtualFileManager.extractPath((String)url);
                int sep = fullPath.indexOf("!/");
                if (sep != -1) {
                    localPath = fullPath.substring(0, sep);
                    pathInJar = fullPath.substring(sep);
                } else {
                    localPath = fullPath;
                    pathInJar = "";
                }
                String targetPath = rootMapping.get(localPath);
                String string = targetUrl = targetPath != null ? VirtualFileManager.constructUrl((String)protocol, (String)(targetPath + pathInJar)) : url;
                if (from.isJarDirectory(url, type)) {
                    target.addJarDirectory(targetUrl, false, type);
                    continue;
                }
                target.addRoot(targetUrl, type);
            }
        }
    }

    public static LibraryTablePresentation getLibraryTablePresentation(@NotNull Project project2, @NotNull String level) {
        if (project2 == null) {
            LibraryEditingUtil.$$$reportNull$$$0(0);
        }
        if (level == null) {
            LibraryEditingUtil.$$$reportNull$$$0(1);
        }
        if (level.equals("module")) {
            return ModuleLibraryTable.MODULE_LIBRARY_TABLE_PRESENTATION;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project2);
        LOG.assertTrue(table != null, (Object)level);
        return table.getPresentation();
    }

    public static List<LibraryType> getSuitableTypes(ClasspathPanel classpathPanel) {
        ArrayList<LibraryType> suitableTypes = new ArrayList<LibraryType>();
        suitableTypes.add(null);
        Module module2 = classpathPanel.getRootModel().getModule();
        for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            if (libraryType.getCreateActionName() == null || !libraryType.isSuitableModule(module2, classpathPanel.getModuleConfigurationState().getFacetsProvider())) continue;
            suitableTypes.add(libraryType);
        }
        return suitableTypes;
    }

    public static boolean hasSuitableTypes(ClasspathPanel panel) {
        return LibraryEditingUtil.getSuitableTypes(panel).size() > 1;
    }

    public static BaseListPopupStep<LibraryType> createChooseTypeStep(ClasspathPanel classpathPanel, final ParameterizedRunnable<? super LibraryType> action) {
        return new BaseListPopupStep<LibraryType>(IdeBundle.message((String)"popup.title.select.library.type", (Object[])new Object[0]), LibraryEditingUtil.getSuitableTypes(classpathPanel)){

            @NotNull
            public String getTextFor(LibraryType value) {
                String string = value != null ? value.getCreateActionName() : IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(LibraryType aValue) {
                return aValue != null ? aValue.getIcon(null) : PlatformIcons.LIBRARY_ICON;
            }

            public PopupStep onChosen(LibraryType selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> action.run((Object)selectedValue));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil$1", "getTextFor"));
            }
        };
    }

    public static List<Module> getSuitableModules(@NotNull ModuleStructureConfigurable rootConfigurable, @Nullable LibraryKind kind, @Nullable Library library) {
        if (rootConfigurable == null) {
            LibraryEditingUtil.$$$reportNull$$$0(2);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        LibraryType type = kind == null ? null : LibraryType.findByKind((LibraryKind)kind);
        for (Module module2 : rootConfigurable.getModules()) {
            ModuleRootModel rootModel;
            if (type != null && !type.isSuitableModule(module2, (FacetsProvider)rootConfigurable.getFacetConfigurator()) || library != null && !LibraryEditingUtil.getNotAddedSuitableLibrariesCondition(rootModel = rootConfigurable.getContext().getModulesConfigurator().getRootModel(module2), rootConfigurable.getFacetConfigurator()).apply((Object)library)) continue;
            modules.add(module2);
        }
        return modules;
    }

    public static void showDialogAndAddLibraryToDependencies(@NotNull Library library, @NotNull Project project2, boolean allowEmptySelection) {
        if (library == null) {
            LibraryEditingUtil.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            LibraryEditingUtil.$$$reportNull$$$0(4);
        }
        ProjectStructureValidator.showDialogAndAddLibraryToDependencies(library, project2, allowEmptySelection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryTablePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableModules";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAndAddLibraryToDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

