/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.compiler.ant.taskdefs.Unzip;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ExtractedDirectoryPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryPackagingElement
extends FileOrDirectoryCopyPackagingElement<ExtractedDirectoryPackagingElement> {
    private String myPathInJar;

    public ExtractedDirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE);
    }

    public ExtractedDirectoryPackagingElement(String jarPath, String pathInJar) {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, jarPath);
        this.myPathInJar = pathInJar;
        if (!StringUtil.startsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = "/" + this.myPathInJar;
        }
        if (!StringUtil.endsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = this.myPathInJar + "/";
        }
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(0);
        }
        ExtractedDirectoryPresentation extractedDirectoryPresentation = new ExtractedDirectoryPresentation(this);
        if (extractedDirectoryPresentation == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(1);
        }
        return extractedDirectoryPresentation;
    }

    public String toString() {
        return "extracted:" + this.myFilePath + "!" + this.myPathInJar;
    }

    @Override
    public VirtualFile findFile() {
        VirtualFile jarFile = super.findFile();
        if (jarFile == null) {
            return null;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
        if ("/".equals(this.myPathInJar)) {
            return jarRoot;
        }
        return jarRoot != null ? jarRoot.findFileByRelativePath(this.myPathInJar) : null;
    }

    @NotNull
    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(2);
        }
        if (creator == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(3);
        }
        if (generationContext == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(4);
        }
        if (artifactType == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(5);
        }
        String jarPath = generationContext.getSubstitutedPath(this.myFilePath);
        String pathInJar = StringUtil.trimStart((String)this.myPathInJar, (String)"/");
        if (pathInJar.length() == 0) {
            List<Generator> list = Collections.singletonList(creator.createExtractedDirectoryInstruction(jarPath));
            if (list == null) {
                ExtractedDirectoryPackagingElement.$$$reportNull$$$0(6);
            }
            return list;
        }
        String archiveName = PathUtil.getFileName((String)this.myFilePath);
        String tempDirProperty = generationContext.createNewTempFileProperty("temp.unpacked.path." + archiveName, archiveName);
        String tempDirPath = BuildProperties.propertyRef((String)tempDirProperty);
        generationContext.runBeforeCurrentArtifact((Generator)new Mkdir(tempDirPath));
        Unzip unzip = new Unzip(jarPath, tempDirPath);
        PatternSet patterns = new PatternSet(null);
        patterns.add((Generator)new Include(pathInJar + "**"));
        unzip.add((Generator)patterns);
        generationContext.runBeforeCurrentArtifact((Generator)unzip);
        List<Tag> list = Collections.singletonList(creator.createDirectoryContentCopyInstruction(tempDirPath + "/" + pathInJar));
        if (list == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(8);
        }
        return element instanceof ExtractedDirectoryPackagingElement && super.isEqualTo(element) && Comparing.equal((String)this.myPathInJar, (String)((ExtractedDirectoryPackagingElement)element).getPathInJar());
    }

    public ExtractedDirectoryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull ExtractedDirectoryPackagingElement state) {
        if (state == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(9);
        }
        this.myFilePath = state.getFilePath();
        this.myPathInJar = state.getPathInJar();
    }

    @Attribute(value="path-in-jar")
    public String getPathInJar() {
        return this.myPathInJar;
    }

    public void setPathInJar(String pathInJar) {
        this.myPathInJar = pathInJar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ExtractedDirectoryPackagingElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ExtractedDirectoryPackagingElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAntInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeAntInstructions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

