/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.Implementation;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.SofterCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

class ImplementationClassCache {
    private static final Comparator<Class> CLASS_COMPARATOR = (o1, o2) -> {
        if (o1.isAssignableFrom((Class<?>)o2)) {
            return 1;
        }
        if (o2.isAssignableFrom((Class<?>)o1)) {
            return -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        throw new AssertionError((Object)("Incompatible implementation classes: " + o1 + " & " + o2));
    };
    private final MultiMap<String, DomImplementationClassEP> myImplementationClasses = new MultiMap();
    private final SofterCache<Class, Class> myCache = SofterCache.create(dom -> this.calcImplementationClass((Class)dom));

    ImplementationClassCache(ExtensionPointName<DomImplementationClassEP> epName) {
        for (DomImplementationClassEP ep : epName.getExtensionList()) {
            this.myImplementationClasses.putValue((Object)ep.interfaceName, (Object)ep);
        }
    }

    private Class calcImplementationClass(Class concreteInterface) {
        TreeSet<Class> set = new TreeSet<Class>(CLASS_COMPARATOR);
        this.findImplementationClassDFS(concreteInterface, set);
        if (!set.isEmpty()) {
            return set.first();
        }
        Implementation implementation = (Implementation)DomReflectionUtil.findAnnotationDFS((Class)concreteInterface, Implementation.class);
        return implementation == null ? concreteInterface : implementation.value();
    }

    private void findImplementationClassDFS(Class concreteInterface, SortedSet<? super Class> results) {
        Collection values = this.myImplementationClasses.get((Object)concreteInterface.getName());
        for (DomImplementationClassEP value : values) {
            if (value.getInterfaceClass() != concreteInterface) continue;
            results.add(value.getImplementationClass());
            return;
        }
        for (Class<?> aClass1 : concreteInterface.getInterfaces()) {
            this.findImplementationClassDFS(aClass1, results);
        }
    }

    public final void registerImplementation(final Class domElementClass, final Class implementationClass, @Nullable Disposable parentDisposable) {
        DomImplementationClassEP ep = new DomImplementationClassEP(){

            @Override
            public Class getInterfaceClass() {
                return domElementClass;
            }

            @Override
            public Class getImplementationClass() {
                return implementationClass;
            }
        };
        this.myImplementationClasses.putValue((Object)domElementClass.getName(), (Object)ep);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ImplementationClassCache.this.myImplementationClasses.remove((Object)domElementClass.getName());
                }
            });
        }
        this.myCache.clearCache();
    }

    public Class get(Class key) {
        Class impl = this.myCache.getCachedValue(key);
        return impl == key ? null : impl;
    }
}

