/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.archetype.common.ArchetypeConfiguration;
import org.apache.maven.archetype.common.ArchetypeDefinition;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeCommonXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, ArchetypeDefinition archetypeDefinition) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeDefinition.getModelEncoding(), null);
        this.writeArchetypeDefinition(archetypeDefinition, "archetypeDefinition", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeArchetypeConfiguration(ArchetypeConfiguration archetypeConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        if (archetypeConfiguration != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetypeConfiguration.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "GroupId").text(archetypeConfiguration.getGroupId()).endTag(this.NAMESPACE, "GroupId");
            }
            if (archetypeConfiguration.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "ArtifactId").text(archetypeConfiguration.getArtifactId()).endTag(this.NAMESPACE, "ArtifactId");
            }
            if (archetypeConfiguration.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "Version").text(archetypeConfiguration.getVersion()).endTag(this.NAMESPACE, "Version");
            }
            if (archetypeConfiguration.getName() != null) {
                serializer.startTag(this.NAMESPACE, "Name").text(archetypeConfiguration.getName()).endTag(this.NAMESPACE, "Name");
            }
            if (archetypeConfiguration.getGoals() != null) {
                serializer.startTag(this.NAMESPACE, "goals").text(archetypeConfiguration.getGoals()).endTag(this.NAMESPACE, "goals");
            }
            if (archetypeConfiguration.getRequiredProperties() != null && archetypeConfiguration.getRequiredProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "RequiredProperties");
                Iterator iter = archetypeConfiguration.getRequiredProperties().iterator();
                while (iter.hasNext()) {
                    String requiredProperty = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "RequiredProperty").text(requiredProperty).endTag(this.NAMESPACE, "RequiredProperty");
                }
                serializer.endTag(this.NAMESPACE, "RequiredProperties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeArchetypeDefinition(ArchetypeDefinition archetypeDefinition, String tagName, XmlSerializer serializer) throws IOException {
        if (archetypeDefinition != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetypeDefinition.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "GroupId").text(archetypeDefinition.getGroupId()).endTag(this.NAMESPACE, "GroupId");
            }
            if (archetypeDefinition.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "ArtifactId").text(archetypeDefinition.getArtifactId()).endTag(this.NAMESPACE, "ArtifactId");
            }
            if (archetypeDefinition.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "Version").text(archetypeDefinition.getVersion()).endTag(this.NAMESPACE, "Version");
            }
            if (archetypeDefinition.getName() != null) {
                serializer.startTag(this.NAMESPACE, "Name").text(archetypeDefinition.getName()).endTag(this.NAMESPACE, "Name");
            }
            if (archetypeDefinition.getRepository() != null) {
                serializer.startTag(this.NAMESPACE, "repository").text(archetypeDefinition.getRepository()).endTag(this.NAMESPACE, "repository");
            }
            if (archetypeDefinition.getGoals() != null) {
                serializer.startTag(this.NAMESPACE, "goals").text(archetypeDefinition.getGoals()).endTag(this.NAMESPACE, "goals");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

