/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.Rule;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DefaultDomainObjectCollection;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.internal.metaobject.PropertyAccess;
import org.gradle.internal.metaobject.PropertyMixIn;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public class DefaultNamedDomainObjectCollection<T>
extends DefaultDomainObjectCollection<T>
implements NamedDomainObjectCollection<T>,
MethodMixIn,
PropertyMixIn {
    private final Instantiator instantiator;
    private final Namer<? super T> namer;
    private final Index<T> index;
    private final ContainerElementsDynamicObject elementsDynamicObject = new ContainerElementsDynamicObject();
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Set<String> applyingRulesFor = new HashSet<String>();
    private ImmutableActionSet<ElementInfo<T>> whenKnown = ImmutableActionSet.empty();

    public DefaultNamedDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, Instantiator instantiator, Namer<? super T> namer) {
        super(type, store);
        this.instantiator = instantiator;
        this.namer = namer;
        this.index = new UnfilteredIndex();
        this.index();
    }

    protected void index() {
        for (Object t : this.getStore()) {
            this.index.put(this.namer.determineName(t), t);
        }
    }

    protected DefaultNamedDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, CollectionEventRegister<T> eventRegister, Index<T> index, Instantiator instantiator, Namer<? super T> namer) {
        super(type, store, eventRegister);
        this.instantiator = instantiator;
        this.namer = namer;
        this.index = index;
    }

    public DefaultNamedDomainObjectCollection(DefaultNamedDomainObjectCollection<? super T> collection, CollectionFilter<T> filter, Instantiator instantiator, Namer<? super T> namer) {
        this(filter.getType(), collection.filteredStore(filter), collection.filteredEvents(filter), collection.filteredIndex(filter), instantiator, namer);
    }

    @Override
    public boolean add(T o) {
        return this.add(o, this.getEventRegister().getAddActions());
    }

    @Override
    protected <I extends T> boolean add(I o, Action<? super I> notification) {
        String name = this.namer.determineName(o);
        if (this.index.get(name) == null) {
            boolean added = super.add(o, notification);
            if (added) {
                this.whenKnown.execute(new ObjectBackedElementInfo<I>(name, o));
            }
            return added;
        }
        this.handleAttemptToAddItemWithNonUniqueName(o);
        return false;
    }

    @Override
    protected void realized(ProviderInternal<? extends T> provider) {
        super.realized(provider);
        this.index.removePending(provider);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = super.addAll(c);
        if (changed) {
            for (T t : c) {
                String name = this.namer.determineName(t);
                this.whenKnown.execute(new ObjectBackedElementInfo<T>(name, t));
            }
        }
        return changed;
    }

    @Override
    public void addLater(Provider<? extends T> provider) {
        super.addLater(provider);
        if (provider instanceof Named) {
            Named named = (Named)((Object)provider);
            this.index.putPending(named.getName(), (ProviderInternal)provider);
            this.deferredElementKnown(named.getName(), provider);
        }
    }

    public void whenElementKnown(Action<? super ElementInfo<T>> action) {
        this.whenKnown = this.whenKnown.add(action);
        Iterator iterator = this.iteratorNoFlush();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            this.whenKnown.execute(new ObjectBackedElementInfo(this.namer.determineName(next), next));
        }
        for (Map.Entry<String, ProviderInternal<T>> entry : this.index.getPendingAsMap().entrySet()) {
            this.deferredElementKnown(entry.getKey(), (Provider)entry.getValue());
        }
    }

    protected final void deferredElementKnown(String name, Provider<? extends T> provider) {
        this.whenKnown.execute(new ProviderBackedElementInfo<T>(name, provider));
    }

    @Override
    protected void didAdd(T toAdd) {
        this.index.put(this.namer.determineName(toAdd), toAdd);
    }

    @Override
    public void clear() {
        super.clear();
        this.index.clear();
    }

    @Override
    protected void didRemove(T t) {
        this.index.remove(this.namer.determineName(t));
    }

    protected void handleAttemptToAddItemWithNonUniqueName(T o) {
    }

    protected void assertCanAdd(String name) {
        if (this.hasWithName(name)) {
            throw new InvalidUserDataException(String.format("Cannot add a %s with name '%s' as a %s with that name already exists.", this.getTypeDisplayName(), name, this.getTypeDisplayName()));
        }
    }

    protected void assertCanAdd(T t) {
        this.assertCanAdd(this.getNamer().determineName(t));
    }

    @Override
    public Namer<T> getNamer() {
        return this.namer;
    }

    protected Instantiator getInstantiator() {
        return this.instantiator;
    }

    protected <S extends T> Index<S> filteredIndex(CollectionFilter<S> filter) {
        return this.index.filter(filter);
    }

    @Override
    protected <S extends T> DefaultNamedDomainObjectCollection<S> filtered(CollectionFilter<S> filter) {
        return this.instantiator.newInstance(DefaultNamedDomainObjectCollection.class, this, filter, this.instantiator, this.namer);
    }

    public String getDisplayName() {
        return this.getTypeDisplayName() + " container";
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public SortedMap<String, T> getAsMap() {
        return this.index.asMap();
    }

    @Override
    public SortedSet<String> getNames() {
        NavigableSet<String> realizedNames = this.index.asMap().navigableKeySet();
        Set<String> pendingNames = this.index.getPendingAsMap().keySet();
        if (pendingNames.isEmpty()) {
            return realizedNames;
        }
        TreeSet<String> allNames = new TreeSet<String>((SortedSet<String>)realizedNames);
        allNames.addAll(pendingNames);
        return allNames;
    }

    @Override
    public <S extends T> NamedDomainObjectCollection<S> withType(Class<S> type) {
        return this.filtered((CollectionFilter)this.createFilter(type));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec(spec));
    }

    @Override
    public T findByName(String name) {
        T value = this.findByNameWithoutRules(name);
        if (value != null) {
            return value;
        }
        ProviderInternal<T> provider = this.index.getPending(name);
        if (provider != null) {
            provider.getOrNull();
            return this.index.get(name);
        }
        if (!this.applyRules(name)) {
            return null;
        }
        return this.findByNameWithoutRules(name);
    }

    protected boolean hasWithName(String name) {
        return this.index.get(name) != null || this.index.getPending(name) != null;
    }

    @Nullable
    protected T findByNameWithoutRules(String name) {
        return this.index.get(name);
    }

    @Nullable
    protected ProviderInternal<? extends T> findByNameLaterWithoutRules(String name) {
        return this.index.getPending(name);
    }

    protected T removeByName(String name) {
        T it = this.getByName(name);
        if (it != null) {
            if (this.remove(it)) {
                return it;
            }
            throw new IllegalStateException(String.format("found '%s' with name '%s' but remove() returned false", it, name));
        }
        return null;
    }

    @Override
    public T getByName(String name) throws UnknownDomainObjectException {
        T t = this.findByName(name);
        if (t == null) {
            throw this.createNotFoundException(name);
        }
        return t;
    }

    @Override
    public T getByName(String name, Closure configureClosure) throws UnknownDomainObjectException {
        T t = this.getByName(name);
        ConfigureUtil.configure(configureClosure, t);
        return t;
    }

    @Override
    public T getByName(String name, Action<? super T> configureAction) throws UnknownDomainObjectException {
        T t = this.getByName(name);
        configureAction.execute(t);
        return t;
    }

    @Override
    public T getAt(String name) throws UnknownDomainObjectException {
        return this.getByName(name);
    }

    @Override
    public NamedDomainObjectProvider<T> named(String name) throws UnknownTaskException {
        NamedDomainObjectProvider<T> provider = this.findDomainObject(name);
        if (provider == null) {
            throw this.createNotFoundException(name);
        }
        return (NamedDomainObjectProvider)Cast.uncheckedCast(provider);
    }

    @Override
    public MethodAccess getAdditionalMethods() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public PropertyAccess getAdditionalProperties() {
        return this.getElementsAsDynamicObject();
    }

    protected DynamicObject getElementsAsDynamicObject() {
        return this.elementsDynamicObject;
    }

    @Override
    public NamedDomainObjectCollectionSchema getCollectionSchema() {
        return new NamedDomainObjectCollectionSchema(){

            @Override
            public Iterable<? extends NamedDomainObjectCollectionSchema.NamedDomainObjectSchema> getElements() {
                return Iterables.concat((Iterable)Iterables.transform(DefaultNamedDomainObjectCollection.this.index.asMap().entrySet(), (Function)new Function<Map.Entry<String, T>, NamedDomainObjectCollectionSchema.NamedDomainObjectSchema>(){

                    public NamedDomainObjectCollectionSchema.NamedDomainObjectSchema apply(final Map.Entry<String, T> e) {
                        return new NamedDomainObjectCollectionSchema.NamedDomainObjectSchema(){

                            @Override
                            public String getName() {
                                return (String)e.getKey();
                            }

                            @Override
                            public TypeOf<?> getPublicType() {
                                return TypeOf.typeOf(new DslObject(e.getValue()).getDeclaredType());
                            }
                        };
                    }
                }), (Iterable)Iterables.transform(DefaultNamedDomainObjectCollection.this.index.getPendingAsMap().entrySet(), (Function)new Function<Map.Entry<String, ProviderInternal<? extends T>>, NamedDomainObjectCollectionSchema.NamedDomainObjectSchema>(){

                    public NamedDomainObjectCollectionSchema.NamedDomainObjectSchema apply(final Map.Entry<String, ProviderInternal<? extends T>> e) {
                        return new NamedDomainObjectCollectionSchema.NamedDomainObjectSchema(){

                            @Override
                            public String getName() {
                                return (String)e.getKey();
                            }

                            @Override
                            public TypeOf<?> getPublicType() {
                                return TypeOf.typeOf(((ProviderInternal)e.getValue()).getType());
                            }
                        };
                    }
                }));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyRules(String name) {
        if (this.rules.isEmpty() || this.applyingRulesFor.contains(name)) {
            return false;
        }
        this.applyingRulesFor.add(name);
        try {
            for (Rule rule : this.rules) {
                rule.apply(name);
            }
        }
        finally {
            this.applyingRulesFor.remove(name);
        }
        return true;
    }

    @Override
    public Rule addRule(Rule rule) {
        this.rules.add(rule);
        return rule;
    }

    @Override
    public Rule addRule(String description, final Closure ruleAction) {
        return this.addRule(new RuleAdapter(description){

            @Override
            public void apply(String domainObjectName) {
                ruleAction.call((Object)domainObjectName);
            }
        });
    }

    @Override
    public Rule addRule(String description, final Action<String> ruleAction) {
        return this.addRule(new RuleAdapter(description){

            @Override
            public void apply(String domainObjectName) {
                ruleAction.execute(domainObjectName);
            }
        });
    }

    @Override
    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownDomainObjectException(String.format("%s with name '%s' not found.", this.getTypeDisplayName(), name));
    }

    protected String getTypeDisplayName() {
        return this.getType().getSimpleName();
    }

    @Nullable
    protected NamedDomainObjectProvider<? extends T> findDomainObject(String name) {
        NamedDomainObjectProvider<T> provider = this.searchForDomainObject(name);
        if (provider == null && this.applyRules(name)) {
            return this.searchForDomainObject(name);
        }
        return provider;
    }

    @Nullable
    private NamedDomainObjectProvider<? extends T> searchForDomainObject(String name) {
        T object = this.findByNameWithoutRules(name);
        if (object != null) {
            return this.createExistingProvider(name, object);
        }
        ProviderInternal<T> provider = this.findByNameLaterWithoutRules(name);
        if (provider != null) {
            return (NamedDomainObjectProvider)Cast.uncheckedCast(provider);
        }
        return null;
    }

    protected NamedDomainObjectProvider<? extends T> createExistingProvider(String name, T object) {
        return (NamedDomainObjectProvider)Cast.uncheckedCast(this.getInstantiator().newInstance(ExistingNamedDomainObjectProvider.class, this, object, name));
    }

    protected class ExistingNamedDomainObjectProvider<I extends T>
    extends AbstractNamedDomainObjectProvider<I> {
        private final I object;

        public ExistingNamedDomainObjectProvider(I object, String name) {
            super(name);
            this.object = object;
        }

        @Override
        public void configure(Action<? super I> action) {
            action.execute(this.object);
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public I getOrNull() {
            return this.object;
        }
    }

    protected abstract class AbstractNamedDomainObjectProvider<I extends T>
    extends AbstractProvider<I>
    implements Named,
    NamedDomainObjectProvider<I> {
        private final String name;

        protected AbstractNamedDomainObjectProvider(String name) {
            this.name = name;
        }

        @Override
        @Nullable
        public Class<I> getType() {
            return DefaultNamedDomainObjectCollection.this.getType();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isPresent() {
            return DefaultNamedDomainObjectCollection.this.findDomainObject(this.name) != null;
        }

        @Override
        public String toString() {
            return String.format("provider(%s %s, %s)", DefaultNamedDomainObjectCollection.this.getTypeDisplayName(), this.getName(), this.getType());
        }
    }

    private static class ProviderBackedElementInfo<T>
    implements ElementInfo<T> {
        private final String name;
        private final Provider<? extends T> provider;

        ProviderBackedElementInfo(String name, Provider<? extends T> provider) {
            this.name = name;
            this.provider = provider;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return ((ProviderInternal)this.provider).getType();
        }
    }

    private static class ObjectBackedElementInfo<T>
    implements ElementInfo<T> {
        private final String name;
        private final T o;

        ObjectBackedElementInfo(String name, T o) {
            this.name = name;
            this.o = o;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return new DslObject(this.o).getDeclaredType();
        }
    }

    public static interface ElementInfo<T> {
        public String getName();

        public Class<?> getType();
    }

    private static class FilteredIndex<T>
    implements Index<T> {
        private final Index<? super T> delegate;
        private final CollectionFilter<T> filter;

        FilteredIndex(Index<? super T> delegate, CollectionFilter<T> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        @Override
        public void put(String name, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(String name) {
            return this.filter.filter(this.delegate.get(name));
        }

        @Override
        public void remove(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<String, T> asMap() {
            NavigableMap<String, T> delegateMap = this.delegate.asMap();
            TreeMap filtered = new TreeMap();
            for (Map.Entry entry : delegateMap.entrySet()) {
                T obj = this.filter.filter(entry.getValue());
                if (obj == null) continue;
                filtered.put(entry.getKey(), obj);
            }
            return filtered;
        }

        @Override
        public <S extends T> Index<S> filter(CollectionFilter<S> filter) {
            return new FilteredIndex<T>(this.delegate, this.filter.and(filter));
        }

        @Override
        @Nullable
        public ProviderInternal<? extends T> getPending(String name) {
            ProviderInternal<T> provider = this.delegate.getPending(name);
            if (provider != null && provider.getType() != null && this.filter.getType().isAssignableFrom(provider.getType())) {
                return provider;
            }
            return null;
        }

        @Override
        public void putPending(String name, ProviderInternal<? extends T> provider) {
            this.delegate.putPending(name, provider);
        }

        @Override
        public void removePending(String name) {
            this.delegate.removePending(name);
        }

        @Override
        public void removePending(ProviderInternal<? extends T> provider) {
            this.delegate.removePending(provider);
        }

        @Override
        public Map<String, ProviderInternal<? extends T>> getPendingAsMap() {
            Map delegateMap = (Map)Cast.uncheckedCast(this.delegate.getPendingAsMap());
            LinkedHashMap filteredMap = Maps.newLinkedHashMap();
            for (Map.Entry entry : delegateMap.entrySet()) {
                if (((ProviderInternal)entry.getValue()).getType() == null || !this.filter.getType().isAssignableFrom(((ProviderInternal)entry.getValue()).getType())) continue;
                ProviderInternal typedValue = (ProviderInternal)Cast.uncheckedCast(entry.getValue());
                filteredMap.put(entry.getKey(), typedValue);
            }
            return filteredMap;
        }
    }

    protected static class UnfilteredIndex<T>
    implements Index<T> {
        private final Map<String, ProviderInternal<? extends T>> pendingMap = Maps.newLinkedHashMap();
        private final NavigableMap<String, T> map = new TreeMap<String, T>();

        protected UnfilteredIndex() {
        }

        @Override
        public NavigableMap<String, T> asMap() {
            return this.map;
        }

        @Override
        public void put(String name, T value) {
            this.map.put(name, value);
        }

        @Override
        public T get(String name) {
            return (T)this.map.get(name);
        }

        @Override
        public void remove(String name) {
            this.map.remove(name);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public <S extends T> Index<S> filter(CollectionFilter<S> filter) {
            return new FilteredIndex<S>(this, filter);
        }

        @Override
        @Nullable
        public ProviderInternal<? extends T> getPending(String name) {
            return this.pendingMap.get(name);
        }

        @Override
        public void putPending(String name, ProviderInternal<? extends T> provider) {
            this.pendingMap.put(name, provider);
        }

        @Override
        public void removePending(String name) {
            this.pendingMap.remove(name);
        }

        @Override
        public void removePending(ProviderInternal<? extends T> provider) {
            this.pendingMap.values().remove(provider);
        }

        @Override
        public Map<String, ProviderInternal<? extends T>> getPendingAsMap() {
            return this.pendingMap;
        }
    }

    protected static interface Index<T> {
        public void put(String var1, T var2);

        @Nullable
        public T get(String var1);

        public void remove(String var1);

        public void clear();

        public NavigableMap<String, T> asMap();

        public <S extends T> Index<S> filter(CollectionFilter<S> var1);

        @Nullable
        public ProviderInternal<? extends T> getPending(String var1);

        public void putPending(String var1, ProviderInternal<? extends T> var2);

        public void removePending(String var1);

        public void removePending(ProviderInternal<? extends T> var1);

        public Map<String, ProviderInternal<? extends T>> getPendingAsMap();
    }

    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        @Override
        public String getDisplayName() {
            return DefaultNamedDomainObjectCollection.this.getDisplayName();
        }

        @Override
        public boolean hasProperty(String name) {
            return DefaultNamedDomainObjectCollection.this.findByName(name) != null;
        }

        @Override
        public DynamicInvokeResult tryGetProperty(String name) {
            Object t = DefaultNamedDomainObjectCollection.this.findByName(name);
            return t == null ? DynamicInvokeResult.notFound() : DynamicInvokeResult.found(t);
        }

        public Map<String, T> getProperties() {
            return DefaultNamedDomainObjectCollection.this.getAsMap();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return this.isConfigureMethod(name, arguments);
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (this.isConfigureMethod(name, arguments)) {
                return DynamicInvokeResult.found(ConfigureUtil.configure((Closure)arguments[0], DefaultNamedDomainObjectCollection.this.getByName(name)));
            }
            return DynamicInvokeResult.notFound();
        }

        private boolean isConfigureMethod(String name, Object ... arguments) {
            return arguments.length == 1 && arguments[0] instanceof Closure && this.hasProperty(name);
        }
    }

    private static abstract class RuleAdapter
    implements Rule {
        private final String description;

        RuleAdapter(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "Rule: " + this.description;
        }
    }
}

