/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.GUtil;

public class DefaultImmutableVersionConstraint
extends AbstractVersionConstraint
implements ImmutableVersionConstraint {
    private static final DefaultImmutableVersionConstraint EMPTY = new DefaultImmutableVersionConstraint("");
    private final String requiredVersion;
    private final String preferredVersion;
    private final String strictVersion;
    private final ImmutableList<String> rejectedVersions;
    @Nullable
    private final String requiredBranch;
    private final int hashCode;

    public DefaultImmutableVersionConstraint(String preferredVersion, String requiredVersion, String strictVersion, List<String> rejectedVersions) {
        this(preferredVersion, requiredVersion, strictVersion, rejectedVersions, null);
    }

    public DefaultImmutableVersionConstraint(String preferredVersion, String requiredVersion, String strictVersion, List<String> rejectedVersions, @Nullable String requiredBranch) {
        if (preferredVersion == null) {
            throw new IllegalArgumentException("Preferred version must not be null");
        }
        if (requiredVersion == null) {
            throw new IllegalArgumentException("Required version must not be null");
        }
        if (strictVersion == null) {
            throw new IllegalArgumentException("Strict version must not be null");
        }
        if (rejectedVersions == null) {
            throw new IllegalArgumentException("Rejected versions must not be null");
        }
        for (String rejectedVersion : rejectedVersions) {
            if (GUtil.isTrue(rejectedVersion)) continue;
            throw new IllegalArgumentException("Rejected version must not be empty");
        }
        this.preferredVersion = preferredVersion;
        this.requiredVersion = requiredVersion;
        this.strictVersion = strictVersion;
        this.rejectedVersions = ImmutableList.copyOf(rejectedVersions);
        this.requiredBranch = requiredBranch;
        this.hashCode = super.hashCode();
    }

    public DefaultImmutableVersionConstraint(String requiredVersion) {
        if (requiredVersion == null) {
            throw new IllegalArgumentException("Required version must not be null");
        }
        this.preferredVersion = requiredVersion;
        this.requiredVersion = requiredVersion;
        this.strictVersion = "";
        this.rejectedVersions = ImmutableList.of();
        this.requiredBranch = null;
        this.hashCode = super.hashCode();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.requiredBranch;
    }

    @Override
    public String getRequiredVersion() {
        return this.requiredVersion;
    }

    @Override
    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public String getStrictVersion() {
        return this.strictVersion;
    }

    @Override
    public List<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    public static ImmutableVersionConstraint of(VersionConstraint versionConstraint) {
        if (versionConstraint instanceof ImmutableVersionConstraint) {
            return (ImmutableVersionConstraint)versionConstraint;
        }
        return new DefaultImmutableVersionConstraint(versionConstraint.getPreferredVersion(), versionConstraint.getRequiredVersion(), versionConstraint.getStrictVersion(), versionConstraint.getRejectedVersions());
    }

    public static ImmutableVersionConstraint of(String version) {
        if (version == null) {
            return DefaultImmutableVersionConstraint.of();
        }
        return new DefaultImmutableVersionConstraint(version);
    }

    public static ImmutableVersionConstraint of(String preferredVersion, String requiredVersion, String strictVersion, List<String> rejects) {
        return new DefaultImmutableVersionConstraint(preferredVersion, requiredVersion, strictVersion, rejects);
    }

    public static ImmutableVersionConstraint of() {
        return EMPTY;
    }
}

