/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public abstract class AbstractBaseDirFileResolver
extends AbstractFileResolver {
    public AbstractBaseDirFileResolver(FileSystem fileSystem, Factory<PatternSet> patternSetFactory) {
        super(fileSystem, patternSetFactory);
    }

    protected abstract File getBaseDir();

    @Override
    public String resolveAsRelativePath(Object path) {
        int prefixLen;
        List<String> basePath = Arrays.asList(StringUtils.split((String)this.getBaseDir().getAbsolutePath(), (String)("/" + File.separator)));
        File targetFile = this.resolve(path);
        List<String> targetPath = new ArrayList<String>(Arrays.asList(StringUtils.split((String)targetFile.getAbsolutePath(), (String)("/" + File.separator))));
        int maxDepth = Math.min(basePath.size(), targetPath.size());
        for (prefixLen = 0; prefixLen < maxDepth && basePath.get(prefixLen).equals(targetPath.get(prefixLen)); ++prefixLen) {
        }
        basePath = basePath.subList(prefixLen, basePath.size());
        targetPath = targetPath.subList(prefixLen, targetPath.size());
        for (int i = 0; i < basePath.size(); ++i) {
            targetPath.add(0, "..");
        }
        if (targetPath.isEmpty()) {
            return ".";
        }
        return CollectionUtils.join(File.separator, targetPath);
    }

    @Override
    protected File doResolve(Object path) {
        if (!GUtil.isTrue(path)) {
            throw new IllegalArgumentException(String.format("path may not be null or empty string. path='%s'", path));
        }
        File file = this.convertObjectToFile(path);
        if (file == null) {
            throw new IllegalArgumentException(String.format("Cannot convert path to File. path='%s'", path));
        }
        if (!file.isAbsolute()) {
            File baseDir = this.getBaseDir();
            if (!GUtil.isTrue(baseDir)) {
                throw new IllegalArgumentException(String.format("baseDir may not be null or empty string. basedir='%s'", baseDir));
            }
            file = new File(baseDir, file.getPath());
        }
        return file;
    }

    @Override
    public boolean canResolveRelativePath() {
        return true;
    }
}

