/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.OutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.org.apache.tools.tar.TarEntry;
import org.gradle.internal.impldep.org.apache.tools.tar.TarOutputStream;

public class TarCopyAction
implements CopyAction {
    public static final long CONSTANT_TIME_FOR_TAR_ENTRIES = 0L;
    private final File tarFile;
    private final ArchiveOutputStreamFactory compressor;
    private final boolean preserveFileTimestamps;

    public TarCopyAction(File tarFile, ArchiveOutputStreamFactory compressor, boolean preserveFileTimestamps) {
        this.tarFile = tarFile;
        this.compressor = compressor;
        this.preserveFileTimestamps = preserveFileTimestamps;
    }

    @Override
    public WorkResult execute(final CopyActionProcessingStream stream) {
        OutputStream outStr;
        try {
            outStr = this.compressor.createArchiveOutputStream(this.tarFile);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create TAR '%s'.", this.tarFile), e);
        }
        IoActions.withResource(outStr, new ErroringAction<OutputStream>(){

            @Override
            protected void doExecute(OutputStream outStr) throws Exception {
                TarOutputStream tarOutStr;
                try {
                    tarOutStr = new TarOutputStream(outStr);
                }
                catch (Exception e) {
                    throw new GradleException(String.format("Could not create TAR '%s'.", TarCopyAction.this.tarFile), e);
                }
                tarOutStr.setLongFileMode(2);
                stream.process(new StreamAction(tarOutStr));
                tarOutStr.close();
            }
        });
        return WorkResults.didWork(true);
    }

    private long getArchiveTimeFor(FileCopyDetails details) {
        return this.preserveFileTimestamps ? details.getLastModified() : 0L;
    }

    private class StreamAction
    implements CopyActionProcessingStreamAction {
        private final TarOutputStream tarOutStr;

        public StreamAction(TarOutputStream tarOutStr) {
            this.tarOutStr = tarOutStr;
        }

        @Override
        public void processFile(FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                this.visitDir(details);
            } else {
                this.visitFile(details);
            }
        }

        private void visitFile(FileCopyDetails fileDetails) {
            try {
                TarEntry archiveEntry = new TarEntry(fileDetails.getRelativePath().getPathString());
                archiveEntry.setModTime(TarCopyAction.this.getArchiveTimeFor(fileDetails));
                archiveEntry.setSize(fileDetails.getSize());
                archiveEntry.setMode(0x8000 | fileDetails.getMode());
                this.tarOutStr.putNextEntry(archiveEntry);
                fileDetails.copyTo((OutputStream)this.tarOutStr);
                this.tarOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to TAR '%s'.", fileDetails, TarCopyAction.this.tarFile), e);
            }
        }

        private void visitDir(FileCopyDetails dirDetails) {
            try {
                TarEntry archiveEntry = new TarEntry(dirDetails.getRelativePath().getPathString() + '/');
                archiveEntry.setModTime(TarCopyAction.this.getArchiveTimeFor(dirDetails));
                archiveEntry.setMode(0x4000 | dirDetails.getMode());
                this.tarOutStr.putNextEntry(archiveEntry);
                this.tarOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to TAR '%s'.", dirDetails, TarCopyAction.this.tarFile), e);
            }
        }
    }
}

