/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.nio.charset.Charset;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalker;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.internal.file.collections.jdk7.Jdk7DirectoryWalker;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

public class DefaultDirectoryWalkerFactory
implements Factory<DirectoryWalker> {
    private final JavaVersion javaVersion;
    private final FileSystem fileSystem;
    private DirectoryWalker instance;

    public DefaultDirectoryWalkerFactory(JavaVersion javaVersion, FileSystem fileSystem) {
        this.javaVersion = javaVersion;
        this.fileSystem = fileSystem;
        this.reset();
    }

    DefaultDirectoryWalkerFactory() {
        this(JavaVersion.current(), FileSystems.getDefault());
    }

    @Override
    public DirectoryWalker create() {
        return this.instance;
    }

    private void reset() {
        this.instance = this.createInstance();
    }

    private DirectoryWalker createInstance() {
        if (this.javaVersion.isJava8Compatible() || this.javaVersion.isJava7Compatible() && this.defaultEncodingContainsPlatformEncoding()) {
            return new Jdk7DirectoryWalker(this.fileSystem);
        }
        return new DefaultDirectoryWalker(this.fileSystem);
    }

    private boolean defaultEncodingContainsPlatformEncoding() {
        String platformEncoding = System.getProperty("sun.jnu.encoding");
        Charset platformCharset = platformEncoding != null && Charset.isSupported(platformEncoding) ? Charset.forName(platformEncoding) : null;
        Charset requiredCharset = platformCharset != null ? platformCharset : Charsets.UTF_8;
        return Charset.defaultCharset().contains(requiredCharset);
    }
}

