/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.TaskOutputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;
import org.gradle.internal.fingerprint.OutputNormalizer;

@NonNullApi
abstract class AbstractTaskOutputPropertySpec
extends TaskOutputsDeprecationSupport
implements TaskPropertySpec,
TaskOutputFilePropertyBuilder {
    private String propertyName;
    private boolean optional;

    AbstractTaskOutputPropertySpec() {
    }

    @Override
    public TaskOutputFilePropertyBuilder withPropertyName(String propertyName) {
        this.propertyName = TaskPropertyUtils.checkPropertyName(propertyName);
        return this;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    protected boolean isOptional() {
        return this.optional;
    }

    @Override
    public TaskOutputFilePropertyBuilder optional() {
        return this.optional(true);
    }

    @Override
    public TaskOutputFilePropertyBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public String toString() {
        return this.getPropertyName() + " (Output)";
    }

    public Class<? extends FileNormalizer> getNormalizer() {
        return OutputNormalizer.class;
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }
}

