/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.CollectionUtils;

public class NormalizingGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(NormalizingGroovyCompiler.class);
    private final Compiler<GroovyJavaJointCompileSpec> delegate;

    public NormalizingGroovyCompiler(Compiler<GroovyJavaJointCompileSpec> delegate) {
        this.delegate = delegate;
    }

    @Override
    public WorkResult execute(GroovyJavaJointCompileSpec spec) {
        this.resolveAndFilterSourceFiles(spec);
        this.resolveClasspath(spec);
        this.resolveNonStringsInCompilerArgs(spec);
        this.logSourceFiles(spec);
        this.logCompilerArguments(spec);
        return this.delegateAndHandleErrors(spec);
    }

    private void resolveAndFilterSourceFiles(GroovyJavaJointCompileSpec spec) {
        final List<String> fileExtensions = CollectionUtils.collect(spec.getGroovyCompileOptions().getFileExtensions(), new Transformer<String, String>(){

            @Override
            public String transform(String extension) {
                return '.' + extension;
            }
        });
        Iterable filtered = Iterables.filter(spec.getSourceFiles(), (Predicate)new Predicate<File>(){

            public boolean apply(File element) {
                for (String fileExtension : fileExtensions) {
                    if (!FileUtils.hasExtension(element, fileExtension)) continue;
                    return true;
                }
                return false;
            }
        });
        spec.setSourceFiles((Iterable<File>)ImmutableSet.copyOf((Iterable)filtered));
    }

    private void resolveClasspath(GroovyJavaJointCompileSpec spec) {
        ArrayList classPath = Lists.newArrayList(spec.getCompileClasspath());
        classPath.add(spec.getDestinationDir());
        spec.setCompileClasspath(classPath);
    }

    private void resolveNonStringsInCompilerArgs(GroovyJavaJointCompileSpec spec) {
        spec.getCompileOptions().setCompilerArgs(CollectionUtils.toStringList(spec.getCompileOptions().getCompilerArgs()));
    }

    private void logSourceFiles(GroovyJavaJointCompileSpec spec) {
        if (!spec.getGroovyCompileOptions().isListFiles()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Source files to be compiled:");
        for (File file : spec.getSourceFiles()) {
            builder.append('\n');
            builder.append(file);
        }
        LOGGER.quiet(builder.toString());
    }

    private void logCompilerArguments(GroovyJavaJointCompileSpec spec) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        List<String> compilerArgs = new JavaCompilerArgumentsBuilder(spec).includeLauncherOptions(true).includeSourceFiles(true).build();
        String joinedArgs = Joiner.on((char)' ').join(compilerArgs);
        LOGGER.debug("Java compiler arguments: {}", joinedArgs);
    }

    private WorkResult delegateAndHandleErrors(GroovyJavaJointCompileSpec spec) {
        try {
            return this.delegate.execute(spec);
        }
        catch (RuntimeException e) {
            if (spec.getCompileOptions().isFailOnError() && spec.getGroovyCompileOptions().isFailOnError() || !CompilationFailedException.class.getName().equals(e.getClass().getName())) {
                throw e;
            }
            LOGGER.debug("Ignoring compilation failure.");
            return WorkResults.didWork(false);
        }
    }
}

