/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.compile.GroovyForkOptions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerFactory;

public class DaemonGroovyCompiler
extends AbstractDaemonCompiler<GroovyJavaJointCompileSpec> {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("groovy", "org.codehaus.groovy", "groovyjarjarantlr", "groovyjarjarasm", "org/gradle/internal/impldep/groovyjarjarcommonscli", "org.apache.tools.ant", "com.sun.tools.javac");
    private final ClassPathRegistry classPathRegistry;
    private final PathToFileResolver fileResolver;
    private final File daemonWorkingDir;

    public DaemonGroovyCompiler(File daemonWorkingDir, Compiler<GroovyJavaJointCompileSpec> delegate, ClassPathRegistry classPathRegistry, WorkerFactory workerFactory, PathToFileResolver fileResolver) {
        super(delegate, workerFactory);
        this.classPathRegistry = classPathRegistry;
        this.fileResolver = fileResolver;
        this.daemonWorkingDir = daemonWorkingDir;
    }

    @Override
    protected AbstractDaemonCompiler.InvocationContext toInvocationContext(GroovyJavaJointCompileSpec spec) {
        ForkOptions javaOptions = spec.getCompileOptions().getForkOptions();
        GroovyForkOptions groovyOptions = spec.getGroovyCompileOptions().getForkOptions();
        List<File> antFiles = this.classPathRegistry.getClassPath("ANT").getAsFiles();
        Iterable groovyFiles = Iterables.concat(spec.getGroovyClasspath(), antFiles);
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.fileResolver).transform(this.mergeForkOptions(javaOptions, groovyOptions));
        File invocationWorkingDir = javaForkOptions.getWorkingDir();
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        DaemonForkOptions daemonForkOptions = new DaemonForkOptionsBuilder(this.fileResolver).javaForkOptions(javaForkOptions).classpath(groovyFiles).sharedPackages(SHARED_PACKAGES).keepAliveMode(KeepAliveMode.SESSION).build();
        return new AbstractDaemonCompiler.InvocationContext(invocationWorkingDir, daemonForkOptions);
    }
}

