/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.FileOutcomeIdentifier;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcome;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.tooling.model.internal.outcomes.GradleBuildOutcome;
import org.gradle.tooling.model.internal.outcomes.GradleFileBuildOutcome;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.util.RelativePathUtil;

public class GradleBuildOutcomeSetTransformer
implements Transformer<Set<BuildOutcome>, ProjectOutcomes> {
    private final FileStore<String> fileStore;
    private final String fileStorePrefix;
    private final List<String> zipArchiveTypes = Arrays.asList(FileOutcomeIdentifier.JAR_ARTIFACT.getTypeIdentifier(), FileOutcomeIdentifier.EAR_ARTIFACT.getTypeIdentifier(), FileOutcomeIdentifier.WAR_ARTIFACT.getTypeIdentifier(), FileOutcomeIdentifier.ZIP_ARTIFACT.getTypeIdentifier());

    public GradleBuildOutcomeSetTransformer(FileStore<String> fileStore, String fileStorePrefix) {
        this.fileStore = fileStore;
        this.fileStorePrefix = fileStorePrefix;
    }

    @Override
    public Set<BuildOutcome> transform(ProjectOutcomes rootProject) {
        HashSet<BuildOutcome> keyedOutcomes = new HashSet<BuildOutcome>();
        this.addBuildOutcomes(rootProject, rootProject, keyedOutcomes);
        return keyedOutcomes;
    }

    private void addBuildOutcomes(ProjectOutcomes projectOutcomes, ProjectOutcomes rootProject, Set<BuildOutcome> buildOutcomes) {
        for (GradleBuildOutcome gradleBuildOutcome : projectOutcomes.getOutcomes()) {
            if (gradleBuildOutcome instanceof GradleFileBuildOutcome) {
                this.addFileBuildOutcome((GradleFileBuildOutcome)gradleBuildOutcome, rootProject, buildOutcomes);
                continue;
            }
            new UnknownBuildOutcome(gradleBuildOutcome.getTaskPath(), gradleBuildOutcome.getDescription());
        }
        for (ProjectOutcomes projectOutcomes2 : projectOutcomes.getChildren()) {
            this.addBuildOutcomes(projectOutcomes2, rootProject, buildOutcomes);
        }
    }

    private void addFileBuildOutcome(GradleFileBuildOutcome outcome, ProjectOutcomes rootProject, Set<BuildOutcome> translatedOutcomes) {
        if (this.zipArchiveTypes.contains(outcome.getTypeIdentifier())) {
            File originalFile = outcome.getFile();
            String relativePath = RelativePathUtil.relativePath(rootProject.getProjectDirectory(), originalFile);
            LocallyAvailableResource resource = null;
            if (originalFile.exists()) {
                String filestoreDestination = this.fileStorePrefix + "/" + outcome.getTaskPath() + "/" + originalFile.getName();
                resource = this.fileStore.move(filestoreDestination, originalFile);
            }
            GeneratedArchiveBuildOutcome buildOutcome = new GeneratedArchiveBuildOutcome(outcome.getTaskPath(), outcome.getDescription(), resource, relativePath);
            translatedOutcomes.add(buildOutcome);
        } else {
            String outcomeName = outcome.getTaskPath();
            if (StringUtils.isEmpty((String)outcomeName)) {
                outcomeName = RelativePathUtil.relativePath(rootProject.getProjectDirectory(), outcome.getFile());
            }
            translatedOutcomes.add(new UnknownBuildOutcome(outcomeName, outcome.getDescription()));
        }
    }
}

