/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static final int WINDOWS_PATH_LIMIT = 260;

    public static String toSafeFileName(String name) {
        int size = name.length();
        StringBuffer rc = new StringBuffer(size * 2);
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            boolean valid = c >= 'a' && c <= 'z';
            valid = valid || c >= 'A' && c <= 'Z';
            valid = valid || c >= '0' && c <= '9';
            boolean bl = valid = valid || c == '_' || c == '-' || c == '.' || c == '$';
            if (valid) {
                rc.append(c);
                continue;
            }
            rc.append('#');
            rc.append(Integer.toHexString(c));
        }
        return rc.toString();
    }

    public static File assertInWindowsPathLengthLimitation(File file) {
        if (file.getAbsolutePath().length() > 260) {
            throw new GradleException(String.format("Cannot create file. '%s' exceeds windows path limitation of %d character.", file.getAbsolutePath(), 260));
        }
        return file;
    }

    public static Collection<? extends File> calculateRoots(Iterable<? extends File> files) {
        LinkedList<File> roots = new LinkedList<File>();
        block0: for (File file : files) {
            File absoluteFile = file.getAbsoluteFile();
            String path = file.getPath();
            Iterator rootsIterator = roots.iterator();
            while (rootsIterator.hasNext()) {
                File root = (File)rootsIterator.next();
                String rootPath = root.getPath();
                if (FileUtils.doesPathStartWith(path, rootPath)) continue block0;
                if (!FileUtils.doesPathStartWith(rootPath, path)) continue;
                rootsIterator.remove();
            }
            roots.add(absoluteFile);
        }
        return roots;
    }

    public static boolean doesPathStartWith(String path, String startsWithPath) {
        if (!path.startsWith(startsWithPath)) {
            return false;
        }
        return path.length() == startsWithPath.length() || path.charAt(startsWithPath.length()) == File.separatorChar;
    }

    public static boolean hasExtension(File file, String extension) {
        return file.getPath().endsWith(extension);
    }

    public static boolean hasExtensionIgnoresCase(String fileName, String extension) {
        return FileUtils.endsWithIgnoreCase(fileName, extension);
    }

    private static boolean endsWithIgnoreCase(String subject, String suffix) {
        return subject.regionMatches(true, subject.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static String withExtension(String filePath, String extension) {
        if (filePath.toLowerCase().endsWith(extension)) {
            return filePath;
        }
        return FileUtils.removeExtension(filePath) + extension;
    }

    public static String removeExtension(String filePath) {
        int fileNameStart = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        int extensionPos = filePath.lastIndexOf(46);
        if (extensionPos > fileNameStart) {
            return filePath.substring(0, extensionPos);
        }
        return filePath;
    }

    public static File canonicalize(File src) {
        try {
            return src.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File normalize(File src) {
        String path = src.getAbsolutePath();
        String normalizedPath = FilenameUtils.normalize((String)path);
        if (normalizedPath != null) {
            return new File(normalizedPath);
        }
        File root = src;
        File parent = root.getParentFile();
        while (parent != null) {
            root = root.getParentFile();
            parent = root.getParentFile();
        }
        return root;
    }
}

