/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.DependencyConstraintMetadata;
import org.gradle.api.artifacts.DependencyConstraintsMetadata;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.capabilities.MutableCapabilitiesMetadata;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.CapabilitiesRules;
import org.gradle.internal.component.model.DependencyMetadataRules;
import org.gradle.internal.component.model.VariantAttributesRules;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class VariantMetadataRules {
    private final ImmutableAttributesFactory attributesFactory;
    private DependencyMetadataRules dependencyMetadataRules;
    private VariantAttributesRules variantAttributesRules;
    private CapabilitiesRules capabilitiesRules;

    public VariantMetadataRules(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public ImmutableAttributes applyVariantAttributeRules(VariantResolveMetadata variant, AttributeContainerInternal source) {
        if (this.variantAttributesRules != null) {
            return this.variantAttributesRules.execute(variant, source);
        }
        return source.asImmutable();
    }

    public CapabilitiesMetadata applyCapabilitiesRules(VariantResolveMetadata variant, CapabilitiesMetadata capabilities) {
        if (this.capabilitiesRules != null) {
            MutableCapabilities mutableCapabilities = new MutableCapabilities(Lists.newArrayList(capabilities.getCapabilities()));
            return this.capabilitiesRules.execute(variant, mutableCapabilities);
        }
        return capabilities;
    }

    public <T extends ModuleDependencyMetadata> List<T> applyDependencyMetadataRules(VariantResolveMetadata variant, List<T> configDependencies) {
        if (this.dependencyMetadataRules != null) {
            return this.dependencyMetadataRules.execute(variant, configDependencies);
        }
        return configDependencies;
    }

    public void addDependencyAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DirectDependenciesMetadata> action) {
        if (this.dependencyMetadataRules == null) {
            this.dependencyMetadataRules = new DependencyMetadataRules(instantiator, dependencyNotationParser, dependencyConstraintNotationParser, this.attributesFactory);
        }
        this.dependencyMetadataRules.addDependencyAction(action);
    }

    public void addDependencyConstraintAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DependencyConstraintsMetadata> action) {
        if (this.dependencyMetadataRules == null) {
            this.dependencyMetadataRules = new DependencyMetadataRules(instantiator, dependencyNotationParser, dependencyConstraintNotationParser, this.attributesFactory);
        }
        this.dependencyMetadataRules.addDependencyConstraintAction(action);
    }

    public void addAttributesAction(ImmutableAttributesFactory attributesFactory, VariantAction<? super AttributeContainer> action) {
        if (this.variantAttributesRules == null) {
            this.variantAttributesRules = new VariantAttributesRules(attributesFactory);
        }
        this.variantAttributesRules.addAttributesAction(action);
    }

    public void addCapabilitiesAction(VariantAction<? super MutableCapabilitiesMetadata> action) {
        if (this.capabilitiesRules == null) {
            this.capabilitiesRules = new CapabilitiesRules();
        }
        this.capabilitiesRules.addCapabilitiesAction(action);
    }

    public static VariantMetadataRules noOp() {
        return ImmutableRules.INSTANCE;
    }

    private static class MutableCapabilities
    implements MutableCapabilitiesMetadata {
        private final List<Capability> descriptors;

        private MutableCapabilities(List<Capability> descriptors) {
            this.descriptors = descriptors;
        }

        @Override
        public void addCapability(String group, String name, String version) {
            for (Capability descriptor : this.descriptors) {
                if (!descriptor.getGroup().equals(group) || !descriptor.getName().equals(name) || descriptor.getVersion().equals(version)) continue;
                throw new InvalidUserDataException("Cannot add capability " + group + ":" + name + " with version " + version + " because it's already defined with version " + descriptor.getVersion());
            }
            this.descriptors.add(new ImmutableCapability(group, name, version));
        }

        @Override
        public void removeCapability(String group, String name) {
            Iterator<Capability> it = this.descriptors.iterator();
            while (it.hasNext()) {
                Capability next = it.next();
                if (!next.getGroup().equals(group) || !next.getName().equals(name)) continue;
                it.remove();
            }
        }

        @Override
        public CapabilitiesMetadata asImmutable() {
            ImmutableList capabilities = (ImmutableList)Cast.uncheckedCast(this.getCapabilities());
            return new ImmutableCapabilities((ImmutableList<? extends Capability>)capabilities);
        }

        @Override
        public List<? extends Capability> getCapabilities() {
            return ImmutableList.copyOf(this.descriptors);
        }
    }

    private static class ImmutableRules
    extends VariantMetadataRules {
        private static final ImmutableRules INSTANCE = new ImmutableRules();

        private ImmutableRules() {
            super(null);
        }

        @Override
        public void addDependencyAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DirectDependenciesMetadata> action) {
            throw new UnsupportedOperationException("You are probably trying to add a dependency rule to something that wasn't supposed to be mutable");
        }

        @Override
        public void addDependencyConstraintAction(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, VariantAction<? super DependencyConstraintsMetadata> action) {
            throw new UnsupportedOperationException("You are probably trying to add a dependency constraint rule to something that wasn't supposed to be mutable");
        }

        @Override
        public void addAttributesAction(ImmutableAttributesFactory attributesFactory, VariantAction<? super AttributeContainer> action) {
            throw new UnsupportedOperationException("You are probably trying to add a variant attribute to something that wasn't supposed to be mutable");
        }

        @Override
        public void addCapabilitiesAction(VariantAction<? super MutableCapabilitiesMetadata> action) {
            throw new UnsupportedOperationException("You are probably trying to change capabilities of something that wasn't supposed to be mutable");
        }
    }

    public static class VariantAction<T> {
        private final Spec<? super VariantResolveMetadata> spec;
        private final Action<? super T> delegate;

        public VariantAction(Spec<? super VariantResolveMetadata> spec, Action<? super T> delegate) {
            this.spec = spec;
            this.delegate = delegate;
        }

        public void maybeExecute(VariantResolveMetadata variant, T subject) {
            if (this.spec.isSatisfiedBy(variant)) {
                this.delegate.execute(subject);
            }
        }
    }
}

