/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.invocation;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.execution.TaskExecutionGraphInternal;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.MutablePublicBuildPath;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.scan.config.BuildScanConfigInit;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;

public class DefaultGradle
extends AbstractPluginAware
implements GradleInternal {
    private SettingsInternal settings;
    private ProjectInternal rootProject;
    private ProjectInternal defaultProject;
    private final GradleInternal parent;
    private final StartParameter startParameter;
    private final ServiceRegistry services;
    private final ListenerBroadcast<BuildListener> buildListenerBroadcast;
    private final ListenerBroadcast<ProjectEvaluationListener> projectEvaluationListenerBroadcast;
    private Collection<IncludedBuild> includedBuilds;
    private MutableActionSet<Project> rootProjectActions = new MutableActionSet();
    private boolean projectsLoaded;
    private Path identityPath;
    private final ClassLoaderScope classLoaderScope;

    public DefaultGradle(GradleInternal parent, StartParameter startParameter, ServiceRegistryFactory parentRegistry) {
        this.parent = parent;
        this.startParameter = startParameter;
        this.services = parentRegistry.createFor(this);
        this.classLoaderScope = this.services.get(ClassLoaderScopeRegistry.class).getCoreAndPluginsScope();
        this.buildListenerBroadcast = this.getListenerManager().createAnonymousBroadcaster(BuildListener.class);
        this.projectEvaluationListenerBroadcast = this.getListenerManager().createAnonymousBroadcaster(ProjectEvaluationListener.class);
        this.buildListenerBroadcast.add(new InternalBuildAdapter(){

            @Override
            public void projectsLoaded(Gradle gradle) {
                if (!DefaultGradle.this.rootProjectActions.isEmpty()) {
                    DefaultGradle.this.services.get(CrossProjectConfigurator.class).rootProject(DefaultGradle.this.rootProject, DefaultGradle.this.rootProjectActions);
                }
                DefaultGradle.this.projectsLoaded = true;
            }
        });
        this.services.get(MutablePublicBuildPath.class).set(this);
        if (parent == null) {
            this.services.get(BuildScanConfigInit.class).init();
        }
    }

    public String toString() {
        return this.rootProject == null ? "build" : "build '" + this.rootProject.getName() + "'";
    }

    @Override
    public Path getIdentityPath() {
        Path path = this.findIdentityPath();
        if (path == null) {
            throw new IllegalStateException("Root project has not been attached.");
        }
        return path;
    }

    @Override
    @Nullable
    public Path findIdentityPath() {
        if (this.identityPath == null) {
            if (this.parent == null) {
                this.identityPath = Path.ROOT;
            } else {
                if (this.settings == null) {
                    return null;
                }
                Path parentIdentityPath = this.parent.findIdentityPath();
                if (parentIdentityPath == null) {
                    return null;
                }
                this.identityPath = parentIdentityPath.child(this.settings.getRootProject().getName());
            }
        }
        return this.identityPath;
    }

    @Override
    public void setIdentityPath(Path path) {
        if (this.identityPath != null && !path.equals(this.identityPath)) {
            throw new IllegalStateException("Identity path already set");
        }
        this.identityPath = path;
    }

    @Override
    public String contextualize(String description) {
        if (this.getParent() == null) {
            return description;
        }
        Path contextPath = this.findIdentityPath();
        String context = contextPath == null ? this.getStartParameter().getCurrentDir().getName() : contextPath.getPath();
        return description + " (" + context + ")";
    }

    @Override
    public GradleInternal getParent() {
        return this.parent;
    }

    @Override
    public GradleInternal getRoot() {
        GradleInternal root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public BuildState getOwner() {
        return this.getServices().get(BuildState.class);
    }

    @Override
    public String getGradleVersion() {
        return GradleVersion.current().getVersion();
    }

    @Override
    public File getGradleHomeDir() {
        GradleInstallation gradleInstallation = this.getCurrentGradleInstallation().getInstallation();
        return gradleInstallation == null ? null : gradleInstallation.getGradleHome();
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.startParameter.getGradleUserHomeDir();
    }

    @Override
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    @Override
    public SettingsInternal getSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("The settings are not yet available for " + this + ".");
        }
        return this.settings;
    }

    @Override
    public void setSettings(SettingsInternal settings) {
        this.settings = settings;
    }

    @Override
    public ProjectInternal getRootProject() {
        if (this.rootProject == null) {
            throw new IllegalStateException("The root project is not yet available for " + this + ".");
        }
        return this.rootProject;
    }

    @Override
    public void setRootProject(ProjectInternal rootProject) {
        this.rootProject = rootProject;
    }

    @Override
    public void rootProject(Action<? super Project> action) {
        this.rootProject("Gradle.rootProject", action);
    }

    private void rootProject(String registrationPoint, Action<? super Project> action) {
        if (this.projectsLoaded) {
            assert (this.rootProject != null);
            action.execute(this.rootProject);
        } else {
            this.rootProjectActions.add(this.getListenerBuildOperationDecorator().decorate(registrationPoint, action));
        }
    }

    @Override
    public void allprojects(final Action<? super Project> action) {
        this.rootProject("Gradle.allprojects", (Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                project.allprojects(action);
            }
        });
    }

    @Override
    public ProjectInternal getDefaultProject() {
        return this.defaultProject;
    }

    @Override
    public void setDefaultProject(ProjectInternal defaultProject) {
        this.defaultProject = defaultProject;
    }

    @Override
    @Inject
    public TaskExecutionGraphInternal getTaskGraph() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectEvaluationListener addProjectEvaluationListener(ProjectEvaluationListener listener) {
        this.addListener("Gradle.addProjectEvaluationListener", listener);
        return listener;
    }

    @Override
    public void removeProjectEvaluationListener(ProjectEvaluationListener listener) {
        this.removeListener(listener);
    }

    @Override
    public void beforeProject(Closure closure) {
        this.projectEvaluationListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.beforeProject", closure)));
    }

    @Override
    public void beforeProject(Action<? super Project> action) {
        this.projectEvaluationListenerBroadcast.add("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.beforeProject", action));
    }

    @Override
    public void afterProject(Closure closure) {
        this.projectEvaluationListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.afterProject", closure)));
    }

    @Override
    public void afterProject(Action<? super Project> action) {
        this.projectEvaluationListenerBroadcast.add("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Gradle.afterProject", action));
    }

    @Override
    public void buildStarted(Closure closure) {
        this.buildListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("buildStarted", closure));
    }

    @Override
    public void buildStarted(Action<? super Gradle> action) {
        this.buildListenerBroadcast.add("buildStarted", action);
    }

    @Override
    public void settingsEvaluated(Closure closure) {
        this.buildListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("settingsEvaluated", closure));
    }

    @Override
    public void settingsEvaluated(Action<? super Settings> action) {
        this.buildListenerBroadcast.add("settingsEvaluated", action);
    }

    @Override
    public void projectsLoaded(Closure closure) {
        this.buildListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("projectsLoaded", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsLoaded", closure)));
    }

    @Override
    public void projectsLoaded(Action<? super Gradle> action) {
        this.buildListenerBroadcast.add("projectsLoaded", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsLoaded", action));
    }

    @Override
    public void projectsEvaluated(Closure closure) {
        this.buildListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("projectsEvaluated", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsEvaluated", closure)));
    }

    @Override
    public void projectsEvaluated(Action<? super Gradle> action) {
        this.buildListenerBroadcast.add("projectsEvaluated", this.getListenerBuildOperationDecorator().decorate("Gradle.projectsEvaluated", action));
    }

    @Override
    public void buildFinished(Closure closure) {
        this.buildListenerBroadcast.add(new ClosureBackedMethodInvocationDispatch("buildFinished", closure));
    }

    @Override
    public void buildFinished(Action<? super BuildResult> action) {
        this.buildListenerBroadcast.add("buildFinished", action);
    }

    @Override
    public void addListener(Object listener) {
        this.addListener("Gradle.addListener", listener);
    }

    private void addListener(String registrationPoint, Object listener) {
        this.getListenerManager().addListener(this.getListenerBuildOperationDecorator().decorateUnknownListener(registrationPoint, listener));
    }

    @Override
    public void removeListener(Object listener) {
        this.getListenerManager().removeListener(this.getListenerBuildOperationDecorator().decorateUnknownListener(null, listener));
    }

    @Override
    public void useLogger(Object logger) {
        this.getListenerManager().useLogger(logger);
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.projectEvaluationListenerBroadcast.getSource();
    }

    @Override
    public void addBuildListener(BuildListener buildListener) {
        this.addListener("Gradle.addBuildListener", buildListener);
    }

    @Override
    public BuildListener getBuildListenerBroadcaster() {
        return this.buildListenerBroadcast.getSource();
    }

    @Override
    public Gradle getGradle() {
        return this;
    }

    @Override
    public Collection<IncludedBuild> getIncludedBuilds() {
        if (this.includedBuilds == null) {
            throw new IllegalStateException("Included builds are not yet available for this build.");
        }
        return this.includedBuilds;
    }

    @Override
    public void setIncludedBuilds(Collection<? extends IncludedBuild> includedBuilds) {
        this.includedBuilds = ImmutableList.copyOf(includedBuilds);
    }

    @Override
    public IncludedBuild includedBuild(String name) {
        for (IncludedBuild includedBuild : this.getIncludedBuilds()) {
            if (!includedBuild.getName().equals(name)) continue;
            return includedBuild;
        }
        throw new UnknownDomainObjectException("Included build '" + name + "' not found in " + this.toString() + ".");
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    @Inject
    public ServiceRegistryFactory getServiceRegistryFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getClassLoaderScope(), this.getResourceLoader(), this);
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Inject
    protected TextResourceLoader getResourceLoader() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CurrentGradleInstallation getCurrentGradleInstallation() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerManager getListenerManager() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerBuildOperationDecorator getListenerBuildOperationDecorator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PluginManagerInternal getPluginManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PublicBuildPath getPublicBuildPath() {
        throw new UnsupportedOperationException();
    }
}

