/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.test.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.JvmComponentSpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.test.JvmTestSuiteBinarySpec;
import org.gradle.jvm.test.JvmTestSuiteSpec;
import org.gradle.jvm.test.internal.JvmTestSuiteBinarySpecInternal;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.model.ModelMap;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultLibraryBinaryDependencySpec;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolvers;

public class JvmTestSuiteRules {
    public static void createJvmTestSuiteBinaries(ModelMap<BinarySpec> testBinaries, PlatformResolvers platformResolver, JvmTestSuiteSpec testSuite, JavaToolChainRegistry toolChains, Class<? extends JvmTestSuiteBinarySpec> testSuiteBinary) {
        JvmComponentSpec testedComponent = testSuite.getTestedComponent();
        if (testedComponent == null) {
            JvmTestSuiteRules.createJvmTestSuiteBinary(testBinaries, testSuiteBinary, testSuite, null, toolChains, platformResolver);
        } else {
            for (JvmBinarySpec testedBinary : JvmTestSuiteRules.testedBinariesOf(testSuite)) {
                JvmTestSuiteRules.createJvmTestSuiteBinary(testBinaries, testSuiteBinary, testSuite, testedBinary, toolChains, platformResolver);
            }
        }
    }

    private static <T extends JvmTestSuiteBinarySpec> void createJvmTestSuiteBinary(ModelMap<BinarySpec> testBinaries, Class<T> testSuiteBinaryClass, final JvmTestSuiteSpec testSuite, final JvmBinarySpec testedBinary, final JavaToolChainRegistry toolChains, PlatformResolvers platformResolver) {
        List<JavaPlatform> javaPlatforms = JvmTestSuiteRules.resolvePlatforms(platformResolver);
        final JavaPlatform platform = testedBinary != null ? testedBinary.getTargetPlatform() : javaPlatforms.get(0);
        final BinaryNamingScheme namingScheme = JvmTestSuiteRules.namingSchemeFor(testSuite, testedBinary, javaPlatforms, platform);
        testBinaries.create(namingScheme.getBinaryName(), testSuiteBinaryClass, new Action<T>(){

            @Override
            public void execute(T binary) {
                JvmTestSuiteBinarySpecInternal testBinary = (JvmTestSuiteBinarySpecInternal)binary;
                testBinary.setNamingScheme(namingScheme);
                testBinary.setTargetPlatform(platform);
                testBinary.setToolChain((JavaToolChain)toolChains.getForPlatform(platform));
                testBinary.setTestedBinary(testedBinary);
                this.addTestSuiteDependencies(testBinary);
                this.configureCompileClasspath(testBinary);
            }

            private boolean addTestSuiteDependencies(JvmTestSuiteBinarySpecInternal testBinary) {
                return testBinary.getDependencies().addAll(testSuite.getDependencies().getDependencies());
            }

            private void configureCompileClasspath(JvmTestSuiteBinarySpecInternal testSuiteBinary) {
                if (testedBinary != null) {
                    Collection<DependencySpec> dependencies = testSuiteBinary.getDependencies();
                    BinarySpecInternal binary = (BinarySpecInternal)((Object)testedBinary);
                    LibraryBinaryIdentifier id = binary.getId();
                    dependencies.add(DefaultLibraryBinaryDependencySpec.of(id));
                    if (testedBinary instanceof JarBinarySpecInternal) {
                        dependencies.addAll(((JarBinarySpecInternal)testedBinary).getApiDependencies());
                    }
                }
            }
        });
    }

    private static Collection<JvmBinarySpec> testedBinariesOf(JvmTestSuiteSpec testSuite) {
        return JvmTestSuiteRules.testedBinariesWithType(JvmBinarySpec.class, testSuite);
    }

    private static <S> Collection<S> testedBinariesWithType(Class<S> type, JvmTestSuiteSpec testSuite) {
        VariantComponentSpec spec = (VariantComponentSpec)((Object)testSuite.getTestedComponent());
        return spec.getBinaries().withType(type).values();
    }

    private static BinaryNamingScheme namingSchemeFor(JvmTestSuiteSpec testSuiteSpec, JvmBinarySpec testedBinary, List<JavaPlatform> selectedPlatforms, JavaPlatform platform) {
        BinaryNamingScheme namingScheme = DefaultBinaryNamingScheme.component(testSuiteSpec.getName()).withBinaryType("binary").withRole("assembly", true).withVariantDimension(platform, selectedPlatforms);
        if (testedBinary != null) {
            return namingScheme.withVariantDimension(((BinarySpecInternal)((Object)testedBinary)).getProjectScopedName());
        }
        return namingScheme;
    }

    private static List<JavaPlatform> resolvePlatforms(PlatformResolvers platformResolver) {
        PlatformRequirement defaultPlatformRequirement = DefaultPlatformRequirement.create(DefaultJavaPlatform.current().getName());
        return Collections.singletonList(platformResolver.resolve(JavaPlatform.class, defaultPlatformRequirement));
    }
}

