/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.util.concurrent.UncheckedExecutionException;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSetNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.SpecializedMapNodeInitializerExtractionStrategy;

public class DefaultNodeInitializerRegistry
implements NodeInitializerRegistry {
    public static final ModelReference<NodeInitializerRegistry> DEFAULT_REFERENCE = ModelReference.of("nodeInitializerRegistry", NodeInitializerRegistry.class);
    private final LoadingCache<NodeInitializerContext<?>, NodeInitializer> cache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<NodeInitializerContext<?>, NodeInitializer>(){

        public NodeInitializer load(NodeInitializerContext<?> context) throws Exception {
            return DefaultNodeInitializerRegistry.this.extractNodeInitializer(context);
        }
    });
    private final List<NodeInitializerExtractionStrategy> allStrategies;
    private final List<NodeInitializerExtractionStrategy> additionalStrategies;
    private final ModelSchemaStore schemaStore;

    public DefaultNodeInitializerRegistry(ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
        this.schemaStore = schemaStore;
        this.allStrategies = Lists.newArrayList((Object[])new NodeInitializerExtractionStrategy[]{new ModelSetNodeInitializerExtractionStrategy(), new SpecializedMapNodeInitializerExtractionStrategy(), new ModelMapNodeInitializerExtractionStrategy(), new ScalarCollectionNodeInitializerExtractionStrategy(), new ManagedImplStructNodeInitializerExtractionStrategy(structBindingsStore)});
        this.additionalStrategies = Lists.newArrayList();
    }

    /*
     * Exception decompiling
     */
    private ModelTypeInitializationException canNotConstructTypeException(NodeInitializerContext<?> context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public NodeInitializer getNodeInitializer(NodeInitializerContext<?> nodeInitializerContext) {
        try {
            return (NodeInitializer)this.cache.get(nodeInitializerContext);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        catch (UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    private <T> NodeInitializer extractNodeInitializer(NodeInitializerContext<T> context) {
        ModelSchema<T> schema = this.schemaStore.getSchema(context.getModelType());
        for (NodeInitializerExtractionStrategy extractor : this.allStrategies) {
            NodeInitializer nodeInitializer = extractor.extractNodeInitializer(schema, context);
            if (nodeInitializer == null) continue;
            return nodeInitializer;
        }
        throw this.canNotConstructTypeException(context);
    }

    @Override
    public void ensureHasInitializer(NodeInitializerContext<?> nodeInitializer) {
        this.getNodeInitializer(nodeInitializer);
    }

    @Override
    public void registerStrategy(NodeInitializerExtractionStrategy strategy) {
        this.allStrategies.add(0, strategy);
        this.additionalStrategies.add(0, strategy);
    }
}

