/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.UnmanagedImplStructSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

public class JavaUtilCollectionStrategy
implements ModelSchemaExtractionStrategy {
    public static final List<Class<?>> TYPES = ImmutableList.of(List.class, Set.class);

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        ModelType<T> type = extractionContext.getType();
        Class<T> rawClass = type.getRawClass();
        List<ModelType<?>> typeVariables = type.getTypeVariables();
        if (TYPES.contains(rawClass)) {
            if (typeVariables.size() > 0 && ScalarTypes.isScalarType(typeVariables.get(0))) {
                extractionContext.found(this.createSchema(extractionContext, type, typeVariables.get(0)));
            } else {
                extractionContext.found(new UnmanagedImplStructSchema<T>(type, Collections.<ModelProperty<?>>emptySet(), Collections.<WeaklyTypeReferencingMethod<?, ?>>emptySet(), Collections.<ModelSchemaAspect>emptySet(), false));
            }
        }
    }

    private <T, E> ScalarCollectionSchema<T, E> createSchema(ModelSchemaExtractionContext<T> extractionContext, ModelType<T> type, ModelType<E> elementType) {
        final ScalarCollectionSchema<T, E> schema = new ScalarCollectionSchema<T, E>(type, elementType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            @Override
            public void execute(ModelSchema<E> elementTypeSchema) {
                schema.setElementTypeSchema(elementTypeSchema);
            }
        });
        return schema;
    }
}

