/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditorDialog;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormInspectionUtil {
    private FormInspectionUtil() {
    }

    static boolean isComponentClass(Module module, IComponent component, Class componentClass) {
        PsiClass labelClass;
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PsiClass aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(component.getComponentClassName(), scope);
        return aClass != null && (labelClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(componentClass.getName(), scope)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)labelClass, (boolean)true);
    }

    @Nullable
    public static String getText(@NotNull Module module, IComponent component) {
        IProperty textProperty;
        if (module == null) {
            FormInspectionUtil.$$$reportNull$$$0(0);
        }
        if ((textProperty = FormInspectionUtil.findProperty(component, "text")) != null) {
            Object propValue = textProperty.getPropertyValue(component);
            String value = null;
            if (propValue instanceof StringDescriptor) {
                StringDescriptor descriptor = (StringDescriptor)propValue;
                value = component instanceof RadComponent ? StringDescriptorManager.getInstance(module).resolve((RadComponent)component, descriptor) : StringDescriptorManager.getInstance(module).resolve(descriptor, null);
            } else if (propValue instanceof String) {
                value = (String)propValue;
            }
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    @Nullable
    public static IProperty findProperty(@NotNull IComponent component, String name) {
        IProperty[] props;
        if (component == null) {
            FormInspectionUtil.$$$reportNull$$$0(1);
        }
        for (IProperty prop : props = component.getModifiedProperties()) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    static void updateStringPropertyValue(GuiEditor editor, RadComponent component, IntroStringProperty prop, StringDescriptor descriptor, String result) {
        if (descriptor.getBundleName() == null) {
            prop.setValueEx(component, StringDescriptor.create((String)result));
        } else {
            String newKeyName = StringEditorDialog.saveModifiedPropertyValue(editor.getModule(), descriptor, editor.getStringDescriptorLocale(), result, editor.getPsiFile());
            if (newKeyName != null) {
                prop.setValueEx(component, new StringDescriptor(descriptor.getBundleName(), newKeyName));
            }
        }
        editor.refreshAndSave(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/inspections/FormInspectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

