/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertReturnStatementsVisitor;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnBooleanFix");
    private final SmartTypePointer myReturnTypePointer;
    private final boolean myFixWholeHierarchy;
    private final String myName;
    private final String myCanonicalText;

    public MethodReturnTypeFix(@NotNull PsiMethod method, @NotNull PsiType returnType, boolean fixWholeHierarchy) {
        if (method == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(0);
        }
        if (returnType == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)method);
        this.myReturnTypePointer = SmartTypePointerManager.getInstance((Project)method.getProject()).createSmartTypePointer(returnType);
        this.myFixWholeHierarchy = fixWholeHierarchy;
        this.myName = method.getName();
        this.myCanonicalText = returnType.getCanonicalText();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.return.type.text", this.myName, this.myCanonicalText);
        if (string == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.return.type.family", new Object[0]);
        if (string == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiType returnType;
        if (project == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(7);
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        PsiType myReturnType = this.myReturnTypePointer.getType();
        if (BaseIntentionAction.canModify((PsiElement)myMethod) && myReturnType != null && myReturnType.isValid() && !TypeConversionUtil.isNullType((PsiType)myReturnType) && (returnType = myMethod.getReturnType()) != null && returnType.isValid() && !Comparing.equal((Object)myReturnType, (Object)returnType)) {
            return PsiTypesUtil.allTypeParametersResolved((PsiElement)myMethod, (PsiType)myReturnType);
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Editor editorForMethod;
        if (project == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(11);
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myMethod.getContainingFile())) {
            return;
        }
        PsiType myReturnType = this.myReturnTypePointer.getType();
        if (myReturnType == null) {
            return;
        }
        if (this.myFixWholeHierarchy) {
            PsiType superReturnType;
            PsiMethod superMethod = myMethod.findDeepestSuperMethod();
            PsiType psiType = superReturnType = superMethod == null ? null : superMethod.getReturnType();
            if (superReturnType != null && !Comparing.equal((Object)myReturnType, (Object)superReturnType) && !MethodReturnTypeFix.changeClassTypeArgument(myMethod, project, superReturnType, superMethod.getContainingClass(), editor, myReturnType)) {
                return;
            }
        }
        List<PsiMethod> affectedMethods = this.changeReturnType(myMethod, myReturnType);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiReturnStatement statementToSelect = null;
        if (!PsiType.VOID.equals((Object)myReturnType)) {
            ReturnStatementAdder adder = new ReturnStatementAdder(factory, myReturnType);
            for (PsiMethod affectedMethod : affectedMethods) {
                PsiReturnStatement statement = adder.addReturnForMethod(file, affectedMethod);
                if (statement == null || affectedMethod != myMethod) continue;
                statementToSelect = statement;
            }
        }
        if (statementToSelect != null && (editorForMethod = MethodReturnTypeFix.getEditorForMethod(myMethod, project, editor, file)) != null) {
            MethodReturnTypeFix.selectReturnValueInEditor(statementToSelect, editorForMethod);
        }
    }

    private static Editor getEditorForMethod(PsiMethod myMethod, @NotNull Project project, Editor editor, PsiFile file) {
        PsiFile containingFile;
        if (project == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(12);
        }
        if ((containingFile = myMethod.getContainingFile()) != file) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile());
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        return editor;
    }

    @NotNull
    private PsiMethod[] getChangeRoots(PsiMethod method, @NotNull PsiType returnType) {
        if (returnType == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(13);
        }
        if (!this.myFixWholeHierarchy) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                MethodReturnTypeFix.$$$reportNull$$$0(14);
            }
            return psiMethodArray;
        }
        PsiMethod[] methods = method.findDeepestSuperMethods();
        if (methods.length > 0) {
            for (PsiMethod psiMethod : methods) {
                if (!returnType.equals(psiMethod.getReturnType())) continue;
                PsiMethod[] psiMethodArray = new PsiMethod[]{method};
                if (psiMethodArray == null) {
                    MethodReturnTypeFix.$$$reportNull$$$0(15);
                }
                return psiMethodArray;
            }
            if (methods == null) {
                MethodReturnTypeFix.$$$reportNull$$$0(16);
            }
            return methods;
        }
        PsiMethod[] psiMethodArray = new PsiMethod[]{method};
        if (psiMethodArray == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(17);
        }
        return psiMethodArray;
    }

    @NotNull
    private List<PsiMethod> changeReturnType(PsiMethod method, @NotNull PsiType returnType) {
        if (returnType == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(18);
        }
        PsiMethod[] methods = this.getChangeRoots(method, returnType);
        MethodSignatureChangeVisitor methodSignatureChangeVisitor = new MethodSignatureChangeVisitor();
        for (PsiMethod targetMethod : methods) {
            methodSignatureChangeVisitor.addBase(targetMethod);
            UsagesAwareChangeSignatureProcessor processor = new UsagesAwareChangeSignatureProcessor(method.getProject(), targetMethod, false, null, this.myName, returnType, ParameterInfoImpl.fromMethod(targetMethod), methodSignatureChangeVisitor);
            processor.run();
        }
        List<PsiMethod> list = methodSignatureChangeVisitor.getAffectedMethods();
        if (list == null) {
            MethodReturnTypeFix.$$$reportNull$$$0(19);
        }
        return list;
    }

    static void selectReturnValueInEditor(PsiReturnStatement returnStatement, Editor editor) {
        PsiExpression returnValue = returnStatement.getReturnValue();
        LOG.assertTrue(returnValue != null, (Object)returnStatement);
        TextRange range = returnValue.getTextRange();
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().setSelection(range.getEndOffset(), range.getStartOffset());
    }

    private static boolean changeClassTypeArgument(PsiMethod myMethod, Project project, PsiType superReturnType, PsiClass superClass, Editor editor, PsiType returnType) {
        PsiSubstitutor superClassSubstitutor;
        PsiType superReturnTypeInBaseClassType;
        if (superClass == null || !superClass.hasTypeParameters()) {
            return true;
        }
        PsiClass superReturnTypeClass = PsiUtil.resolveClassInType((PsiType)superReturnType);
        if (superReturnTypeClass == null || !(superReturnTypeClass instanceof PsiTypeParameter) && !superReturnTypeClass.hasTypeParameters()) {
            return true;
        }
        PsiClass derivedClass = myMethod.getContainingClass();
        if (derivedClass == null) {
            return true;
        }
        PsiReferenceParameterList referenceParameterList = MethodReturnTypeFix.findTypeArgumentsList(superClass, derivedClass);
        if (referenceParameterList == null) {
            return true;
        }
        PsiElement resolve = ((PsiJavaCodeReferenceElement)referenceParameterList.getParent()).resolve();
        if (!(resolve instanceof PsiClass)) {
            return true;
        }
        PsiClass baseClass = (PsiClass)resolve;
        if (returnType instanceof PsiPrimitiveType) {
            returnType = ((PsiPrimitiveType)returnType).getBoxedType((PsiElement)derivedClass);
        }
        if ((superReturnTypeInBaseClassType = (superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)baseClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)).substitute(superReturnType)) == null) {
            return true;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(PsiTypesUtil.filterUnusedTypeParameters((PsiType)superReturnTypeInBaseClassType, (PsiTypeParameter[])baseClass.getTypeParameters()), new PsiType[]{superReturnTypeInBaseClassType}, new PsiType[]{returnType}, PsiUtil.getLanguageLevel((PsiElement)superClass));
        TypeMigrationRules rules = new TypeMigrationRules(project);
        PsiSubstitutor compoundSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).putAll(psiSubstitutor);
        rules.setBoundScope((SearchScope)new LocalSearchScope((PsiElement)derivedClass));
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, (PsiElement)referenceParameterList, (PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(baseClass, compoundSubstitutor));
        return false;
    }

    @Nullable
    private static PsiReferenceParameterList findTypeArgumentsList(PsiClass superClass, PsiClass derivedClass) {
        PsiReferenceParameterList referenceParameterList = null;
        if (derivedClass instanceof PsiAnonymousClass) {
            referenceParameterList = ((PsiAnonymousClass)derivedClass).getBaseClassReference().getParameterList();
        } else {
            PsiReferenceList extendsList;
            PsiReferenceList implementsList = derivedClass.getImplementsList();
            if (implementsList != null) {
                referenceParameterList = MethodReturnTypeFix.extractReferenceParameterList(superClass, implementsList);
            }
            if (referenceParameterList == null && (extendsList = derivedClass.getExtendsList()) != null) {
                referenceParameterList = MethodReturnTypeFix.extractReferenceParameterList(superClass, extendsList);
            }
        }
        return referenceParameterList;
    }

    @Nullable
    private static PsiReferenceParameterList extractReferenceParameterList(PsiClass superClass, PsiReferenceList extendsList) {
        for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
            PsiElement element = referenceElement.resolve();
            if (!(element instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)element), (PsiClass)superClass, (boolean)true)) continue;
            return referenceElement.getParameterList();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "changeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditorForMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangeRoots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UsagesAwareChangeSignatureProcessor
    extends ChangeSignatureProcessor {
        private final UsageVisitor myUsageVisitor;

        private UsagesAwareChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, PsiType newType, @NotNull ParameterInfoImpl[] parameterInfo, UsageVisitor usageVisitor) {
            if (parameterInfo == null) {
                UsagesAwareChangeSignatureProcessor.$$$reportNull$$$0(0);
            }
            super(project, method, generateDelegate, newVisibility, newName, newType, parameterInfo);
            this.myUsageVisitor = usageVisitor;
        }

        @Override
        protected void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            this.myUsageVisitor.preprocessCovariantOverriders(covariantOverriderInfos);
        }

        protected void performRefactoring(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                UsagesAwareChangeSignatureProcessor.$$$reportNull$$$0(1);
            }
            super.performRefactoring(usages);
            for (UsageInfo usage : usages) {
                this.myUsageVisitor.visit(usage);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix$UsagesAwareChangeSignatureProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performRefactoring";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface UsageVisitor {
        public void visit(UsageInfo var1);

        public void preprocessCovariantOverriders(List<UsageInfo> var1);
    }

    private static class MethodSignatureChangeVisitor
    implements UsageVisitor {
        private final List<PsiMethod> myAffectedMethods = new ArrayList<PsiMethod>();

        private MethodSignatureChangeVisitor() {
        }

        public void addBase(PsiMethod baseMethod) {
            this.myAffectedMethods.add(baseMethod);
        }

        @Override
        public void visit(UsageInfo usage) {
            if (usage instanceof OverriderUsageInfo) {
                this.myAffectedMethods.add(((OverriderUsageInfo)usage).getOverridingMethod());
            }
        }

        public List<PsiMethod> getAffectedMethods() {
            return this.myAffectedMethods;
        }

        @Override
        public void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            Iterator<UsageInfo> usageInfoIterator = covariantOverriderInfos.iterator();
            while (usageInfoIterator.hasNext()) {
                OverriderUsageInfo overrideUsage;
                UsageInfo info = usageInfoIterator.next();
                if (!(info instanceof OverriderUsageInfo) || !this.myAffectedMethods.contains((overrideUsage = (OverriderUsageInfo)info).getOverridingMethod())) continue;
                usageInfoIterator.remove();
            }
        }
    }

    private static class ReturnStatementAdder {
        @NotNull
        private final PsiElementFactory factory;
        @NotNull
        private final PsiType myTargetType;

        private ReturnStatementAdder(@NotNull PsiElementFactory factory, @NotNull PsiType targetType) {
            if (factory == null) {
                ReturnStatementAdder.$$$reportNull$$$0(0);
            }
            if (targetType == null) {
                ReturnStatementAdder.$$$reportNull$$$0(1);
            }
            this.factory = factory;
            this.myTargetType = targetType;
        }

        private PsiReturnStatement addReturnForMethod(PsiFile file, PsiMethod method) {
            PsiModifierList modifiers = method.getModifierList();
            if (modifiers.hasModifierProperty("abstract") || method.getBody() == null) {
                return null;
            }
            try {
                ControlFlow controlFlow;
                ConvertReturnStatementsVisitor visitor = new ConvertReturnStatementsVisitor(this.factory, method, this.myTargetType);
                try {
                    controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)method.getBody());
                }
                catch (AnalysisCanceledException e) {
                    return null;
                }
                PsiReturnStatement returnStatement = ControlFlowUtil.processReturns(controlFlow, visitor) ? visitor.getLatestReturn() : visitor.createReturnInLastStatement();
                if (method.getContainingFile() != file) {
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
                return returnStatement;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix$ReturnStatementAdder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

