/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportConstantFix
extends StaticImportMemberFix<PsiField, PsiJavaCodeReferenceElement> {
    StaticImportConstantFix(@NotNull PsiFile file, @NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (file == null) {
            StaticImportConstantFix.$$$reportNull$$$0(0);
        }
        if (referenceElement == null) {
            StaticImportConstantFix.$$$reportNull$$$0(1);
        }
        super(file, referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        String string = QuickFixBundle.message("static.import.constant.text", new Object[0]);
        if (string == null) {
            StaticImportConstantFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(@NotNull PsiField field) {
        if (field == null) {
            StaticImportConstantFix.$$$reportNull$$$0(3);
        }
        String string = PsiFormatUtil.formatVariable((PsiVariable)field, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            StaticImportConstantFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<PsiField> getMembersToImport(boolean applicableOnly, @NotNull StaticMembersProcessor.SearchMode searchMode) {
        String name;
        if (searchMode == null) {
            StaticImportConstantFix.$$$reportNull$$$0(5);
        }
        Project project = this.myRef.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        String string = name = element != null ? element.getReferenceName() : null;
        if (name == null) {
            List<PsiField> list = Collections.emptyList();
            if (list == null) {
                StaticImportConstantFix.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element)) || element.getParent() instanceof PsiTypeElement || element.getParent() instanceof PsiAnnotation) {
            List<PsiField> list = Collections.emptyList();
            if (list == null) {
                StaticImportConstantFix.$$$reportNull$$$0(7);
            }
            return list;
        }
        StaticMembersProcessor<PsiField> processor = new StaticMembersProcessor<PsiField>((PsiElement)element, this.toAddStaticImports(), searchMode){

            @Override
            protected boolean isApplicable(PsiField field, PsiElement place) {
                ProgressManager.checkCanceled();
                PsiType fieldType = field.getType();
                return this.isApplicableFor(fieldType);
            }
        };
        cache.processFieldsWithName(name, (Processor)processor, element.getResolveScope(), null);
        List<PsiField> list = processor.getMembersToImport(applicableOnly);
        if (list == null) {
            StaticImportConstantFix.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(@NotNull List<? extends PsiField> methodsToImport, @NotNull Project project, Editor editor) {
        if (methodsToImport == null) {
            StaticImportConstantFix.$$$reportNull$$$0(9);
        }
        if (project == null) {
            StaticImportConstantFix.$$$reportNull$$$0(10);
        }
        StaticImportMethodQuestionAction<PsiField> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiField>(project, editor, methodsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                String string = QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix$2", "getPopupTitle"));
            }
        };
        if (staticImportMethodQuestionAction == null) {
            StaticImportConstantFix.$$$reportNull$$$0(11);
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myRef.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        return element != null ? element.getQualifier() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getElement();
        return referenceElement != null ? referenceElement.advancedResolve(true).getElement() : null;
    }

    @Override
    protected boolean toAddStaticImports() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsToImport";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberPresentableText";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersToImport";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuestionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMemberPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMembersToImport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createQuestionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

