/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;

class HighlightExceptionsHandler
extends HighlightUsagesHandlerBase<PsiClass> {
    private final PsiElement myTarget;
    private final PsiClassType[] myClassTypes;
    private final PsiElement myPlace;
    private final PsiElement myOtherPlace;
    private final Condition<? super PsiType> myTypeFilter;

    HighlightExceptionsHandler(Editor editor, PsiFile file, PsiElement target, PsiClassType[] classTypes, PsiElement place, PsiElement otherPlace, Condition<? super PsiType> typeFilter) {
        super(editor, file);
        this.myTarget = target;
        this.myClassTypes = classTypes;
        this.myPlace = place;
        this.myOtherPlace = otherPlace;
        this.myTypeFilter = typeFilter;
    }

    public List<PsiClass> getTargets() {
        return ChooseClassAndDoHighlightRunnable.resolveClasses(this.myClassTypes);
    }

    protected void selectTargets(List<PsiClass> targets, final Consumer<List<PsiClass>> selectionConsumer) {
        new ChooseClassAndDoHighlightRunnable(this.myClassTypes, this.myEditor, CodeInsightBundle.message((String)"highlight.exceptions.thrown.chooser.title", (Object[])new Object[0])){

            protected void selected(PsiClass ... classes2) {
                if (classes2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                selectionConsumer.consume(Arrays.asList(classes2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/codeInsight/highlighting/HighlightExceptionsHandler$1", "selected"));
            }
        }.run();
    }

    public void computeUsages(List<PsiClass> targets) {
        this.addOccurrence(this.myTarget);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myEditor.getProject());
        for (PsiClass aClass : targets) {
            this.addExceptionThrowPlaces(factory.createType(aClass), this.myPlace);
            if (this.myOtherPlace == null) continue;
            this.addExceptionThrowPlaces(factory.createType(aClass), this.myOtherPlace);
        }
        this.buildStatusText(LangBundle.message((String)"java.terms.exception", (Object[])new Object[0]), this.myReadUsages.size() - 1);
    }

    private void addExceptionThrowPlaces(final PsiClassType type2, final PsiElement place) {
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                super.visitThrowStatement(statement);
                List<PsiClassType> actualTypes = ExceptionUtil.getUnhandledExceptions(statement, place);
                for (PsiClassType actualType : actualTypes) {
                    if (actualType == null || !type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                    PsiExpression psiExpression = statement.getException();
                    if (psiExpression instanceof PsiReferenceExpression) {
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)psiExpression);
                        continue;
                    }
                    if (psiExpression instanceof PsiNewExpression) {
                        PsiJavaCodeReferenceElement ref = ((PsiNewExpression)psiExpression).getClassReference();
                        if (ref == null) continue;
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)ref);
                        continue;
                    }
                    PsiExpression exception = statement.getException();
                    if (exception == null) continue;
                    HighlightExceptionsHandler.this.addOccurrence((PsiElement)exception);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiReference reference = expression2.getMethodExpression().getReference();
                if (reference != null) {
                    List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression2, place);
                    for (PsiClassType actualType : exceptionTypes) {
                        if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)expression2.getMethodExpression());
                        break;
                    }
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                super.visitNewExpression(expression2);
                PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
                if (classReference2 != null) {
                    List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression2, place);
                    for (PsiClassType actualType : exceptionTypes) {
                        if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)classReference2);
                        break;
                    }
                }
            }

            public void visitResourceExpression(PsiResourceExpression expression2) {
                super.visitResourceExpression(expression2);
                List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)expression2, place);
                for (PsiClassType actualType : exceptionTypes) {
                    if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                    HighlightExceptionsHandler.this.addOccurrence((PsiElement)expression2);
                    break;
                }
            }

            public void visitResourceVariable(PsiResourceVariable variable) {
                super.visitResourceVariable(variable);
                List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)variable, place);
                for (PsiClassType actualType : exceptionTypes) {
                    PsiIdentifier name;
                    if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType) || (name = variable.getNameIdentifier()) == null) continue;
                    HighlightExceptionsHandler.this.addOccurrence((PsiElement)name);
                    break;
                }
            }
        });
    }
}

