/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToConstructorAction
extends BaseMoveInitializerToMethodAction {
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.move.initializer.to.constructor", (Object[])new Object[0]);
        if (string == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(3);
        }
        if (super.isAvailable(project, editor, element)) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            assert (field != null);
            if (field.hasModifierProperty("final")) {
                PsiClass containingClass = field.getContainingClass();
                assert (containingClass != null);
                Object[] initializers = containingClass.getInitializers();
                Object[] elements = (PsiElement[])Arrays.stream(containingClass.getFields()).map(f -> f.getInitializer()).filter(Objects::nonNull).toArray(PsiElement[]::new);
                return ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])ArrayUtil.mergeArrays((Object[])elements, (Object[])initializers))).findFirst() == null;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        List<String> list = Arrays.asList("static");
        if (list == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project, @NotNull Editor editor, PsiFile file, @NotNull PsiClass aClass) {
        List<PsiMethod> constructors;
        if (project == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(7);
        }
        if ((constructors = Arrays.asList(aClass.getConstructors())).isEmpty()) {
            Collection<PsiMethod> collection = MoveInitializerToConstructorAction.createConstructor(project, editor, file, aClass);
            if (collection == null) {
                MoveInitializerToConstructorAction.$$$reportNull$$$0(8);
            }
            return collection;
        }
        Collection<PsiMethod> collection = MoveInitializerToConstructorAction.removeChainedConstructors(constructors);
        if (collection == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiMethod> removeChainedConstructors(@NotNull Collection<PsiMethod> constructors) {
        if (constructors == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(10);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(constructors);
        result.removeIf(constructor -> !JavaHighlightUtil.getChainedConstructors(constructor).isEmpty());
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PsiMethod> createConstructor(@NotNull Project project, @NotNull Editor editor, PsiFile file, @NotNull PsiClass aClass) {
        if (project == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(13);
        }
        if (aClass == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(14);
        }
        LocalQuickFixAndIntentionActionOnPsiElement addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
        int offset = editor.getCaretModel().getOffset();
        addDefaultConstructorFix.invoke(project, editor, file);
        editor.getCaretModel().moveToOffset(offset);
        List<PsiMethod> list = Arrays.asList(aClass.getConstructors());
        if (list == null) {
            MoveInitializerToConstructorAction.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsuitableModifiers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeChainedConstructors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeChainedConstructors";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

