/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.codeInsight.javadoc.AnnotationFormat;
import com.intellij.codeInsight.javadoc.ColorUtil;
import com.intellij.codeInsight.javadoc.DocumentationDelegateProvider;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInsight.javadoc.NonCodeAnnotationGenerator;
import com.intellij.javadoc.JavadocGeneratorRunProfile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LangBundle;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocInfoGenerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocInfoGenerator");
    private static final String THROWS_KEYWORD = "throws";
    private static final String BR_TAG = "<br>";
    private static final String LINK_TAG = "link";
    private static final String LITERAL_TAG = "literal";
    private static final String CODE_TAG = "code";
    private static final String LINKPLAIN_TAG = "linkplain";
    private static final String INHERIT_DOC_TAG = "inheritDoc";
    private static final String DOC_ROOT_TAG = "docRoot";
    private static final String VALUE_TAG = "value";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String NBSP = "&nbsp;";
    private static final Pattern ourWhitespaces = Pattern.compile("[ \\n\\r\\t]+");
    private static final Pattern ourRelativeHtmlLinks = Pattern.compile("<A.*?HREF=\"([^\":]*)\"", 34);
    private static final InheritDocProvider<PsiDocTag> ourEmptyProvider = new InheritDocProvider<PsiDocTag>(){

        @Override
        public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
            return null;
        }

        @Override
        public PsiClass getElement() {
            return null;
        }
    };
    private static final InheritDocProvider<PsiElement[]> ourEmptyElementsProvider = JavaDocInfoGenerator.mapProvider(ourEmptyProvider, false);
    private final Project myProject;
    private final PsiElement myElement;
    private final JavaSdkVersion mySdkVersion;

    public JavaDocInfoGenerator(Project project, PsiElement element) {
        this.myProject = project;
        this.myElement = element;
        Sdk jdk = JavadocGeneratorRunProfile.getSdk(this.myProject);
        this.mySdkVersion = jdk == null ? null : JavaSdk.getInstance().getVersion(jdk);
    }

    private static InheritDocProvider<PsiElement[]> mapProvider(final InheritDocProvider<PsiDocTag> i, final boolean dropFirst) {
        return new InheritDocProvider<PsiElement[]>(){

            @Override
            public Pair<PsiElement[], InheritDocProvider<PsiElement[]>> getInheritDoc() {
                PsiElement[] elements;
                Pair pair = i.getInheritDoc();
                if (pair == null) {
                    return null;
                }
                PsiElement[] rawElements = ((PsiDocTag)pair.first).getDataElements();
                if (dropFirst && rawElements.length > 0) {
                    elements = new PsiElement[rawElements.length - 1];
                    System.arraycopy(rawElements, 1, elements, 0, elements.length);
                } else {
                    elements = rawElements;
                }
                return Pair.create((Object)elements, (Object)JavaDocInfoGenerator.mapProvider((InheritDocProvider)pair.second, dropFirst));
            }

            @Override
            public PsiClass getElement() {
                return i.getElement();
            }
        };
    }

    private static DocTagLocator<PsiDocTag> parameterLocator(int parameterIndex) {
        return (owner, comment) -> {
            if (parameterIndex < 0 || comment == null || !(owner instanceof PsiMethod)) {
                return null;
            }
            PsiParameter[] parameters2 = ((PsiMethod)owner).getParameterList().getParameters();
            if (parameterIndex >= parameters2.length) {
                return null;
            }
            String name = parameters2[parameterIndex].getName();
            return JavaDocInfoGenerator.getParamTagByName(comment, name);
        };
    }

    private static DocTagLocator<PsiDocTag> typeParameterLocator(int parameterIndex) {
        return (owner, comment) -> {
            if (parameterIndex < 0 || comment == null || !(owner instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            PsiTypeParameter[] parameters2 = ((PsiTypeParameterListOwner)owner).getTypeParameters();
            if (parameterIndex >= parameters2.length) {
                return null;
            }
            String rawName = parameters2[parameterIndex].getName();
            if (rawName == null) {
                return null;
            }
            String name = '<' + rawName + '>';
            return JavaDocInfoGenerator.getParamTagByName(comment, name);
        };
    }

    private static PsiDocTag getParamTagByName(@NotNull PsiDocComment comment, String name) {
        if (comment == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(0);
        }
        PsiDocTag[] tags = comment.findTagsByName("param");
        return JavaDocInfoGenerator.getTagByName(tags, name);
    }

    private static PsiDocTag getTagByName(@NotNull PsiDocTag[] tags, String name) {
        if (tags == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(1);
        }
        for (PsiDocTag tag : tags) {
            String text2;
            PsiDocTagValue value2 = tag.getValueElement();
            if (value2 == null || (text2 = value2.getText()) == null || !text2.equals(name)) continue;
            return tag;
        }
        return null;
    }

    private static DocTagLocator<PsiDocTag> exceptionLocator(String name) {
        return (owner, comment) -> {
            if (comment == null) {
                return null;
            }
            for (PsiDocTag tag : JavaDocInfoGenerator.getThrowsTags(comment)) {
                String text2;
                PsiDocTagValue value2 = tag.getValueElement();
                if (value2 == null || (text2 = value2.getText()) == null || !JavaDocInfoGenerator.areWeakEqual(text2, name)) continue;
                return tag;
            }
            return null;
        };
    }

    private String sanitizeHtml(StringBuilder buffer) {
        String text2 = buffer.toString();
        if (text2.isEmpty()) {
            return null;
        }
        if (this.myElement != null) {
            StringBuilder result = new StringBuilder();
            int lastRef = 0;
            Matcher matcher = ourRelativeHtmlLinks.matcher(text2);
            while (matcher.find()) {
                int groupStart = matcher.start(1);
                int groupEnd = matcher.end(1);
                result.append(text2, lastRef, groupStart);
                String href = text2.substring(groupStart, groupEnd);
                result.append((String)ObjectUtils.notNull((Object)JavaDocInfoGenerator.createReferenceForRelativeLink(href, this.myElement), (Object)href));
                lastRef = groupEnd;
            }
            if (lastRef > 0) {
                result.append(text2, lastRef, text2.length());
                text2 = result.toString();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated JavaDoc:");
            LOG.debug(text2);
        }
        text2 = StringUtil.replaceIgnoreCase((String)text2, (String)"<p/>", (String)"<p></p>");
        text2 = StringUtil.replace((String)text2, (String)"/>", (String)">");
        return text2;
    }

    @Nullable
    static String createReferenceForRelativeLink(@NotNull String relativeLink, @NotNull PsiElement contextElement) {
        Object targetElement;
        if (relativeLink == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(2);
        }
        if (contextElement == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(3);
        }
        String fragment = null;
        int hashPosition = relativeLink.indexOf(35);
        if (hashPosition >= 0) {
            fragment = relativeLink.substring(hashPosition + 1);
            relativeLink = relativeLink.substring(0, hashPosition);
        }
        if (relativeLink.isEmpty()) {
            targetElement = contextElement instanceof PsiField || contextElement instanceof PsiMethod ? ((PsiMember)contextElement).getContainingClass() : contextElement;
        } else {
            if (!StringUtil.endsWithIgnoreCase((String)relativeLink, (String)".htm") && !StringUtil.endsWithIgnoreCase((String)relativeLink, (String)".html")) {
                return null;
            }
            relativeLink = relativeLink.substring(0, relativeLink.lastIndexOf(46));
            Object packageName = JavaDocInfoGenerator.getPackageName(contextElement);
            if (packageName == null) {
                return null;
            }
            Couple<String> pathWithPackage = JavaDocInfoGenerator.removeParentReferences(relativeLink, (String)packageName);
            if (pathWithPackage == null) {
                return null;
            }
            relativeLink = (String)pathWithPackage.first;
            packageName = (String)pathWithPackage.second;
            relativeLink = relativeLink.replace('/', '.');
            String qualifiedTargetName = ((String)packageName).isEmpty() ? relativeLink : (String)packageName + '.' + relativeLink;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)contextElement.getProject());
            Object object = targetElement = "package-summary".equals(StringUtil.getShortName((String)qualifiedTargetName)) ? javaPsiFacade.findPackage(StringUtil.getPackageName((String)qualifiedTargetName)) : javaPsiFacade.findClass(qualifiedTargetName, contextElement.getResolveScope());
        }
        if (targetElement == null) {
            return null;
        }
        if (fragment != null && targetElement instanceof PsiClass) {
            if (fragment.indexOf(45) >= 0 || fragment.indexOf(40) >= 0) {
                for (PsiMethod method : targetElement.getMethods()) {
                    Set<String> signatures = JavaDocumentationProvider.getHtmlMethodSignatures(method, null);
                    if (!signatures.contains(fragment)) continue;
                    targetElement = method;
                    fragment = null;
                    break;
                }
            } else {
                for (PsiField field : targetElement.getFields()) {
                    if (!fragment.equals(field.getName())) continue;
                    targetElement = field;
                    fragment = null;
                    break;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("psi_element://");
        builder.append(JavaDocUtil.getReferenceText(targetElement.getProject(), (PsiElement)targetElement));
        if (fragment != null) {
            builder.append("###").append(fragment);
        }
        return builder.toString();
    }

    @Nullable
    private static Couple<String> removeParentReferences(String path, String packageName) {
        while (path.startsWith("../")) {
            if (packageName.isEmpty()) {
                return null;
            }
            int dotPos = packageName.lastIndexOf(46);
            packageName = dotPos < 0 ? "" : packageName.substring(0, dotPos);
            path = path.substring(3);
        }
        return Couple.of((Object)path, (Object)packageName);
    }

    private static String getPackageName(PsiElement element) {
        String packageName = null;
        if (element instanceof PsiPackage) {
            packageName = ((PsiPackage)element).getQualifiedName();
        } else {
            PsiFile file = element.getContainingFile();
            if (file instanceof PsiClassOwner) {
                packageName = ((PsiClassOwner)file).getPackageName();
            }
        }
        return packageName;
    }

    public boolean generateDocInfoCore(StringBuilder buffer, boolean generatePrologue) {
        if (this.myElement instanceof PsiClass) {
            this.generateClassJavaDoc(buffer, (PsiClass)this.myElement, generatePrologue);
        } else if (this.myElement instanceof PsiMethod) {
            this.generateMethodJavaDoc(buffer, (PsiMethod)this.myElement, generatePrologue);
        } else if (this.myElement instanceof PsiParameter) {
            this.generateMethodParameterJavaDoc(buffer, (PsiParameter)this.myElement, generatePrologue);
        } else if (this.myElement instanceof PsiField) {
            this.generateFieldJavaDoc(buffer, (PsiField)this.myElement, generatePrologue);
        } else if (this.myElement instanceof PsiVariable) {
            this.generateVariableJavaDoc(buffer, (PsiVariable)this.myElement, generatePrologue);
        } else if (this.myElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myElement);
            if (aPackage == null) {
                return false;
            }
            this.generatePackageJavaDoc(buffer, aPackage, generatePrologue);
        } else if (this.myElement instanceof PsiPackage) {
            this.generatePackageJavaDoc(buffer, (PsiPackage)this.myElement, generatePrologue);
        } else if (this.myElement instanceof PsiJavaModule) {
            this.generateModuleJavaDoc(buffer, (PsiJavaModule)this.myElement, generatePrologue);
        } else {
            return false;
        }
        return true;
    }

    public static String generateSignature(PsiElement element) {
        StringBuilder buf = new StringBuilder();
        if (element instanceof PsiClass) {
            if (JavaDocInfoGenerator.generateClassSignature(buf, (PsiClass)element, SignaturePlace.ToolTip)) {
                return null;
            }
        } else if (element instanceof PsiField) {
            JavaDocInfoGenerator.generateFieldSignature(buf, (PsiField)element, SignaturePlace.ToolTip);
        } else if (element instanceof PsiMethod) {
            JavaDocInfoGenerator.generateMethodSignature(buf, (PsiMethod)element, SignaturePlace.ToolTip);
        }
        return buf.toString();
    }

    @Nullable
    public String generateDocInfo(List<String> docURLs) {
        StringBuilder buffer = new StringBuilder();
        if (!this.generateDocInfoCore(buffer, true)) {
            return null;
        }
        if (docURLs != null) {
            if (buffer.length() > 0 && this.elementHasSourceCode()) {
                LOG.debug("Documentation for " + this.myElement + " was generated from source code, it wasn't found at following URLs: ", new Object[]{docURLs});
            } else {
                buffer.append("<div class='content'>").append("<p class='centered'>");
                buffer.append("<span class='grayed'>");
                buffer.append("The following documentation url").append(docURLs.size() > 1 ? "s were" : " was").append(" checked:");
                buffer.append(BR_TAG).append(NBSP);
                buffer.append(StringUtil.join(docURLs, XmlStringUtil::escapeString, (String)"<br>&nbsp;"));
                buffer.append("</span>");
                buffer.append(BR_TAG);
                buffer.append("<a href=\"open://Project Settings\">Edit API docs paths</a>");
                buffer.append("</p>").append("</div>");
            }
        }
        return this.sanitizeHtml(buffer);
    }

    private boolean elementHasSourceCode() {
        PsiDirectory[] items;
        if (this.myElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myElement);
            if (aPackage == null) {
                return false;
            }
            items = aPackage.getDirectories((GlobalSearchScope)new EverythingGlobalScope(this.myProject));
        } else if (this.myElement instanceof PsiPackage) {
            items = ((PsiPackage)this.myElement).getDirectories((GlobalSearchScope)new EverythingGlobalScope(this.myProject));
        } else {
            PsiFile containingFile = this.myElement.getNavigationElement().getContainingFile();
            if (containingFile == null) {
                return false;
            }
            items = new PsiFileSystemItem[]{containingFile};
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        for (PsiDirectory item : items) {
            VirtualFile file = item.getVirtualFile();
            if (file == null || !projectFileIndex.isInSource(file)) continue;
            return true;
        }
        return false;
    }

    private void generateClassJavaDoc(StringBuilder buffer, PsiClass aClass, boolean generatePrologue) {
        String packageName;
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        buffer.append("<div class='definition'><pre>");
        PsiFile file = aClass.getContainingFile();
        if (file instanceof PsiJavaFile && !(packageName = ((PsiJavaFile)file).getPackageName()).isEmpty()) {
            buffer.append(packageName);
            buffer.append(BR_TAG);
        }
        if (JavaDocInfoGenerator.generateClassSignature(buffer, aClass, SignaturePlace.Javadoc)) {
            return;
        }
        buffer.append("</pre></div>");
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)aClass);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
            this.generateTypeParametersSection(buffer, aClass);
        } else {
            buffer.append("<table class='sections'>");
        }
        new NonCodeAnnotationGenerator((PsiModifierListOwner)aClass, buffer).explainAnnotations();
        buffer.append("</table>");
    }

    private static boolean generateClassSignature(StringBuilder buffer, PsiClass aClass, SignaturePlace place) {
        boolean generateLink = place == SignaturePlace.Javadoc;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)aClass, place, true);
        JavaDocInfoGenerator.generateModifiers(buffer, (PsiModifierListOwner)aClass, false);
        buffer.append(LangBundle.message((String)(aClass.isInterface() ? "java.terms.interface" : "java.terms.class"), (Object[])new Object[0]));
        buffer.append(' ');
        String refText = JavaDocUtil.getReferenceText(aClass.getProject(), (PsiElement)aClass);
        if (refText == null) {
            buffer.setLength(0);
            return true;
        }
        String labelText = JavaDocUtil.getLabelText(aClass.getProject(), aClass.getManager(), refText, (PsiElement)aClass);
        buffer.append("<b>");
        buffer.append(labelText);
        buffer.append("</b>");
        buffer.append(JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)aClass, false));
        buffer.append('\n');
        PsiClassType[] refs = aClass.getExtendsListTypes();
        if (refs.length > 0 || !aClass.isInterface() && !"java.lang.Object".equals(aClass.getQualifiedName())) {
            buffer.append("extends ");
            if (refs.length == 0) {
                JavaDocInfoGenerator.generateLink(buffer, "java.lang.Object", null, (PsiElement)aClass, false);
            } else {
                JavaDocInfoGenerator.generateRefList(buffer, aClass, generateLink, refs);
            }
            buffer.append('\n');
        }
        if ((refs = aClass.getImplementsListTypes()).length > 0) {
            buffer.append("implements ");
            JavaDocInfoGenerator.generateRefList(buffer, aClass, generateLink, refs);
            buffer.append('\n');
        }
        if (buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.setLength(buffer.length() - 1);
        }
        return false;
    }

    private static void generateRefList(StringBuilder buffer, PsiClass aClass, boolean generateLink, PsiClassType[] refs) {
        for (int i = 0; i < refs.length; ++i) {
            JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[i], (PsiElement)aClass, generateLink);
            if (i >= refs.length - 1) continue;
            buffer.append(',').append(NBSP);
        }
    }

    private void generateTypeParametersSection(StringBuilder buffer, PsiClass aClass) {
        ArrayList<ParamInfo> result = new ArrayList<ParamInfo>();
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            String name = '<' + typeParameter.getName() + '>';
            DocTagLocator<PsiDocTag> locator = JavaDocInfoGenerator.typeParameterLocator(i);
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> inClassComment = JavaDocInfoGenerator.findInClassComment(aClass, locator);
            if (inClassComment != null) {
                result.add(new ParamInfo(name, inClassComment));
                continue;
            }
            Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> inHierarchy = JavaDocInfoGenerator.findInHierarchy(aClass, locator);
            if (inHierarchy == null) continue;
            result.add(new ParamInfo(name, inHierarchy));
        }
        this.generateParametersSection(buffer, CodeInsightBundle.message((String)"javadoc.type.parameters", (Object[])new Object[0]), result);
    }

    @Nullable
    private static Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findInHierarchy(PsiClass psiClass, DocTagLocator<PsiDocTag> locator) {
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair;
        for (PsiClass superClass : psiClass.getSupers()) {
            pair = JavaDocInfoGenerator.findInClassComment(superClass, locator);
            if (pair == null) continue;
            return pair;
        }
        for (PsiClass superInterface : psiClass.getInterfaces()) {
            pair = JavaDocInfoGenerator.findInClassComment(superInterface, locator);
            if (pair == null) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> findInClassComment(final PsiClass psiClass, final DocTagLocator<PsiDocTag> locator) {
        PsiDocTag tag = locator.find((PsiDocCommentOwner)psiClass, JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)psiClass));
        if (tag != null) {
            return new Pair((Object)tag, (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return JavaDocInfoGenerator.findInHierarchy(psiClass, locator);
                }

                @Override
                public PsiClass getElement() {
                    return psiClass;
                }
            });
        }
        return null;
    }

    @Nullable
    private static PsiDocComment getDocComment(PsiJavaDocumentedElement docOwner) {
        PsiElement navElement = docOwner.getNavigationElement();
        if (!(navElement instanceof PsiJavaDocumentedElement)) {
            LOG.info("Wrong navElement: " + navElement + "; original = " + docOwner + " of class " + docOwner.getClass());
            return null;
        }
        PsiDocComment comment = ((PsiJavaDocumentedElement)navElement).getDocComment();
        if (comment == null) {
            PsiElement parent;
            PsiModifierList modifierList;
            PsiModifierList psiModifierList = modifierList = docOwner instanceof PsiDocCommentOwner ? ((PsiDocCommentOwner)docOwner).getModifierList() : null;
            if (modifierList != null && (parent = modifierList.getParent()) instanceof PsiDocCommentOwner && parent.getNavigationElement() instanceof PsiDocCommentOwner) {
                return ((PsiDocCommentOwner)parent.getNavigationElement()).getDocComment();
            }
        }
        return comment;
    }

    private void generateFieldJavaDoc(StringBuilder buffer, PsiField field, boolean generatePrologue) {
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        buffer.append("<div class='definition'><pre>");
        JavaDocInfoGenerator.generateLinkToParentIfNeeded(buffer, (PsiMember)field);
        JavaDocInfoGenerator.generateFieldSignature(buffer, field, SignaturePlace.Javadoc);
        buffer.append("</pre></div>");
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)field);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
        } else {
            buffer.append("<table class='sections'>");
        }
        ColorUtil.appendColorPreview((PsiVariable)field, buffer);
        new NonCodeAnnotationGenerator((PsiModifierListOwner)field, buffer).explainAnnotations();
        buffer.append("</table>");
    }

    private static void generateFieldSignature(StringBuilder buffer, PsiField field, SignaturePlace place) {
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)field, place, true);
        JavaDocInfoGenerator.generateModifiers(buffer, (PsiModifierListOwner)field, false);
        JavaDocInfoGenerator.generateType(buffer, field.getType(), (PsiElement)field, place == SignaturePlace.Javadoc);
        buffer.append(" <b>");
        buffer.append(field.getName());
        buffer.append("</b>");
        JavaDocInfoGenerator.appendInitializer(buffer, (PsiVariable)field);
        JavaDocInfoGenerator.enumConstantOrdinal(buffer, field, field.getContainingClass(), "\n");
    }

    public static void enumConstantOrdinal(StringBuilder buffer, PsiField field, PsiClass parentClass, String newLine) {
        Object[] fields;
        int idx;
        if (parentClass != null && field instanceof PsiEnumConstant && (idx = ArrayUtilRt.find((Object[])(fields = parentClass.getFields()), (Object)field)) >= 0) {
            buffer.append(newLine);
            buffer.append("Enum constant ordinal: ").append(idx);
        }
    }

    private void generateVariableJavaDoc(StringBuilder buffer, PsiVariable variable, boolean generatePrologue) {
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        JavaDocInfoGenerator.generateVariableDefinition(buffer, variable, false);
        buffer.append("<table class='sections'>");
        ColorUtil.appendColorPreview(variable, buffer);
        buffer.append("</table>");
    }

    private void generatePackageJavaDoc(StringBuilder buffer, PsiPackage psiPackage, boolean generatePrologue) {
        for (PsiDirectory directory : psiPackage.getDirectories((GlobalSearchScope)new EverythingGlobalScope(this.myProject))) {
            ASTNode docCommentNode;
            FileASTNode node;
            PsiFile packageInfoFile = directory.findFile("package-info.java");
            if (packageInfoFile != null && (node = packageInfoFile.getNode()) != null && (docCommentNode = JavaDocInfoGenerator.findRelevantCommentNode((ASTNode)node)) != null) {
                if (generatePrologue) {
                    this.generatePrologue(buffer);
                }
                this.generateCommonSection(buffer, (PsiDocComment)docCommentNode.getPsi());
                buffer.append("</table>");
                break;
            }
            PsiFile packageHtmlFile = directory.findFile("package.html");
            if (packageHtmlFile == null) continue;
            this.generatePackageHtmlJavaDoc(buffer, packageHtmlFile, generatePrologue);
            break;
        }
    }

    private void generateModuleJavaDoc(StringBuilder buffer, PsiJavaModule module, boolean generatePrologue) {
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        buffer.append("<div class='definition'><pre>");
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)module, SignaturePlace.Javadoc, true);
        buffer.append("module <b>").append(module.getName()).append("</b>");
        buffer.append("</pre></div>");
        PsiDocComment comment = JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)module);
        if (comment != null) {
            this.generateCommonSection(buffer, comment);
            buffer.append("</table>");
        }
    }

    @Nullable
    private static ASTNode findRelevantCommentNode(@NotNull ASTNode fileNode) {
        ASTNode node;
        if (fileNode == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(4);
        }
        if ((node = fileNode.findChildByType(JavaElementType.PACKAGE_STATEMENT)) == null) {
            node = fileNode.getLastChildNode();
        }
        while (node != null && node.getElementType() != JavaDocElementType.DOC_COMMENT) {
            node = node.getTreePrev();
        }
        return node;
    }

    public void generateCommonSection(StringBuilder buffer, PsiDocComment docComment) {
        buffer.append("<div class='content'>");
        this.generateDescription(buffer, docComment);
        buffer.append("</div>");
        buffer.append("<table class='sections'>").append("<p>");
        this.generateApiSection(buffer, docComment);
        this.generateDeprecatedSection(buffer, docComment);
        this.generateSinceSection(buffer, docComment);
        this.generateSeeAlsoSection(buffer, docComment);
    }

    private void generateApiSection(StringBuilder buffer, PsiDocComment comment) {
        String[] tagNames;
        for (String tagName : tagNames = new String[]{"apiNote", "implSpec", "implNote"}) {
            this.generateSingleTagSection(buffer, comment, tagName, () -> tagName + ':');
        }
    }

    private void generatePackageHtmlJavaDoc(StringBuilder buffer, PsiFile packageHtmlFile, boolean generatePrologue) {
        PsiDocComment docComment;
        String htmlText = packageHtmlFile.getText();
        try {
            Element rootTag = JDOMUtil.load((CharSequence)htmlText);
            Element subTag = rootTag.getChild("body");
            if (subTag != null) {
                htmlText = subTag.getValue();
            }
        }
        catch (IOException | JDOMException rootTag) {
            // empty catch block
        }
        htmlText = StringUtil.replace((String)htmlText, (String)"*/", (String)"&#42;&#47;");
        String fileText = "/** " + htmlText + " */";
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)packageHtmlFile.getProject());
        try {
            docComment = elementFactory.createDocCommentFromText(fileText);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        this.generateCommonSection(buffer, docComment);
        buffer.append("</table>");
    }

    @Nullable
    public static PsiExpression calcInitializerExpression(PsiVariable variable) {
        JavaPsiFacade instance;
        Object o;
        PsiModifierList modifierList;
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (modifierList = variable.getModifierList()) != null && modifierList.hasModifierProperty("final") && !(initializer instanceof PsiLiteralExpression) && !(initializer instanceof PsiPrefixExpression) && (o = (instance = JavaPsiFacade.getInstance((Project)variable.getProject())).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) != null) {
            String text2 = o.toString();
            PsiType type2 = variable.getType();
            if (type2.equalsToText("java.lang.String")) {
                text2 = '\"' + StringUtil.escapeStringCharacters((String)StringUtil.shortenPathWithEllipsis((String)text2, (int)120)) + '\"';
            } else if (type2.equalsToText("char")) {
                text2 = '\'' + text2 + '\'';
            }
            try {
                return instance.getElementFactory().createExpressionFromText(text2, (PsiElement)variable);
            }
            catch (IncorrectOperationException ex) {
                LOG.info("type:" + type2.getCanonicalText() + "; text: " + text2, (Throwable)ex);
            }
        }
        return null;
    }

    public static void appendExpressionValue(StringBuilder buffer, PsiExpression initializer) {
        boolean trunc;
        buffer.append(" = ");
        String text2 = initializer.getText().trim();
        int index = JavaDocInfoGenerator.newLineIndex(text2);
        boolean bl = trunc = index < text2.length();
        if (trunc) {
            text2 = text2.substring(0, index);
        }
        buffer.append(StringUtil.escapeXmlEntities((String)text2));
        if (trunc) {
            buffer.append("...");
        }
    }

    private static void appendInitializer(StringBuilder buffer, PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null) {
            buffer.append(" = ");
            String text2 = initializer.getText().trim();
            int index = JavaDocInfoGenerator.newLineIndex(text2);
            if (index < text2.length()) {
                text2 = text2.substring(0, index);
                buffer.append(StringUtil.escapeXmlEntities((String)text2));
                buffer.append("...");
            } else {
                initializer.accept((PsiElementVisitor)new MyVisitor(buffer));
            }
            PsiExpression constantInitializer = JavaDocInfoGenerator.calcInitializerExpression(variable);
            if (constantInitializer != null) {
                buffer.append("<span class='grayed'>");
                JavaDocInfoGenerator.appendExpressionValue(buffer, constantInitializer);
                buffer.append("</span>");
            }
        }
    }

    private static int newLineIndex(String text2) {
        int index2;
        int index1 = text2.indexOf(10);
        if (index1 < 0) {
            index1 = text2.length();
        }
        if ((index2 = text2.indexOf(13)) < 0) {
            index2 = text2.length();
        }
        return Math.min(index1, index2);
    }

    private static int generateModifiers(StringBuilder buffer, PsiModifierListOwner owner, boolean nbsp) {
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)owner, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            if (nbsp) {
                buffer.append(NBSP);
            } else {
                buffer.append(' ');
            }
        }
        return modifiers.length();
    }

    private static void generateAnnotations(StringBuilder buffer, PsiModifierListOwner owner, SignaturePlace place, boolean splitAnnotations) {
        AnnotationFormat format = place == SignaturePlace.Javadoc ? AnnotationFormat.JavaDocShort : AnnotationFormat.ToolTip;
        for (AnnotationDocGenerator anno : AnnotationDocGenerator.getAnnotationsToShow(owner)) {
            anno.generateAnnotation(buffer, format);
            buffer.append(NBSP);
            if (!splitAnnotations) continue;
            buffer.append('\n');
        }
    }

    public static boolean isDocumentedAnnotationType(@NotNull PsiClass resolved) {
        if (resolved == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(5);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)resolved, (String)"java.lang.annotation.Documented", (int)0);
    }

    public static boolean isRepeatableAnnotationType(@Nullable PsiElement annotationType) {
        return annotationType instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)annotationType), (String)"java.lang.annotation.Repeatable", (int)0);
    }

    private static void generateVariableDefinition(StringBuilder buffer, PsiVariable variable, boolean annotations2) {
        buffer.append("<div class='definition'><pre>");
        JavaDocInfoGenerator.generateModifiers(buffer, (PsiModifierListOwner)variable, false);
        if (annotations2) {
            JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)variable, SignaturePlace.Javadoc, true);
        }
        JavaDocInfoGenerator.generateType(buffer, variable.getType(), (PsiElement)variable);
        buffer.append(" <b>");
        buffer.append(variable.getName());
        JavaDocInfoGenerator.appendInitializer(buffer, variable);
        buffer.append("</b>");
        buffer.append("</pre></div>");
    }

    private void generateMethodParameterJavaDoc(StringBuilder buffer, PsiParameter parameter2, boolean generatePrologue) {
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        JavaDocInfoGenerator.generateVariableDefinition(buffer, (PsiVariable)parameter2, true);
        PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)parameter2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (method instanceof PsiMethod) {
            ParamInfo tagInfoProvider;
            PsiMethod psiMethod = (PsiMethod)method;
            PsiParameterList parameterList = psiMethod.getParameterList();
            if (parameter2.getParent() == parameterList && (tagInfoProvider = this.findTagInfoProvider(parameter2, psiMethod, parameterList)) != null) {
                buffer.append("<div class='content'>");
                buffer.append(this.generateOneParameter(tagInfoProvider));
                buffer.append("</div>");
            }
        }
        buffer.append("<table class='sections'>");
        new NonCodeAnnotationGenerator((PsiModifierListOwner)parameter2, buffer).explainAnnotations();
        buffer.append("</table>");
    }

    public String generateMethodParameterJavaDoc() {
        PsiParameter parameter2;
        PsiMethod method;
        if (this.myElement instanceof PsiParameter && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(parameter2 = (PsiParameter)this.myElement), PsiMethod.class)) != null) {
            ParamInfo tagInfoProvider;
            PsiParameterList parameterList = method.getParameterList();
            if (parameter2.getParent() == parameterList && (tagInfoProvider = this.findTagInfoProvider(parameter2, method, parameterList)) != null) {
                PsiElement[] elements = tagInfoProvider.docTag.getDataElements();
                if (elements.length == 0) {
                    return null;
                }
                String text2 = elements[0].getText();
                StringBuilder buffer = new StringBuilder();
                this.generateValue(buffer, tagInfoProvider, elements, text2);
                return buffer.toString();
            }
        }
        return null;
    }

    private ParamInfo findTagInfoProvider(PsiParameter parameter2, PsiMethod method, PsiParameterList parameterList) {
        PsiDocComment docComment = JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)method);
        PsiDocTag[] localTags = docComment != null ? docComment.getTags() : PsiDocTag.EMPTY_ARRAY;
        int parameterIndex = parameterList.getParameterIndex(parameter2);
        return this.findDocTag(localTags, parameter2.getName(), method, JavaDocInfoGenerator.parameterLocator(parameterIndex));
    }

    private void generateMethodJavaDoc(StringBuilder buffer, final PsiMethod method, boolean generatePrologue) {
        if (generatePrologue) {
            this.generatePrologue(buffer);
        }
        buffer.append("<div class='definition'><pre>");
        JavaDocInfoGenerator.generateLinkToParentIfNeeded(buffer, (PsiMember)method);
        JavaDocInfoGenerator.generateMethodSignature(buffer, method, SignaturePlace.Javadoc);
        buffer.append("</pre></div>");
        final DocTagLocator<PsiElement[]> descriptionLocator = (owner, comment) -> comment != null && !JavaDocInfoGenerator.isEmptyDescription(comment) ? comment.getDescriptionElements() : null;
        PsiDocComment comment2 = this.getMethodDocComment(method);
        if (comment2 != null && !JavaDocInfoGenerator.isEmptyDescription(comment2)) {
            buffer.append("<div class='content'>");
            this.generateValue(buffer, comment2.getDescriptionElements(), new InheritDocProvider<PsiElement[]>(){

                @Override
                public Pair<PsiElement[], InheritDocProvider<PsiElement[]>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(method, descriptionLocator);
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            });
            buffer.append("<p>");
            buffer.append("</div>");
            buffer.append("<table class='sections'>");
            buffer.append("<p>");
        } else {
            buffer.append("<table class='sections'>");
            buffer.append("<p>");
            Pair<PsiElement[], InheritDocProvider<PsiElement[]>> pair = this.findInheritDocTag(method, descriptionLocator);
            if (pair != null) {
                PsiElement[] elements = (PsiElement[])pair.first;
                if (elements != null) {
                    PsiClass aClass = ((InheritDocProvider)pair.second).getElement();
                    JavaDocInfoGenerator.startHeaderSection(buffer, CodeInsightBundle.message((String)(aClass.isInterface() ? "javadoc.description.copied.from.interface" : "javadoc.description.copied.from.class"), (Object[])new Object[0])).append("<p>");
                    JavaDocInfoGenerator.generateLink(buffer, (PsiElement)aClass, JavaDocUtil.getShortestClassName(aClass, (PsiElement)method), false);
                    buffer.append(BR_TAG);
                    this.generateValue(buffer, elements, (InheritDocProvider)pair.second);
                    buffer.append("</td>");
                }
            } else {
                PsiDocComment fieldDocComment;
                PsiField field = PropertyUtil.getFieldOfGetter(method);
                if (field == null) {
                    field = PropertyUtil.getFieldOfSetter(method);
                }
                if (field != null && (fieldDocComment = field.getDocComment()) != null && !JavaDocInfoGenerator.isEmptyDescription(fieldDocComment)) {
                    JavaDocInfoGenerator.startHeaderSection(buffer, CodeInsightBundle.message((String)"javadoc.description.copied.from.field", (Object[])new Object[0])).append("<p>");
                    JavaDocInfoGenerator.generateLink(buffer, (PsiElement)field, field.getName(), false);
                    buffer.append(BR_TAG);
                    this.generateValue(buffer, fieldDocComment.getDescriptionElements(), ourEmptyElementsProvider);
                    buffer.append("</td>");
                }
            }
        }
        JavaDocInfoGenerator.generateSuperMethodsSection(buffer, method, false);
        JavaDocInfoGenerator.generateSuperMethodsSection(buffer, method, true);
        if (comment2 != null) {
            this.generateDeprecatedSection(buffer, comment2);
        }
        this.generateParametersSection(buffer, method, comment2);
        this.generateTypeParametersSection(buffer, method, comment2);
        this.generateReturnsSection(buffer, method, comment2);
        this.generateThrowsSection(buffer, method, comment2);
        if (comment2 != null) {
            this.generateApiSection(buffer, comment2);
            this.generateSinceSection(buffer, comment2);
            this.generateSeeAlsoSection(buffer, comment2);
        }
        new NonCodeAnnotationGenerator((PsiModifierListOwner)method, buffer).explainAnnotations();
        buffer.append("</table>");
    }

    private static StringBuilder startHeaderSection(StringBuilder buffer, String message2) {
        return buffer.append("<tr><td valign='top' class='section'><p>").append(message2).append("</td><td valign='top'>");
    }

    private static void generateLinkToParentIfNeeded(StringBuilder buffer, PsiMember member) {
        String qName;
        PsiClass parentClass = member.getContainingClass();
        if (parentClass != null && (qName = parentClass.getQualifiedName()) != null) {
            JavaDocInfoGenerator.generateLink(buffer, qName, qName + JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)parentClass, true), (PsiElement)member, false);
            buffer.append(BR_TAG);
        }
    }

    private static void generateMethodSignature(StringBuilder buffer, PsiMethod method, SignaturePlace place) {
        boolean useShortNames = place == SignaturePlace.ToolTip;
        boolean generateLink = place == SignaturePlace.Javadoc;
        JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)method, place, true);
        int modLength = JavaDocInfoGenerator.generateModifiers(buffer, (PsiModifierListOwner)method, true);
        int indent = modLength == 0 ? 0 : modLength + 1;
        String typeParamsString = JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)method, useShortNames);
        indent += StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)typeParamsString, (boolean)true)).length();
        if (!typeParamsString.isEmpty()) {
            buffer.append(typeParamsString);
            buffer.append(NBSP);
            ++indent;
        }
        if (method.getReturnType() != null) {
            indent += JavaDocInfoGenerator.generateType(buffer, method.getReturnType(), (PsiElement)method, generateLink, useShortNames);
            buffer.append(NBSP);
            ++indent;
        }
        buffer.append("<b>");
        String name = method.getName();
        buffer.append(name);
        buffer.append("</b>");
        indent += name.length();
        buffer.append('(');
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parm = parameters2[i];
            JavaDocInfoGenerator.generateAnnotations(buffer, (PsiModifierListOwner)parm, place, false);
            JavaDocInfoGenerator.generateType(buffer, parm.getType(), (PsiElement)method, generateLink, useShortNames);
            buffer.append(NBSP);
            if (parm.getName() != null) {
                buffer.append(parm.getName());
            }
            if (i >= parameters2.length - 1) continue;
            buffer.append(",\n ");
            buffer.append(StringUtil.repeatSymbol((char)' ', (int)indent));
        }
        buffer.append(')');
        PsiClassType[] refs = method.getThrowsList().getReferencedTypes();
        if (refs.length > 0) {
            buffer.append('\n');
            buffer.append(THROWS_KEYWORD);
            buffer.append(NBSP);
            for (int i = 0; i < refs.length; ++i) {
                JavaDocInfoGenerator.generateLink(buffer, useShortNames ? refs[i].getPresentableText() : refs[i].getCanonicalText(), null, (PsiElement)method, false);
                if (i >= refs.length - 1) continue;
                buffer.append(',').append(NBSP);
            }
        }
    }

    private PsiDocComment getMethodDocComment(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass != null && parentClass.isEnum()) {
            PsiParameterList parameterList = method.getParameterList();
            if (method.getName().equals("values") && parameterList.isEmpty()) {
                return this.loadSyntheticDocComment(method, "/javadoc/EnumValues.java.template");
            }
            if (method.getName().equals("valueOf") && parameterList.getParametersCount() == 1 && parameterList.getParameters()[0].getType().equalsToText("java.lang.String")) {
                return this.loadSyntheticDocComment(method, "/javadoc/EnumValueOf.java.template");
            }
        }
        return JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)method);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PsiDocComment loadSyntheticDocComment(PsiMethod method, String resourceName) {
        PsiClass containingClass = method.getContainingClass();
        assert (containingClass != null) : method;
        String containingClassName = containingClass.getName();
        assert (containingClassName != null) : containingClass;
        try {
            String text2;
            try (InputStream commentStream = JavaDocInfoGenerator.class.getResourceAsStream(resourceName);){
                if (commentStream == null) {
                    PsiDocComment psiDocComment = null;
                    return psiDocComment;
                }
                byte[] bytes = FileUtil.loadBytes((InputStream)commentStream);
                text2 = new String(bytes, CharsetToolkit.UTF8_CHARSET);
            }
            text2 = StringUtil.replace((String)text2, (String)"<ClassName>", (String)containingClassName);
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createDocCommentFromText(text2);
        }
        catch (IncorrectOperationException | IOException e) {
            LOG.info(e);
            return null;
        }
    }

    private void generatePrologue(StringBuilder buffer) {
        URL baseUrl = this.getBaseUrl();
        if (baseUrl != null) {
            buffer.append("<html><head><base href=\"").append(baseUrl).append("\"></head><body>");
        }
    }

    private URL getBaseUrl() {
        VirtualFile vFile;
        PsiFile file;
        PsiElement element;
        if (this.myElement != null && (element = this.myElement.getNavigationElement()) != null && (file = element.getContainingFile()) != null && (vFile = file.getVirtualFile()) != null) {
            return VfsUtilCore.convertToURL((String)vFile.getUrl());
        }
        return null;
    }

    private void generateDescription(StringBuilder buffer, PsiDocComment comment) {
        PsiElement[] elements = comment.getDescriptionElements();
        this.generateValue(buffer, elements, ourEmptyElementsProvider);
    }

    private static boolean isEmptyDescription(PsiDocComment comment) {
        if (comment == null) {
            return true;
        }
        for (PsiElement description : comment.getDescriptionElements()) {
            String text2 = description.getText();
            if (text2 == null || ourWhitespaces.matcher(text2).replaceAll("").isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void generateValue(StringBuilder buffer, PsiElement[] elements, InheritDocProvider<PsiElement[]> provider) {
        this.generateValue(buffer, elements, 0, provider);
    }

    private String getDocRoot() {
        String qName;
        PsiClass aClass = this.myElement instanceof PsiClass ? (PsiClass)this.myElement : (this.myElement instanceof PsiMember ? ((PsiMember)this.myElement).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiClass.class));
        if (aClass != null && (qName = aClass.getQualifiedName()) != null) {
            String path = StringUtil.repeat((String)"../", (int)StringUtil.countChars((CharSequence)qName, (char)'.'));
            return path.isEmpty() ? "" : path.substring(0, path.length() - 1);
        }
        return "";
    }

    private void generateValue(StringBuilder buffer, ParamInfo tag, PsiElement[] elements, String text2) {
        int spaceIndex = text2.indexOf(32);
        if (spaceIndex >= 0) {
            buffer.append(text2.substring(spaceIndex));
        }
        this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider(tag.inheritDocTagProvider, true));
    }

    private void generateValue(StringBuilder buffer, PsiElement[] elements, int startIndex, InheritDocProvider<PsiElement[]> provider) {
        int predictOffset = startIndex < elements.length ? elements[startIndex].getTextOffset() + elements[startIndex].getText().length() : 0;
        for (int i = startIndex; i < elements.length; ++i) {
            if (elements[i].getTextOffset() > predictOffset) {
                buffer.append(' ');
            }
            predictOffset = elements[i].getTextOffset() + elements[i].getText().length();
            PsiElement element = elements[i];
            if (element instanceof PsiInlineDocTag) {
                PsiInlineDocTag tag = (PsiInlineDocTag)element;
                String tagName = tag.getName();
                if (tagName.equals(LINK_TAG)) {
                    this.generateLinkValue(tag, buffer, false);
                    continue;
                }
                if (tagName.equals(LITERAL_TAG)) {
                    this.generateLiteralValue(buffer, (PsiDocTag)tag);
                    continue;
                }
                if (tagName.equals(CODE_TAG)) {
                    this.generateCodeValue(tag, buffer);
                    continue;
                }
                if (tagName.equals(LINKPLAIN_TAG)) {
                    this.generateLinkValue(tag, buffer, true);
                    continue;
                }
                if (tagName.equals(INHERIT_DOC_TAG)) {
                    Pair<PsiElement[], InheritDocProvider<PsiElement[]>> inheritInfo = provider.getInheritDoc();
                    if (inheritInfo == null) continue;
                    this.generateValue(buffer, (PsiElement[])inheritInfo.first, (InheritDocProvider)inheritInfo.second);
                    continue;
                }
                if (tagName.equals(DOC_ROOT_TAG)) {
                    buffer.append(this.getDocRoot());
                    continue;
                }
                if (!tagName.equals(VALUE_TAG)) continue;
                this.generateValueValue(tag, buffer, element);
                continue;
            }
            JavaDocInfoGenerator.appendPlainText(buffer, element.getText());
        }
    }

    private void generateCodeValue(PsiInlineDocTag tag, StringBuilder buffer) {
        buffer.append("<code>");
        int pos = buffer.length();
        this.generateLiteralValue(buffer, (PsiDocTag)tag);
        buffer.append("</code>");
        if (buffer.charAt(pos) == '\n') {
            buffer.insert(pos, ' ');
        }
    }

    private void generateLiteralValue(StringBuilder buffer, PsiDocTag tag) {
        StringBuilder tmpBuffer = new StringBuilder();
        PsiElement[] children = tag.getChildren();
        for (int i = 2; i < children.length - 1; ++i) {
            int pos;
            PsiElement child = children[i];
            if (child instanceof PsiDocToken && ((PsiDocToken)child).getTokenType() == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) continue;
            String elementText = child.getText();
            if (child instanceof PsiWhiteSpace && (pos = elementText.lastIndexOf(10)) >= 0) {
                elementText = elementText.substring(0, pos + 1);
            }
            JavaDocInfoGenerator.appendPlainText(tmpBuffer, StringUtil.escapeXmlEntities((String)elementText));
        }
        if ((this.mySdkVersion == null || this.mySdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) && JavaDocInfoGenerator.isInPre(tag)) {
            buffer.append((CharSequence)tmpBuffer);
        } else {
            buffer.append(StringUtil.trimLeading((CharSequence)tmpBuffer));
        }
    }

    private static boolean isInPre(PsiDocTag tag) {
        for (PsiElement sibling = tag.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
            String text2;
            int pos;
            if (!(sibling instanceof PsiDocToken) || (pos = (text2 = sibling.getText().toLowerCase()).lastIndexOf("pre>")) <= 0) continue;
            switch (text2.charAt(pos - 1)) {
                case '<': {
                    return true;
                }
                case '/': {
                    return false;
                }
            }
        }
        return false;
    }

    private static void appendPlainText(StringBuilder buffer, String text2) {
        buffer.append(StringUtil.replaceUnicodeEscapeSequences((String)text2));
    }

    private void generateLinkValue(PsiInlineDocTag tag, StringBuilder buffer, boolean plainLink) {
        PsiElement[] tagElements = tag.getDataElements();
        String text2 = this.createLinkText(tagElements);
        if (!text2.isEmpty()) {
            JavaDocInfoGenerator.generateLink(buffer, text2, tagElements[0], plainLink);
        }
    }

    private void generateValueValue(PsiInlineDocTag tag, StringBuilder buffer, PsiElement element) {
        String text2 = this.createLinkText(tag.getDataElements());
        PsiField valueField = null;
        if (text2.isEmpty()) {
            if (this.myElement instanceof PsiField) {
                valueField = (PsiField)this.myElement;
            }
        } else {
            if (text2.indexOf(35) == -1) {
                text2 = '#' + text2;
            }
            PsiElement target = null;
            try {
                target = JavaDocUtil.findReferenceTarget(PsiManager.getInstance((Project)this.myProject), text2, this.myElement);
            }
            catch (IndexNotReadyException e) {
                LOG.debug((Throwable)e);
            }
            if (target instanceof PsiField) {
                valueField = (PsiField)target;
            }
        }
        Object value2 = null;
        if (valueField != null) {
            PsiExpression initializer = valueField.getInitializer();
            value2 = JavaConstantExpressionEvaluator.computeConstantExpression(initializer, false);
        }
        if (value2 != null) {
            String valueText = StringUtil.escapeXmlEntities((String)value2.toString());
            if (value2 instanceof String) {
                valueText = '\"' + valueText + '\"';
            }
            if (valueField.equals(this.myElement)) {
                buffer.append(valueText);
            } else {
                JavaDocInfoGenerator.generateLink(buffer, (PsiElement)valueField, valueText, true);
            }
        } else {
            buffer.append(element.getText());
        }
    }

    protected String createLinkText(PsiElement[] tagElements) {
        int predictOffset = tagElements.length > 0 ? tagElements[0].getTextOffset() + tagElements[0].getText().length() : 0;
        StringBuilder buffer = new StringBuilder();
        for (int j = 0; j < tagElements.length; ++j) {
            PsiElement tagElement = tagElements[j];
            if (tagElement.getTextOffset() > predictOffset) {
                buffer.append(' ');
            }
            predictOffset = tagElement.getTextOffset() + tagElement.getText().length();
            this.collectElementText(buffer, tagElement);
            if (j >= tagElements.length - 1) continue;
            buffer.append(' ');
        }
        return buffer.toString().trim();
    }

    protected void collectElementText(final StringBuilder buffer, PsiElement element) {
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof PsiWhiteSpace || element instanceof PsiJavaToken || element instanceof PsiDocToken && ((PsiDocToken)element).getTokenType() != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
                    buffer.append(element.getText());
                }
            }
        });
    }

    private void generateDeprecatedSection(StringBuilder buffer, PsiDocComment comment) {
        this.generateSingleTagSection(buffer, comment, "deprecated", () -> CodeInsightBundle.message((String)"javadoc.deprecated", (Object[])new Object[0]));
    }

    private void generateSingleTagSection(StringBuilder buffer, PsiDocComment comment, String tagName, Supplier<String> computePresentableName) {
        PsiDocTag tag = comment.findTagByName(tagName);
        if (tag != null) {
            JavaDocInfoGenerator.startHeaderSection(buffer, computePresentableName.get()).append("<p>");
            this.generateValue(buffer, tag.getDataElements(), ourEmptyElementsProvider);
            buffer.append("</td>");
        }
    }

    private void generateSinceSection(StringBuilder buffer, PsiDocComment comment) {
        this.generateSingleTagSection(buffer, comment, "since", () -> CodeInsightBundle.message((String)"javadoc.since", (Object[])new Object[0]));
    }

    protected void generateSeeAlsoSection(StringBuilder buffer, PsiDocComment comment) {
        PsiDocTag[] tags = comment.findTagsByName("see");
        if (tags.length > 0) {
            JavaDocInfoGenerator.startHeaderSection(buffer, CodeInsightBundle.message((String)"javadoc.see.also", (Object[])new Object[0])).append("<p>");
            for (int i = 0; i < tags.length; ++i) {
                PsiDocTag tag = tags[i];
                PsiElement[] elements = tag.getDataElements();
                if (elements.length > 0) {
                    String text2 = this.createLinkText(elements);
                    if (StringUtil.startsWithChar((CharSequence)text2, (char)'<')) {
                        buffer.append(text2);
                    } else if (StringUtil.startsWithChar((CharSequence)text2, (char)'\"')) {
                        JavaDocInfoGenerator.appendPlainText(buffer, text2);
                    } else {
                        JavaDocInfoGenerator.generateLink(buffer, text2, (PsiElement)comment, false);
                    }
                }
                if (i >= tags.length - 1) continue;
                buffer.append(",\n");
            }
            buffer.append("</td>");
        }
    }

    private void generateParametersSection(StringBuilder buffer, PsiMethod method, PsiDocComment comment) {
        PsiParameter[] params = method.getParameterList().getParameters();
        PsiDocTag[] localTags = comment != null ? comment.findTagsByName("param") : PsiDocTag.EMPTY_ARRAY;
        ArrayList<ParamInfo> collectedTags = new ArrayList<ParamInfo>();
        for (int i = 0; i < params.length; ++i) {
            DocTagLocator<PsiDocTag> tagLocator;
            PsiParameter param = params[i];
            String paramName = param.getName();
            ParamInfo parmTag = this.findDocTag(localTags, paramName, method, tagLocator = JavaDocInfoGenerator.parameterLocator(i));
            if (parmTag == null) continue;
            collectedTags.add(parmTag);
        }
        this.generateParametersSection(buffer, CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]), collectedTags);
    }

    private void generateTypeParametersSection(StringBuilder buffer, PsiMethod method, PsiDocComment comment) {
        PsiDocTag[] localTags = comment == null ? PsiDocTag.EMPTY_ARRAY : comment.findTagsByName("param");
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        ArrayList<ParamInfo> collectedTags = new ArrayList<ParamInfo>();
        for (int i = 0; i < typeParameters.length; ++i) {
            DocTagLocator<PsiDocTag> tagLocator;
            PsiTypeParameter typeParameter = typeParameters[i];
            String paramName = '<' + typeParameter.getName() + '>';
            ParamInfo parmTag = this.findDocTag(localTags, paramName, method, tagLocator = JavaDocInfoGenerator.typeParameterLocator(i));
            if (parmTag == null) continue;
            collectedTags.add(parmTag);
        }
        this.generateParametersSection(buffer, CodeInsightBundle.message((String)"javadoc.type.parameters", (Object[])new Object[0]), collectedTags);
    }

    private void generateParametersSection(StringBuilder buffer, String titleMessage, List<ParamInfo> collectedTags) {
        if (!collectedTags.isEmpty()) {
            JavaDocInfoGenerator.startHeaderSection(buffer, titleMessage).append(StringUtil.join(collectedTags, tag -> this.generateOneParameter((ParamInfo)tag), (String)"<p>")).append("</td>");
        }
    }

    @Nullable
    private ParamInfo findDocTag(PsiDocTag[] localTags, String paramName, final PsiMethod method, final DocTagLocator<PsiDocTag> tagLocator) {
        PsiDocTag localTag = JavaDocInfoGenerator.getTagByName(localTags, paramName);
        if (localTag != null) {
            return new ParamInfo(paramName, localTag, new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(method, tagLocator);
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            });
        }
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tag = this.findInheritDocTag(method, tagLocator);
        return tag == null ? null : new ParamInfo(paramName, tag);
    }

    private String generateOneParameter(ParamInfo tag) {
        PsiElement[] elements = tag.docTag.getDataElements();
        if (elements.length == 0) {
            return "";
        }
        String text2 = elements[0].getText();
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringUtil.escapeXmlEntities((String)tag.name));
        buffer.append(" &ndash; ");
        this.generateValue(buffer, tag, elements, text2);
        return buffer.toString();
    }

    private void generateReturnsSection(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair;
        PsiDocTag tag = comment == null ? null : comment.findTagByName("return");
        Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> pair2 = pair = tag == null ? null : new Pair<PsiDocTag, InheritDocProvider<PsiDocTag>>((Object)tag, (Object)new InheritDocProvider<PsiDocTag>(){

            @Override
            public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                return JavaDocInfoGenerator.this.findInheritDocTag(method, new ReturnTagLocator());
            }

            @Override
            public PsiClass getElement() {
                return method.getContainingClass();
            }
        });
        if (pair == null && this.myElement instanceof PsiMethod) {
            pair = this.findInheritDocTag((PsiMethod)this.myElement, new ReturnTagLocator());
        }
        if (pair != null) {
            JavaDocInfoGenerator.startHeaderSection(buffer, CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0])).append("<p>");
            this.generateValue(buffer, ((PsiDocTag)pair.first).getDataElements(), JavaDocInfoGenerator.mapProvider((InheritDocProvider)pair.second, false));
            buffer.append("</td>");
        }
    }

    private static PsiDocTag[] getThrowsTags(PsiDocComment comment) {
        if (comment == null) {
            return PsiDocTag.EMPTY_ARRAY;
        }
        Object[] tags1 = comment.findTagsByName(THROWS_KEYWORD);
        Object[] tags2 = comment.findTagsByName("exception");
        return (PsiDocTag[])ArrayUtil.mergeArrays((Object[])tags1, (Object[])tags2);
    }

    private static boolean areWeakEqual(String one, String two) {
        return one.equals(two) || one.endsWith('.' + two) || two.endsWith('.' + one);
    }

    private void generateThrowsSection(StringBuilder buffer, final PsiMethod method, PsiDocComment comment) {
        Object[] localTags;
        Object[] thrownTags = localTags = JavaDocInfoGenerator.getThrowsTags(comment);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)method.getProject());
        HashSet reported = new HashSet();
        for (HierarchicalMethodSignature signature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod superMethod = (PsiMethod)ObjectUtils.tryCast((Object)signature.getMethod().getNavigationElement(), PsiMethod.class);
            PsiDocComment docComment = superMethod != null ? superMethod.getDocComment() : null;
            if (docComment == null) continue;
            Object[] uncheckedExceptions = (PsiDocTag[])Arrays.stream(JavaDocInfoGenerator.getThrowsTags(docComment)).filter(arg_0 -> JavaDocInfoGenerator.lambda$generateThrowsSection$9((PsiDocTag[])localTags, psiFacade, docComment, reported, arg_0)).toArray(PsiDocTag[]::new);
            thrownTags = (PsiDocTag[])ArrayUtil.mergeArrays((Object[])thrownTags, (Object[])uncheckedExceptions);
        }
        LinkedList<Pair> collectedTags = new LinkedList<Pair>();
        ArrayList<PsiClassType> declaredThrows = new ArrayList<PsiClassType>(Arrays.asList(method.getThrowsList().getReferencedTypes()));
        for (int i = thrownTags.length - 1; i > -1; --i) {
            PsiDocTagValue valueElement = thrownTags[i].getValueElement();
            if (valueElement == null) continue;
            Iterator iterator = declaredThrows.iterator();
            while (iterator.hasNext()) {
                PsiClassType classType = (PsiClassType)iterator.next();
                if (!Comparing.strEqual((String)valueElement.getText(), (String)classType.getClassName()) && !Comparing.strEqual((String)valueElement.getText(), (String)classType.getCanonicalText())) continue;
                iterator.remove();
                break;
            }
            final Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tag = this.findInheritDocTag(method, JavaDocInfoGenerator.exceptionLocator(valueElement.getText()));
            collectedTags.addFirst(new Pair(thrownTags[i], (Object)new InheritDocProvider<PsiDocTag>(){

                @Override
                public Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> getInheritDoc() {
                    return tag;
                }

                @Override
                public PsiClass getElement() {
                    return method.getContainingClass();
                }
            }));
        }
        for (PsiClassType trouser : declaredThrows) {
            if (trouser == null) continue;
            String paramName = trouser.getCanonicalText();
            Pair parmTag = null;
            for (Object localTag : thrownTags) {
                String tagName;
                PsiDocTagValue value2 = localTag.getValueElement();
                if (value2 == null || (tagName = value2.getText()) == null || !JavaDocInfoGenerator.areWeakEqual(tagName, paramName)) continue;
                parmTag = Pair.create((Object)localTag, ourEmptyProvider);
                break;
            }
            if (parmTag == null) {
                parmTag = this.findInheritDocTag(method, JavaDocInfoGenerator.exceptionLocator(paramName));
            }
            if (parmTag != null) {
                collectedTags.addLast(parmTag);
                continue;
            }
            try {
                PsiDocTag tag = psiFacade.getElementFactory().createDocTagFromText("@exception " + paramName);
                collectedTags.addLast(Pair.create((Object)tag, ourEmptyProvider));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!collectedTags.isEmpty()) {
            JavaDocInfoGenerator.startHeaderSection(buffer, CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0]));
            for (Pair tag : collectedTags) {
                PsiElement[] elements = ((PsiDocTag)tag.first).getDataElements();
                if (elements.length == 0) continue;
                buffer.append("<p>");
                String text2 = elements[0].getText();
                int index = JavaDocUtil.extractReference(text2);
                String refText = text2.substring(0, index).trim();
                JavaDocInfoGenerator.generateLink(buffer, refText, null, (PsiElement)method, false);
                String rest = text2.substring(index);
                if (!rest.isEmpty() || elements.length > 1) {
                    buffer.append(" &ndash; ");
                }
                buffer.append(rest);
                this.generateValue(buffer, elements, 1, JavaDocInfoGenerator.mapProvider((InheritDocProvider)tag.second, true));
            }
            buffer.append("</td>");
        }
    }

    private static void generateSuperMethodsSection(StringBuilder buffer, PsiMethod method, boolean overrides) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass == null) {
            return;
        }
        if (parentClass.isInterface() && !overrides) {
            return;
        }
        PsiMethod[] supers = method.findSuperMethods();
        if (supers.length == 0) {
            return;
        }
        boolean headerGenerated = false;
        for (PsiMethod superMethod : supers) {
            PsiClass superClass;
            boolean isAbstract = superMethod.hasModifierProperty("abstract");
            if ((!overrides ? !isAbstract : parentClass.isInterface() != isAbstract) || (superClass = superMethod.getContainingClass()) == null) continue;
            if (!headerGenerated) {
                JavaDocInfoGenerator.startHeaderSection(buffer, CodeInsightBundle.message((String)(overrides ? "javadoc.method.overrides" : "javadoc.method.specified.by"), (Object[])new Object[0]));
                buffer.append("<p>");
                headerGenerated = true;
            } else {
                buffer.append(BR_TAG);
            }
            StringBuilder methodBuffer = new StringBuilder();
            JavaDocInfoGenerator.generateLink(methodBuffer, (PsiElement)superMethod, superMethod.getName(), false);
            StringBuilder classBuffer = new StringBuilder();
            JavaDocInfoGenerator.generateLink(classBuffer, (PsiElement)superClass, superClass.getName(), false);
            if (superClass.isInterface()) {
                buffer.append(CodeInsightBundle.message((String)"javadoc.method.in.interface", (Object[])new Object[]{methodBuffer.toString(), classBuffer.toString()}));
                continue;
            }
            buffer.append(CodeInsightBundle.message((String)"javadoc.method.in.class", (Object[])new Object[]{methodBuffer.toString(), classBuffer.toString()}));
        }
        if (headerGenerated) {
            buffer.append("</td>");
        }
    }

    private static void generateLink(StringBuilder buffer, String linkText, @NotNull PsiElement context, boolean plainLink) {
        if (context == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(6);
        }
        int index = JavaDocUtil.extractReference(linkText);
        String refText = linkText.substring(0, index).trim();
        String label = StringUtil.nullize((String)linkText.substring(index).trim());
        JavaDocInfoGenerator.generateLink(buffer, refText, label, context, plainLink);
    }

    static void generateLink(StringBuilder buffer, PsiElement element, String label, boolean plainLink) {
        String refText = JavaDocUtil.getReferenceText(element.getProject(), element);
        if (refText != null) {
            DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (PsiElement)element, (String)refText, (String)label, (boolean)plainLink);
        }
    }

    static int generateLink(StringBuilder buffer, String refText, String label, @NotNull PsiElement context, boolean plainLink) {
        if (context == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(7);
        }
        if (label == null) {
            PsiManager manager = context.getManager();
            label = JavaDocUtil.getLabelText(manager.getProject(), manager, refText, context);
        }
        LOG.assertTrue(refText != null, (Object)"refText appears to be null.");
        PsiElement target = null;
        boolean resolveNotPossible = false;
        try {
            target = JavaDocUtil.findReferenceTarget(context.getManager(), refText, context);
        }
        catch (IndexNotReadyException e) {
            LOG.debug((Throwable)e);
            resolveNotPossible = true;
        }
        if (resolveNotPossible) {
            buffer.append(label);
        } else if (target == null) {
            buffer.append("<font color=red>").append(label).append("</font>");
        } else {
            JavaDocInfoGenerator.generateLink(buffer, target, label, plainLink);
        }
        return StringUtil.stripHtml((String)label, (boolean)true).length();
    }

    public static int generateType(StringBuilder buffer, PsiType type2, PsiElement context) {
        return JavaDocInfoGenerator.generateType(buffer, type2, context, true);
    }

    public static int generateType(StringBuilder buffer, PsiType type2, PsiElement context, boolean generateLink) {
        return JavaDocInfoGenerator.generateType(buffer, type2, context, generateLink, false);
    }

    public static int generateType(StringBuilder buffer, PsiType type2, PsiElement context, boolean generateLink, boolean useShortNames) {
        if (type2 instanceof PsiPrimitiveType) {
            String text2 = StringUtil.escapeXmlEntities((String)type2.getCanonicalText());
            buffer.append(text2);
            return text2.length();
        }
        if (type2 instanceof PsiArrayType) {
            int rest = JavaDocInfoGenerator.generateType(buffer, ((PsiArrayType)type2).getComponentType(), context, generateLink, useShortNames);
            if (type2 instanceof PsiEllipsisType) {
                buffer.append("...");
                return rest + 3;
            }
            buffer.append("[]");
            return rest + 2;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            type2 = ((PsiCapturedWildcardType)type2).getWildcard();
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wt = (PsiWildcardType)type2;
            buffer.append('?');
            PsiType bound = wt.getBound();
            if (bound != null) {
                String keyword = wt.isExtends() ? " extends " : " super ";
                buffer.append(keyword);
                return JavaDocInfoGenerator.generateType(buffer, bound, context, generateLink, useShortNames) + 1 + keyword.length();
            }
            return 1;
        }
        if (type2 instanceof PsiClassType) {
            int length;
            String name;
            PsiClassType.ClassResolveResult result;
            try {
                result = ((PsiClassType)type2).resolveGenerics();
            }
            catch (IndexNotReadyException e) {
                LOG.debug((Throwable)e);
                String text3 = ((PsiClassType)type2).getClassName();
                buffer.append(StringUtil.escapeXmlEntities((String)text3));
                return text3.length();
            }
            PsiClass psiClass = result.getElement();
            PsiSubstitutor psiSubst = result.getSubstitutor();
            if (psiClass == null) {
                String canonicalText = type2.getCanonicalText();
                String text4 = "<font color=red>" + StringUtil.escapeXmlEntities((String)canonicalText) + "</font>";
                buffer.append(text4);
                return canonicalText.length();
            }
            String qName = psiClass.getQualifiedName();
            if (qName == null || psiClass instanceof PsiTypeParameter) {
                String text5 = StringUtil.escapeXmlEntities((String)(useShortNames ? type2.getPresentableText() : type2.getCanonicalText()));
                buffer.append(text5);
                return text5.length();
            }
            String string = name = useShortNames ? JavaDocInfoGenerator.getClassNameWithOuterClasses(psiClass) : qName;
            if (generateLink) {
                length = JavaDocInfoGenerator.generateLink(buffer, name, null, context, false);
            } else {
                buffer.append(name);
                length = buffer.length();
            }
            if (psiClass.hasTypeParameters()) {
                StringBuilder subst = new StringBuilder();
                PsiTypeParameter[] params = psiClass.getTypeParameters();
                subst.append(LT);
                ++length;
                boolean goodSubst = true;
                for (int i = 0; i < params.length; ++i) {
                    PsiType t = psiSubst.substitute(params[i]);
                    if (t == null) {
                        goodSubst = false;
                        break;
                    }
                    length += JavaDocInfoGenerator.generateType(subst, t, context, generateLink, useShortNames);
                    if (i >= params.length - 1) continue;
                    subst.append(", ");
                }
                subst.append(GT);
                ++length;
                if (goodSubst) {
                    String text6 = subst.toString();
                    buffer.append(text6);
                }
            }
            return length;
        }
        if (type2 instanceof PsiDisjunctionType || type2 instanceof PsiIntersectionType) {
            if (!generateLink) {
                String canonicalText = useShortNames ? type2.getPresentableText() : type2.getCanonicalText();
                String text7 = StringUtil.escapeXmlEntities((String)canonicalText);
                buffer.append(text7);
                return canonicalText.length();
            }
            String separator = type2 instanceof PsiDisjunctionType ? " | " : " & ";
            List<PsiType> componentTypes = type2 instanceof PsiIntersectionType ? Arrays.asList(((PsiIntersectionType)type2).getConjuncts()) : ((PsiDisjunctionType)type2).getDisjunctions();
            int length = 0;
            for (PsiType psiType : componentTypes) {
                if (length > 0) {
                    buffer.append(separator);
                    length += 3;
                }
                length += JavaDocInfoGenerator.generateType(buffer, psiType, context, true, useShortNames);
            }
            return length;
        }
        return 0;
    }

    private static String getClassNameWithOuterClasses(@NotNull PsiClass cls) {
        String name;
        if (cls == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(8);
        }
        StringBuilder result = new StringBuilder();
        while (cls != null && (name = cls.getName()) != null) {
            if (result.length() > 0) {
                result.insert(0, '.');
            }
            result.insert(0, name);
            cls = cls.getContainingClass();
        }
        return result.toString();
    }

    static String generateTypeParameters(PsiTypeParameterListOwner owner, boolean useShortNames) {
        if (owner.hasTypeParameters()) {
            PsiTypeParameter[] parameters2 = owner.getTypeParameters();
            StringBuilder buffer = new StringBuilder();
            buffer.append(LT);
            for (int i = 0; i < parameters2.length; ++i) {
                PsiTypeParameter p = parameters2[i];
                buffer.append(p.getName());
                PsiClassType[] refs = JavaDocUtil.getExtendsList((PsiClass)p);
                if (refs.length > 0) {
                    buffer.append(" extends ");
                    for (int j = 0; j < refs.length; ++j) {
                        JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[j], (PsiElement)owner, true, useShortNames);
                        if (j >= refs.length - 1) continue;
                        buffer.append(" & ");
                    }
                }
                if (i >= parameters2.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(GT);
            return buffer.toString();
        }
        return "";
    }

    private <T> Pair<T, InheritDocProvider<T>> searchDocTagInOverriddenMethod(PsiMethod method, final PsiClass aSuper, final DocTagLocator<T> loc) {
        T tag;
        PsiMethod overridden;
        if (aSuper != null && (overridden = JavaDocInfoGenerator.findMethodInSuperClass(method, aSuper)) != null && (tag = loc.find((PsiDocCommentOwner)overridden, JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)overridden))) != null) {
            return new Pair(tag, (Object)new InheritDocProvider<T>(){

                @Override
                public Pair<T, InheritDocProvider<T>> getInheritDoc() {
                    return JavaDocInfoGenerator.this.findInheritDocTag(overridden, loc);
                }

                @Override
                public PsiClass getElement() {
                    return aSuper;
                }
            });
        }
        return null;
    }

    @Nullable
    private static PsiMethod findMethodInSuperClass(PsiMethod method, PsiClass aSuper) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            PsiMethod overridden = aSuper.findMethodBySignature(superMethod, false);
            if (overridden == null) continue;
            return overridden;
        }
        return null;
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> searchDocTagInSupers(PsiClassType[] supers, PsiMethod method, DocTagLocator<T> loc, Set<PsiClass> visitedClasses) {
        try {
            Pair<T, InheritDocProvider<T>> tag;
            PsiClass aSuper;
            for (PsiClassType superType : supers) {
                aSuper = superType.resolve();
                if (aSuper == null || (tag = this.searchDocTagInOverriddenMethod(method, aSuper, loc)) == null) continue;
                return tag;
            }
            for (PsiClassType superType : supers) {
                aSuper = superType.resolve();
                if (aSuper == null || !visitedClasses.add(aSuper) || (tag = this.findInheritDocTagInClass(method, aSuper, loc, visitedClasses)) == null) continue;
                return tag;
            }
        }
        catch (IndexNotReadyException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTagInClass(PsiMethod aMethod, PsiClass aClass, DocTagLocator<T> loc, Set<PsiClass> visitedClasses) {
        if (aClass == null) {
            return null;
        }
        Pair<T, InheritDocProvider<T>> delegate = this.findInheritDocTagInDelegate(aMethod, loc);
        if (delegate != null) {
            return delegate;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return this.searchDocTagInSupers(new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()}, aMethod, loc, visitedClasses);
        }
        PsiClassType[] implementsTypes = aClass.getImplementsListTypes();
        Pair<T, InheritDocProvider<T>> tag = this.searchDocTagInSupers(implementsTypes, aMethod, loc, visitedClasses);
        if (tag != null) {
            return tag;
        }
        PsiClassType[] extendsTypes = aClass.getExtendsListTypes();
        return this.searchDocTagInSupers(extendsTypes, aMethod, loc, visitedClasses);
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTagInDelegate(PsiMethod method, final DocTagLocator<T> loc) {
        final PsiMethod delegateMethod = JavaDocInfoGenerator.findDelegateMethod(method);
        if (delegateMethod == null) {
            return null;
        }
        final PsiClass containingClass = delegateMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        T tag = loc.find((PsiDocCommentOwner)delegateMethod, JavaDocInfoGenerator.getDocComment((PsiJavaDocumentedElement)delegateMethod));
        if (tag == null) {
            return null;
        }
        return Pair.create(tag, (Object)new InheritDocProvider<T>(){

            @Override
            public Pair<T, InheritDocProvider<T>> getInheritDoc() {
                return JavaDocInfoGenerator.this.findInheritDocTag(delegateMethod, loc);
            }

            @Override
            public PsiClass getElement() {
                return containingClass;
            }
        });
    }

    @Nullable
    private static PsiMethod findDelegateMethod(@NotNull PsiMethod method) {
        PsiDocCommentOwner delegate;
        if (method == null) {
            JavaDocInfoGenerator.$$$reportNull$$$0(9);
        }
        return (delegate = DocumentationDelegateProvider.findDocumentationDelegate((PsiMember)method)) instanceof PsiMethod ? (PsiMethod)delegate : null;
    }

    @Nullable
    private <T> Pair<T, InheritDocProvider<T>> findInheritDocTag(PsiMethod method, DocTagLocator<T> loc) {
        PsiClass aClass = method.getContainingClass();
        return aClass != null ? this.findInheritDocTagInClass(method, aClass, loc, new HashSet<PsiClass>()) : null;
    }

    private static /* synthetic */ boolean lambda$generateThrowsSection$9(PsiDocTag[] localTags, JavaPsiFacade psiFacade, PsiDocComment docComment, Set reported, PsiDocTag tag) {
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return false;
        }
        if (Arrays.stream(localTags).map(PsiDocTag::getValueElement).filter(Objects::nonNull).anyMatch(docTagValue -> JavaDocInfoGenerator.areWeakEqual(docTagValue.getText(), valueElement.getText()))) {
            return false;
        }
        PsiClass exClass = psiFacade.getResolveHelper().resolveReferencedClass(valueElement.getText(), (PsiElement)docComment);
        if (exClass == null) {
            return false;
        }
        return ExceptionUtil.isUncheckedException(exClass) && reported.add(exClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeLink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParamTagByName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagByName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceForRelativeLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findRelevantCommentNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentedAnnotationType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateLink";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassNameWithOuterClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findDelegateMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum SignaturePlace {
        Javadoc,
        ToolTip;

    }

    private static class MyVisitor
    extends JavaElementVisitor {
        private final StringBuilder myBuffer;

        MyVisitor(@NotNull StringBuilder buffer) {
            if (buffer == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiExpression[] dimensions;
            this.myBuffer.append("new ");
            PsiType type2 = expression2.getType();
            if (type2 != null) {
                JavaDocInfoGenerator.generateType(this.myBuffer, type2, (PsiElement)expression2);
            }
            if ((dimensions = expression2.getArrayDimensions()).length > 0) {
                LOG.assertTrue(this.myBuffer.charAt(this.myBuffer.length() - 1) == ']');
                this.myBuffer.setLength(this.myBuffer.length() - 1);
                for (PsiExpression dimension : dimensions) {
                    dimension.accept((PsiElementVisitor)this);
                    this.myBuffer.append(", ");
                }
                this.myBuffer.setLength(this.myBuffer.length() - 2);
                this.myBuffer.append(']');
            } else {
                expression2.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitExpressionList(PsiExpressionList list) {
            PsiExpression[] expressions2;
            this.myBuffer.append('(');
            String separator = ", ";
            for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
                expression2.accept((PsiElementVisitor)this);
                this.myBuffer.append(separator);
            }
            if (expressions2.length > 0) {
                this.myBuffer.setLength(this.myBuffer.length() - separator.length());
            }
            this.myBuffer.append(')');
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            this.myBuffer.append(StringUtil.escapeXmlEntities((String)expression2.getMethodExpression().getText()));
            expression2.getArgumentList().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression expression2) {
            this.myBuffer.append(StringUtil.escapeXmlEntities((String)expression2.getText()));
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.myBuffer.append(StringUtil.escapeXmlEntities((String)expression2.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator$MyVisitor", "<init>"));
        }
    }

    private static class ReturnTagLocator
    implements DocTagLocator<PsiDocTag> {
        private ReturnTagLocator() {
        }

        @Override
        public PsiDocTag find(PsiDocCommentOwner owner, PsiDocComment comment) {
            return comment != null ? comment.findTagByName("return") : null;
        }
    }

    private static class ParamInfo {
        private final String name;
        private final PsiDocTag docTag;
        private final InheritDocProvider<PsiDocTag> inheritDocTagProvider;

        private ParamInfo(String paramName, PsiDocTag tag, InheritDocProvider<PsiDocTag> provider) {
            this.name = paramName;
            this.docTag = tag;
            this.inheritDocTagProvider = provider;
        }

        private ParamInfo(String paramName, @NotNull Pair<PsiDocTag, InheritDocProvider<PsiDocTag>> tagWithInheritProvider) {
            if (tagWithInheritProvider == null) {
                ParamInfo.$$$reportNull$$$0(0);
            }
            this(paramName, (PsiDocTag)tagWithInheritProvider.first, (InheritDocProvider)tagWithInheritProvider.second);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagWithInheritProvider", "com/intellij/codeInsight/javadoc/JavaDocInfoGenerator$ParamInfo", "<init>"));
        }
    }

    @FunctionalInterface
    private static interface DocTagLocator<T> {
        public T find(PsiDocCommentOwner var1, PsiDocComment var2);
    }

    private static interface InheritDocProvider<T> {
        public Pair<T, InheritDocProvider<T>> getInheritDoc();

        public PsiClass getElement();
    }
}

