/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedElementVisitorBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotatedElementInspectionBase
extends LocalInspectionTool {
    public boolean myIgnoreInsideImports = true;

    @NotNull
    protected abstract List<String> getAnnotations();

    protected abstract void createProblem(@NotNull PsiReference var1, @NotNull PsiModifierListOwner var2, @NotNull List<PsiAnnotation> var3, @NotNull ProblemsHolder var4);

    protected boolean shouldProcessElement(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(0);
        }
        return AnnotatedElementInspectionBase.isLibraryElement((PsiElement)element);
    }

    @NotNull
    public JPanel createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.ignore.inside.imports", new Object[0]), (InspectionProfileEntry)this, "myIgnoreInsideImports");
        if (singleCheckboxOptionsPanel == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(1);
        }
        return singleCheckboxOptionsPanel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(2);
        }
        if (!this.isApplicable(holder.getFile(), holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                AnnotatedElementInspectionBase.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        AnnotatedElementVisitorBase annotatedElementVisitorBase = new AnnotatedElementVisitorBase(this.myIgnoreInsideImports, this.getAnnotations()){

            @Override
            public void processAnnotatedTarget(@NotNull PsiReference reference, @NotNull PsiModifierListOwner annotatedTarget, @NotNull List<PsiAnnotation> annotations2) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (annotatedTarget == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (annotations2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (AnnotatedElementInspectionBase.this.shouldProcessElement(annotatedTarget)) {
                    AnnotatedElementInspectionBase.this.createProblem(reference, annotatedTarget, annotations2, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "annotatedTarget";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "annotations";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/AnnotatedElementInspectionBase$1";
                objectArray[2] = "processAnnotatedTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (annotatedElementVisitorBase == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(4);
        }
        return annotatedElementVisitorBase;
    }

    private boolean isApplicable(@Nullable PsiFile file, @Nullable Project project) {
        if (file == null || project == null) {
            return false;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = file.getResolveScope();
        for (String annotation : this.getAnnotations()) {
            if (javaPsiFacade.findClass(annotation, scope) == null) continue;
            return true;
        }
        return false;
    }

    protected static String getPresentableText(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(5);
        }
        return DeprecationInspectionBase.getPresentableName(psiElement);
    }

    private static boolean isLibraryElement(@NotNull PsiElement element) {
        if (element == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnnotatedElementInspectionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnnotatedElementInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

