/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationBasedBlockingMethodChecker
implements BlockingMethodChecker {
    private final List<String> myBlockingAnnotations;

    public AnnotationBasedBlockingMethodChecker(List<String> blockingAnnotations) {
        this.myBlockingAnnotations = blockingAnnotations;
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        if (this.myBlockingAnnotations.isEmpty()) {
            return false;
        }
        PsiClass annotationClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.jetbrains.annotations.Blocking", file.getResolveScope());
        return annotationClass != null;
    }

    public boolean isMethodBlocking(@NotNull PsiMethod method) {
        if (method == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)method, this.myBlockingAnnotations, (boolean)false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/AnnotationBasedBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodBlocking";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

