/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.LoopAnalyzer;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.TIntHashSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveVariablesAnalyzer {
    private final DfaValueFactory myFactory;
    private final Instruction[] myInstructions;
    private final MultiMap<Instruction, Instruction> myForwardMap;
    private final MultiMap<Instruction, Instruction> myBackwardMap;
    private final Map<PsiElement, List<DfaVariableValue>> myClosureReads = FactoryMap.create(closure -> {
        final LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        closure.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                DfaValue value2;
                if (element instanceof PsiReferenceExpression && (value2 = LiveVariablesAnalyzer.this.myFactory.createValue((PsiExpression)((PsiReferenceExpression)element))) instanceof DfaVariableValue) {
                    result.add((DfaVariableValue)value2);
                }
                super.visitElement(element);
            }
        });
        return ContainerUtil.newArrayList((Iterable)result);
    });

    public LiveVariablesAnalyzer(ControlFlow flow, DfaValueFactory factory) {
        this.myFactory = factory;
        this.myInstructions = flow.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private List<Instruction> getSuccessors(Instruction ins) {
        return IntStreamEx.of((int[])LoopAnalyzer.getSuccessorIndices(ins.getIndex(), this.myInstructions)).elements((Object[])this.myInstructions).toList();
    }

    private MultiMap<Instruction, Instruction> calcBackwardMap() {
        MultiMap result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            for (Instruction next : this.myForwardMap.get((Object)instruction)) {
                result.putValue((Object)next, (Object)instruction);
            }
        }
        return result;
    }

    private MultiMap<Instruction, Instruction> calcForwardMap() {
        MultiMap result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            if (!this.isInterestingInstruction(instruction)) continue;
            block1: for (Instruction next : this.getSuccessors(instruction)) {
                while (true) {
                    if (this.isInterestingInstruction(next)) {
                        result.putValue((Object)instruction, (Object)next);
                        continue block1;
                    }
                    if (next.getIndex() + 1 >= this.myInstructions.length) continue block1;
                    next = this.myInstructions[next.getIndex() + 1];
                }
            }
        }
        return result;
    }

    @Nullable
    private static DfaVariableValue getWrittenVariable(Instruction instruction) {
        if (instruction instanceof AssignInstruction) {
            DfaValue value2 = ((AssignInstruction)instruction).getAssignedValue();
            return value2 instanceof DfaVariableValue ? (DfaVariableValue)value2 : null;
        }
        if (instruction instanceof FlushVariableInstruction) {
            return ((FlushVariableInstruction)instruction).getVariable();
        }
        return null;
    }

    @NotNull
    private List<DfaVariableValue> getReadVariables(Instruction instruction) {
        if (instruction instanceof PushInstruction && !((PushInstruction)instruction).isReferenceWrite()) {
            DfaValue value2 = ((PushInstruction)instruction).getValue();
            if (value2 instanceof DfaVariableValue) {
                List<DfaVariableValue> list = Collections.singletonList((DfaVariableValue)value2);
                if (list == null) {
                    LiveVariablesAnalyzer.$$$reportNull$$$0(0);
                }
                return list;
            }
        } else {
            PsiElement closure = DfaUtil.getClosureInside(instruction);
            if (closure != null) {
                List<DfaVariableValue> list = this.myClosureReads.get(closure);
                if (list == null) {
                    LiveVariablesAnalyzer.$$$reportNull$$$0(1);
                }
                return list;
            }
        }
        List<DfaVariableValue> list = Collections.emptyList();
        if (list == null) {
            LiveVariablesAnalyzer.$$$reportNull$$$0(2);
        }
        return list;
    }

    private boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (!this.getReadVariables(instruction).isEmpty() || LiveVariablesAnalyzer.getWrittenVariable(instruction) != null) {
            return true;
        }
        return instruction instanceof FinishElementInstruction || instruction instanceof GotoInstruction || instruction instanceof ConditionalGotoInstruction || instruction instanceof ControlTransferInstruction;
    }

    @Nullable
    private Map<FinishElementInstruction, BitSet> findLiveVars() {
        HashMap result = ContainerUtil.newHashMap();
        boolean ok = this.runDfa(false, (PairFunction<Instruction, BitSet, BitSet>)((PairFunction)(instruction, liveVars) -> {
            DfaVariableValue written;
            if (instruction instanceof FinishElementInstruction) {
                BitSet set = (BitSet)result.get(instruction);
                if (set != null) {
                    set.or((BitSet)liveVars);
                    return (BitSet)set.clone();
                }
                if (!liveVars.isEmpty()) {
                    result.put((FinishElementInstruction)instruction, (BitSet)liveVars.clone());
                }
            }
            if ((written = LiveVariablesAnalyzer.getWrittenVariable(instruction)) != null) {
                liveVars = (BitSet)liveVars.clone();
                liveVars.clear(written.getID());
                for (DfaVariableValue var : written.getDependentVariables()) {
                    liveVars.clear(var.getID());
                }
            } else {
                boolean cloned = false;
                for (DfaVariableValue value2 : this.getReadVariables((Instruction)instruction)) {
                    if (liveVars.get(value2.getID())) continue;
                    if (!cloned) {
                        liveVars = (BitSet)liveVars.clone();
                        cloned = true;
                    }
                    liveVars.set(value2.getID());
                }
            }
            return liveVars;
        }));
        return ok ? result : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        Map<FinishElementInstruction, BitSet> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        MultiMap toFlush = MultiMap.createSet();
        boolean ok = this.runDfa(true, (PairFunction<Instruction, BitSet, BitSet>)((PairFunction)(instruction, prevLiveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                int setBit;
                BitSet currentlyLive = (BitSet)liveVars.get(instruction);
                if (currentlyLive == null) {
                    currentlyLive = new BitSet();
                }
                int index = 0;
                while ((setBit = prevLiveVars.nextSetBit(index)) >= 0) {
                    if (!currentlyLive.get(setBit)) {
                        toFlush.putValue((Object)((FinishElementInstruction)instruction), (Object)((DfaVariableValue)this.myFactory.getValue(setBit)));
                    }
                    index = setBit + 1;
                }
                return currentlyLive;
            }
            return prevLiveVars;
        }));
        if (ok) {
            for (FinishElementInstruction instruction2 : toFlush.keySet()) {
                Collection values = toFlush.get((Object)instruction2);
                values.removeIf(var -> var.getDescriptor() instanceof SpecialField || var.getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor);
                instruction2.getVarsToFlush().addAll(values);
            }
        }
    }

    private boolean runDfa(boolean forward, PairFunction<Instruction, BitSet, BitSet> handleState) {
        HashSet entryPoints = ContainerUtil.newHashSet();
        if (forward) {
            entryPoints.add(this.myInstructions[0]);
        } else {
            entryPoints.addAll(ContainerUtil.findAll((Object[])this.myInstructions, (Condition)FilteringIterator.instanceOf(ReturnInstruction.class)));
        }
        Queue queue = new Queue(10);
        for (Instruction i : entryPoints) {
            queue.addLast((Object)new InstructionState(i, new BitSet()));
        }
        int limit = this.myForwardMap.size() * 100;
        HashMap<BitSet, TIntHashSet> processed = new HashMap<BitSet, TIntHashSet>();
        int steps = 0;
        while (!queue.isEmpty()) {
            if (steps > limit) {
                return false;
            }
            if (steps % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state = (InstructionState)((Object)queue.pullFirst());
            Instruction instruction = (Instruction)state.first;
            Collection nextInstructions = forward ? this.myForwardMap.get((Object)instruction) : this.myBackwardMap.get((Object)instruction);
            BitSet nextVars = (BitSet)handleState.fun((Object)instruction, state.second);
            for (Instruction next : nextInstructions) {
                int index;
                TIntHashSet instructionSet = processed.computeIfAbsent(nextVars, k -> new TIntHashSet());
                if (instructionSet.contains(index = next.getIndex() + 1)) continue;
                instructionSet.add(index);
                queue.addLast((Object)new InstructionState(next, nextVars));
                ++steps;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer", "getReadVariables"));
    }

    private static class InstructionState
    extends Pair<Instruction, BitSet> {
        InstructionState(Instruction first, BitSet second) {
            super((Object)first, (Object)second);
        }
    }
}

