/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.enhancedSwitch;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SwitchLabeledRuleCanBeCodeBlockInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            SwitchLabeledRuleCanBeCodeBlockInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightUtil.Feature.ENHANCED_SWITCH.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SwitchLabeledRuleCanBeCodeBlockInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
                super.visitSwitchLabeledRuleStatement(statement);
                PsiSwitchBlock switchBlock = statement.getEnclosingSwitchBlock();
                PsiStatement body2 = statement.getBody();
                if (switchBlock != null && (body2 instanceof PsiExpressionStatement || body2 instanceof PsiThrowStatement)) {
                    if (switchBlock instanceof PsiSwitchExpression && body2 instanceof PsiExpressionStatement) {
                        this.registerProblem(statement, true);
                    } else {
                        this.registerProblem(statement, false);
                    }
                }
            }

            private void registerProblem(@NotNull PsiSwitchLabeledRuleStatement statement, boolean isResultExpression) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                holder.registerProblem(this.getProblemElement(statement), InspectionsBundle.message((String)(isResultExpression ? "inspection.switch.labeled.rule.can.be.code.block.expression.message" : "inspection.switch.labeled.rule.can.be.code.block.statement.message"), (Object[])new Object[0]), new LocalQuickFix[]{new WrapWithCodeBlockFix(isResultExpression)});
            }

            @NotNull
            private PsiElement getProblemElement(@NotNull PsiSwitchLabeledRuleStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)SwitchLabeledRuleCanBeCodeBlockInspection.this.getShortName(), (PsiElement)statement) || ApplicationManager.getApplication().isUnitTestMode())) {
                    PsiSwitchLabeledRuleStatement psiSwitchLabeledRuleStatement = statement;
                    if (psiSwitchLabeledRuleStatement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiSwitchLabeledRuleStatement;
                }
                PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)statement.getFirstChild(), PsiKeyword.class), (Object)statement);
                if (psiElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (javaElementVisitor == null) {
            SwitchLabeledRuleCanBeCodeBlockInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WrapWithCodeBlockFix
    implements LocalQuickFix {
        private final String myMessage;

        WrapWithCodeBlockFix(boolean isResultExpression) {
            this.myMessage = InspectionsBundle.message((String)(isResultExpression ? "inspection.switch.labeled.rule.can.be.code.block.fix.expression.name" : "inspection.switch.labeled.rule.can.be.code.block.fix.statement.name"), (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getStartElement()) instanceof PsiKeyword) {
                element = element.getParent();
            }
            if (element instanceof PsiSwitchLabeledRuleStatement) {
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)element;
                PsiSwitchBlock switchBlock = rule.getEnclosingSwitchBlock();
                PsiStatement body2 = rule.getBody();
                if (switchBlock instanceof PsiSwitchExpression && body2 instanceof PsiExpressionStatement) {
                    WrapWithCodeBlockFix.wrapExpression((PsiExpressionStatement)body2);
                } else if (body2 != null) {
                    WrapWithCodeBlockFix.wrapStatement(body2);
                }
            }
        }

        private static void wrapExpression(PsiExpressionStatement expressionStatement) {
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)expressionStatement, "{ break " + tracker.text((PsiElement)expressionStatement) + " }");
        }

        private static void wrapStatement(@NotNull PsiStatement statement) {
            if (statement == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(3);
            }
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)statement, "{ " + tracker.text((PsiElement)statement) + " }");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$WrapWithCodeBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$WrapWithCodeBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

