/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldCanBeLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "FieldCanBeLocal";
    public final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    public boolean IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS = true;

    private void doCheckClass(PsiClass aClass, ProblemsHolder holder, List<String> excludeAnnos, boolean ignoreFieldsUsedInMultipleMethods) {
        if (aClass.isInterface()) {
            return;
        }
        PsiField[] fields = aClass.getFields();
        LinkedHashSet<PsiField> candidates = new LinkedHashSet<PsiField>();
        for (PsiField field : fields) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, excludeAnnos, (int)0) || !field.hasModifierProperty("private") || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
            candidates.add(field);
        }
        FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers((PsiElement)aClass, (PsiElement)aClass, candidates);
        if (candidates.isEmpty()) {
            return;
        }
        THashSet usedFields = new THashSet();
        FieldCanBeLocalInspection.removeReadFields(aClass, candidates, (Set<? super PsiField>)usedFields, ignoreFieldsUsedInMultipleMethods);
        if (candidates.isEmpty()) {
            return;
        }
        List implicitUsageProviders = ImplicitUsageProvider.EP_NAME.getExtensionList();
        PsiClass scope = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiClass.class);
        if (scope == null) {
            scope = aClass;
        }
        block1: for (PsiField field : candidates) {
            PsiReference reference;
            PsiElement element;
            if (!usedFields.contains(field) || FieldCanBeLocalInspection.hasImplicitReadOrWriteUsage(field, implicitUsageProviders)) continue;
            Query references = ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)scope));
            HashMap<PsiCodeBlock, Collection<PsiReference>> refs = new HashMap<PsiCodeBlock, Collection<PsiReference>>();
            Iterator iterator = references.findAll().iterator();
            while (iterator.hasNext() && (element = (reference = (PsiReference)iterator.next()).getElement()) instanceof PsiReferenceExpression) {
                PsiElement qualifier = ((PsiReferenceExpression)element).getQualifier();
                if ((qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null) && FieldCanBeLocalInspection.groupReferenceByCodeBlocks(refs, reference)) continue;
                continue block1;
            }
            String message2 = InspectionsBundle.message((String)"inspection.field.can.be.local.problem.descriptor", (Object[])new Object[0]);
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)field, (Processor<? super String>)((Processor)qualifiedName -> {
                LocalQuickFix quickFix = SpecialAnnotationsUtilBase.createAddToSpecialAnnotationsListQuickFix(InspectionGadgetsBundle.message("add.0.to.ignore.if.annotated.by.list.quickfix", qualifiedName), QuickFixBundle.message("fix.add.special.annotation.family", new Object[0]), (List<String>)this.EXCLUDE_ANNOS, qualifiedName, (PsiElement)field);
                fixes.add(quickFix);
                return true;
            }));
            LocalQuickFix fix2 = this.createFix(refs);
            if (fix2 != null) {
                fixes.add(fix2);
            }
            holder.registerProblem((PsiElement)field.getNameIdentifier(), message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    protected LocalQuickFix createFix(@NotNull Map<PsiCodeBlock, Collection<PsiReference>> refs) {
        if (refs == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(0);
        }
        return new ConvertFieldToLocalQuickFix(refs);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)this.EXCLUDE_ANNOS, InspectionsBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)new SingleCheckboxOptionsPanel("Ignore fields used in multiple methods", (InspectionProfileEntry)this, "IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS"), "North");
        panel.add((Component)listPanel, "Center");
        return panel;
    }

    private static void removeFieldsReferencedFromInitializers(final PsiElement aClass, PsiElement root, final Set<PsiField> candidates) {
        root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiDocComment docComment;
                PsiMethod resolveMethod;
                PsiExpression expression2;
                PsiStatement[] statements;
                PsiCodeBlock body2;
                if (method.isConstructor() && (body2 = method.getBody()) != null && (statements = body2.getStatements()).length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (resolveMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && resolveMethod.isConstructor()) {
                    FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers(aClass, (PsiElement)expression2, candidates);
                }
                if ((docComment = method.getDocComment()) != null) {
                    FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers(aClass, (PsiElement)docComment, candidates);
                }
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.excludeFieldCandidate((PsiReference)expression2);
                super.visitReferenceExpression(expression2);
            }

            public void visitDocTagValue(PsiDocTagValue value2) {
                this.excludeFieldCandidate(value2.getReference());
                super.visitDocTagValue(value2);
            }

            private void excludeFieldCandidate(PsiReference ref) {
                PsiField field;
                if (ref == null) {
                    return;
                }
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiField && aClass.equals((field = (PsiField)resolved).getContainingClass())) {
                    candidates.remove(field);
                }
            }
        });
    }

    private static void removeReadFields(PsiClass aClass, final Set<? super PsiField> candidates, final Set<? super PsiField> usedFields, final boolean ignoreFieldsUsedInMultipleMethods) {
        final HashSet ignored = new HashSet();
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!candidates.isEmpty()) {
                    super.visitElement(element);
                }
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                PsiCodeBlock body2 = method.getBody();
                if (body2 != null) {
                    FieldCanBeLocalInspection.checkCodeBlock((PsiElement)body2, candidates, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                PsiElement body2 = expression2.getBody();
                if (body2 != null) {
                    FieldCanBeLocalInspection.checkCodeBlock(body2, candidates, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
                }
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                super.visitClassInitializer(initializer);
                FieldCanBeLocalInspection.checkCodeBlock((PsiElement)initializer.getBody(), candidates, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
            }
        });
    }

    private static void checkCodeBlock(PsiElement body2, Set<? super PsiField> candidates, Set<? super PsiField> usedFields, boolean ignoreFieldsUsedInMultipleMethods, Set<? super PsiField> ignored) {
        try {
            Ref writtenVariables = new Ref();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow(body2, AllVariablesControlFlowPolicy.getInstance(), false, false);
            List<PsiVariable> usedVars = ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize());
            for (PsiVariable usedVariable : usedVars) {
                if (!(usedVariable instanceof PsiField)) continue;
                PsiField usedField = (PsiField)usedVariable;
                if (!FieldCanBeLocalInspection.getWrittenVariables(controlFlow, (Ref<Collection<PsiVariable>>)writtenVariables).contains(usedField)) {
                    ignored.add((PsiField)usedField);
                }
                if (usedFields.add((PsiField)usedField) || !ignoreFieldsUsedInMultipleMethods && !ignored.contains(usedField)) continue;
                candidates.remove(usedField);
            }
            if (candidates.isEmpty()) {
                return;
            }
            List<PsiReferenceExpression> readBeforeWrites = ControlFlowUtil.getReadBeforeWrite(controlFlow);
            for (PsiReferenceExpression readBeforeWrite : readBeforeWrites) {
                PsiElement parent;
                PsiField field;
                PsiElement resolved = readBeforeWrite.resolve();
                if (!(resolved instanceof PsiField) || FieldCanBeLocalInspection.isImmutableState((field = (PsiField)resolved).getType()) && PsiUtil.isConstantExpression((PsiExpression)field.getInitializer()) && !FieldCanBeLocalInspection.getWrittenVariables(controlFlow, (Ref<Collection<PsiVariable>>)writtenVariables).contains(field) || (parent = body2.getParent()) instanceof PsiMethod && ((PsiMethod)parent).isConstructor() && field.getInitializer() != null && !field.hasModifierProperty("static") && PsiTreeUtil.isAncestor((PsiElement)((PsiMethod)parent).getContainingClass(), (PsiElement)field, (boolean)true)) continue;
                candidates.remove(field);
            }
        }
        catch (AnalysisCanceledException e) {
            candidates.clear();
        }
    }

    private static boolean isImmutableState(PsiType type2) {
        return type2 instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type2) != null || Comparing.strEqual((String)"java.lang.String", (String)type2.getCanonicalText());
    }

    private static Collection<PsiVariable> getWrittenVariables(ControlFlow controlFlow, Ref<Collection<PsiVariable>> writtenVariables) {
        if (writtenVariables.get() == null) {
            writtenVariables.set(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        }
        return (Collection)writtenVariables.get();
    }

    private static boolean hasImplicitReadOrWriteUsage(PsiField field, List<ImplicitUsageProvider> implicitUsageProviders) {
        for (ImplicitUsageProvider provider : implicitUsageProviders) {
            if (!provider.isImplicitRead((PsiElement)field) && !provider.isImplicitWrite((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    private static boolean groupByCodeBlocks(Collection<? extends PsiReference> allReferences, Map<PsiCodeBlock, Collection<PsiReference>> refs) {
        for (PsiReference psiReference : allReferences) {
            if (FieldCanBeLocalInspection.groupReferenceByCodeBlocks(refs, psiReference)) continue;
            return false;
        }
        return true;
    }

    private static boolean groupReferenceByCodeBlocks(Map<PsiCodeBlock, Collection<PsiReference>> refs, PsiReference psiReference) {
        PsiElement element = psiReference.getElement();
        PsiCodeBlock block = FieldCanBeLocalInspection.getTopmostBlock(element);
        if (block == null) {
            return false;
        }
        Collection<PsiReference> references = refs.get(block);
        if (references == null) {
            references = new ArrayList<PsiReference>();
            if (FieldCanBeLocalInspection.findExistentBlock(refs, psiReference, block, references)) {
                return true;
            }
            refs.put(block, references);
        }
        references.add(psiReference);
        return true;
    }

    @Nullable
    private static PsiCodeBlock getTopmostBlock(@NotNull PsiElement element) {
        if (element == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(1);
        }
        PsiCodeBlock block = null;
        for (PsiElement parent = element.getParent(); parent != null && !(parent instanceof PsiClass); parent = parent.getParent()) {
            if (!(parent instanceof PsiCodeBlock)) continue;
            block = (PsiCodeBlock)parent;
        }
        return block;
    }

    private static boolean findExistentBlock(Map<PsiCodeBlock, Collection<PsiReference>> refs, PsiReference psiReference, PsiCodeBlock block, Collection<? super PsiReference> references) {
        Iterator<PsiCodeBlock> iterator = refs.keySet().iterator();
        while (iterator.hasNext()) {
            PsiCodeBlock codeBlock = iterator.next();
            if (PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)block, (boolean)false)) {
                refs.get(codeBlock).add(psiReference);
                return true;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)codeBlock, (boolean)false)) continue;
            references.addAll(refs.get(codeBlock));
            iterator.remove();
            break;
        }
        return false;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASS_LAYOUT_GROUP_NAME;
        if (string == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.field.can.be.local.display.name", (Object[])new Object[0]);
        if (string == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(4);
        }
        return SHORT_NAME;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(5);
        }
        if (!this.EXCLUDE_ANNOS.isEmpty() || !this.IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(6);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                JavaElementVisitor visitor = new JavaElementVisitor(){

                    public void visitClass(PsiClass aClass) {
                        super.visitClass(aClass);
                        Arrays.stream(aClass.getChildren()).forEach(c -> c.accept((PsiElementVisitor)this));
                        FieldCanBeLocalInspection.this.doCheckClass(aClass, holder, (List)FieldCanBeLocalInspection.this.EXCLUDE_ANNOS, FieldCanBeLocalInspection.this.IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS);
                    }

                    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                        super.visitDeclarationStatement(statement);
                        Arrays.stream(statement.getDeclaredElements()).forEach(d -> d.accept((PsiElementVisitor)this));
                    }

                    public void visitMethod(PsiMethod method) {
                        super.visitMethod(method);
                        PsiCodeBlock body2 = method.getBody();
                        if (body2 != null) {
                            Arrays.stream(body2.getChildren()).forEach(c -> c.accept((PsiElementVisitor)this));
                        }
                    }
                };
                for (PsiClass aClass : file.getClasses()) {
                    aClass.accept((PsiElementVisitor)visitor);
                }
            }
        };
        if (javaElementVisitor == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(7);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertFieldToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiField> {
        private final String myName;

        private ConvertFieldToLocalQuickFix(@NotNull Map<PsiCodeBlock, Collection<PsiReference>> refs) {
            if (refs == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(0);
            }
            Set<PsiCodeBlock> blocks = refs.keySet();
            PsiElement block = blocks.size() == 1 ? PsiTreeUtil.getNonStrictParentOfType((PsiElement)blocks.toArray(PsiCodeBlock.EMPTY_ARRAY)[0], (Class[])new Class[]{PsiClassInitializer.class, PsiMethod.class}) : null;
            this.myName = this.determineName(block);
        }

        @NotNull
        private String determineName(@Nullable PsiElement block) {
            if (block instanceof PsiClassInitializer) {
                String string = InspectionsBundle.message((String)"inspection.field.can.be.local.quickfix.initializer", (Object[])new Object[0]);
                if (string == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (block instanceof PsiMethod) {
                if (((PsiMethod)block).isConstructor()) {
                    String string = InspectionsBundle.message((String)"inspection.field.can.be.local.quickfix.constructor", (Object[])new Object[0]);
                    if (string == null) {
                        ConvertFieldToLocalQuickFix.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                String string = InspectionsBundle.message((String)"inspection.field.can.be.local.quickfix.one.method", (Object[])new Object[]{((PsiMethod)block).getName()});
                if (string == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.getFamilyName();
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected List<PsiElement> moveDeclaration(@NotNull Project project, @NotNull PsiField variable) {
            if (project == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(6);
            }
            if (variable == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(7);
            }
            HashMap refs = new HashMap();
            ArrayList<PsiElement> newDeclarations = new ArrayList<PsiElement>();
            if (!FieldCanBeLocalInspection.groupByCodeBlocks(ReferencesSearch.search((PsiElement)variable).findAll(), refs)) {
                ArrayList<PsiElement> arrayList = newDeclarations;
                if (arrayList == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(8);
                }
                return arrayList;
            }
            for (Collection psiReferences : refs.values()) {
                PsiElement declaration2 = super.moveDeclaration(project, variable, psiReferences, false);
                if (declaration2 == null) continue;
                newDeclarations.add(declaration2);
            }
            if (!newDeclarations.isEmpty()) {
                PsiElement lastDeclaration = (PsiElement)newDeclarations.get(newDeclarations.size() - 1);
                ApplicationManager.getApplication().runWriteAction(() -> this.deleteSourceVariable(project, variable, lastDeclaration));
            }
            ArrayList<PsiElement> arrayList = newDeclarations;
            if (arrayList == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @Override
        @Nullable
        protected PsiField getVariable(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(10);
            }
            return (PsiField)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiField.class);
        }

        @Override
        protected void beforeDelete(@NotNull Project project, @NotNull PsiField variable, @NotNull PsiElement newDeclaration) {
            if (project == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(11);
            }
            if (variable == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(12);
            }
            if (newDeclaration == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(13);
            }
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project, @NotNull PsiField field, @NotNull PsiCodeBlock scope) {
            if (project == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(14);
            }
            if (field == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(15);
            }
            if (scope == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(16);
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            String propertyName = styleManager.variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            String localName = styleManager.propertyNameToVariableName(propertyName, VariableKind.LOCAL_VARIABLE);
            String string = RefactoringUtil.suggestUniqueVariableName(localName, (PsiElement)scope, field);
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(17);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix";
                    break;
                }
                case 6: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newDeclaration";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "determineName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveDeclaration";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestLocalName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 17: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "moveDeclaration";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariable";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeDelete";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestLocalName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

