/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class JavaProjectRootsUtil {
    public static boolean isOutsideJavaSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        if (file.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) && !projectFileIndex.isInLibrary(file);
    }

    @NotNull
    public static List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project) {
        if (project == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(0);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            JavaProjectRootsUtil.collectSuitableDestinationSourceRoots(module, roots);
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static void collectSuitableDestinationSourceRoots(@NotNull Module module, @NotNull List<? super VirtualFile> result) {
        if (module == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(2);
        }
        if (result == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(3);
        }
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder sourceFolder : entry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                if (JavaProjectRootsUtil.isForGeneratedSources(sourceFolder)) continue;
                ContainerUtil.addIfNotNull(result, (Object)sourceFolder.getFile());
            }
        }
    }

    public static boolean isForGeneratedSources(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(4);
        }
        JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        JavaResourceRootProperties resourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        return properties != null && properties.isForGeneratedSources() || resourceProperties != null && resourceProperties.isForGeneratedSources();
    }

    public static boolean isInGeneratedCode(@NotNull VirtualFile file, @NotNull Project project) {
        ProjectFileIndex fileIndex;
        Module module;
        if (file == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(6);
        }
        if ((module = (fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).getModuleForFile(file)) == null || module.isDisposed()) {
            return false;
        }
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot == null) {
            return false;
        }
        SourceFolder folder = ProjectRootsUtil.findSourceFolder((Module)module, (VirtualFile)sourceRoot);
        return folder != null && JavaProjectRootsUtil.isForGeneratedSources(folder);
    }

    @NotNull
    public static GlobalSearchScope getScopeWithoutGeneratedSources(@NotNull GlobalSearchScope baseScope, @NotNull Project project) {
        if (baseScope == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(8);
        }
        NonGeneratedSourceScope nonGeneratedSourceScope = new NonGeneratedSourceScope(baseScope, project);
        if (nonGeneratedSourceScope == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(9);
        }
        return nonGeneratedSourceScope;
    }

    @NotNull
    public static Map<OrderEntry, OrderEntry> findExportedDependenciesReachableViaThisDependencyOnly(@NotNull Module module, @NotNull Module dependency, @NotNull RootModelProvider rootModelProvider) {
        ModuleOrderEntry moduleOrderEntry;
        if (module == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(10);
        }
        if (dependency == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(11);
        }
        if (rootModelProvider == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(12);
        }
        if ((moduleOrderEntry = OrderEntryUtil.findModuleOrderEntry((ModuleRootModel)rootModelProvider.getRootModel(module), (Module)dependency)) == null) {
            throw new IllegalArgumentException("Cannot find dependency from " + module + " to " + dependency);
        }
        Condition withoutThisDependency = entry -> !(entry instanceof ModuleOrderEntry) || !entry.getOwnerModule().equals(module) || !dependency.equals(((ModuleOrderEntry)entry).getModule());
        OrderEnumerator enumerator = rootModelProvider.getRootModel(module).orderEntries().satisfying(withoutThisDependency).using(rootModelProvider).compileOnly().recursively().exportedOnly();
        if (moduleOrderEntry.getScope().isForProductionCompile()) {
            enumerator = enumerator.productionOnly();
        }
        HashSet reachableModules = new HashSet();
        HashSet reachableLibraries = new HashSet();
        enumerator.forEach(entry -> {
            if (entry instanceof ModuleSourceOrderEntry) {
                reachableModules.add(entry.getOwnerModule());
            } else if (entry instanceof ModuleOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)reachableModules, (Object)((ModuleOrderEntry)entry).getModule());
            } else if (entry instanceof LibraryOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)reachableLibraries, (Object)((LibraryOrderEntry)entry).getLibrary());
            }
            return true;
        });
        LinkedHashMap<OrderEntry, OrderEntry> result = new LinkedHashMap<OrderEntry, OrderEntry>();
        rootModelProvider.getRootModel(dependency).orderEntries().using(rootModelProvider).exportedOnly().withoutSdk().withoutModuleSourceEntries().forEach(direct -> {
            if (direct instanceof ModuleOrderEntry) {
                Module depModule = ((ModuleOrderEntry)direct).getModule();
                if (depModule != null && !reachableModules.contains(depModule)) {
                    result.put((OrderEntry)direct, (OrderEntry)direct);
                    rootModelProvider.getRootModel(depModule).orderEntries().using(rootModelProvider).exportedOnly().withoutSdk().recursively().forEach(transitive -> {
                        if ((transitive instanceof ModuleSourceOrderEntry && !reachableModules.contains(transitive.getOwnerModule()) && !depModule.equals(transitive.getOwnerModule()) || transitive instanceof LibraryOrderEntry && ((LibraryOrderEntry)transitive).getLibrary() != null && !reachableLibraries.contains(((LibraryOrderEntry)transitive).getLibrary())) && !result.containsKey(transitive)) {
                            result.put((OrderEntry)transitive, (OrderEntry)direct);
                        }
                        return true;
                    });
                }
            } else if (direct instanceof LibraryOrderEntry && ((LibraryOrderEntry)direct).getLibrary() != null && !reachableLibraries.contains(((LibraryOrderEntry)direct).getLibrary())) {
                result.put((OrderEntry)direct, (OrderEntry)direct);
            }
            return true;
        });
        LinkedHashMap<OrderEntry, OrderEntry> linkedHashMap = result;
        if (linkedHashMap == null) {
            JavaProjectRootsUtil.$$$reportNull$$$0(13);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/JavaProjectRootsUtil";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/JavaProjectRootsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableDestinationSourceRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeWithoutGeneratedSources";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findExportedDependenciesReachableViaThisDependencyOnly";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableDestinationSourceRoots";
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSuitableDestinationSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isForGeneratedSources";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInGeneratedCode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithoutGeneratedSources";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExportedDependenciesReachableViaThisDependencyOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonGeneratedSourceScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final Project myProject;

        private NonGeneratedSourceScope(@NotNull GlobalSearchScope baseScope, @NotNull Project project) {
            if (baseScope == null) {
                NonGeneratedSourceScope.$$$reportNull$$$0(0);
            }
            if (project == null) {
                NonGeneratedSourceScope.$$$reportNull$$$0(1);
            }
            super(baseScope);
            this.myProject = project;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                NonGeneratedSourceScope.$$$reportNull$$$0(2);
            }
            return super.contains(file) && !JavaProjectRootsUtil.isInGeneratedCode(file, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/JavaProjectRootsUtil$NonGeneratedSourceScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

