/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.formatter.java.CompositeAligner;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SubsequentVariablesAlignerConfigurations {
    private static final Set<IElementType> LOCAL_VAR_TYPES_TO_ALIGN = ContainerUtil.newHashSet((Object[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.EQ});
    private static final Set<IElementType> ASSIGN_TYPES_TO_ALIGN = ContainerUtil.newHashSet((Object[])new IElementType[]{JavaElementType.REFERENCE_EXPRESSION, JavaTokenType.EQ});
    static final CompositeAligner.AlignerConfiguration subsequentVariableAligner = new SubsequentVariableAligner();
    static final CompositeAligner.AlignerConfiguration subsequentAssignmentAligner = new SubsequentAssignmentAligner();

    private static class SubsequentAssignmentAligner
    implements CompositeAligner.AlignerConfiguration {
        private SubsequentAssignmentAligner() {
        }

        @Override
        public boolean shouldAlign(@NotNull ASTNode child) {
            ASTNode expressionNode;
            IElementType childType;
            if (child == null) {
                SubsequentAssignmentAligner.$$$reportNull$$$0(0);
            }
            return (childType = child.getElementType()) == JavaElementType.EXPRESSION_STATEMENT && (expressionNode = child.getFirstChildNode()) != null && expressionNode.getElementType() == JavaElementType.ASSIGNMENT_EXPRESSION;
        }

        @Override
        @NotNull
        public AlignmentStrategy createStrategy() {
            AlignmentStrategy.AlignmentPerTypeStrategy alignmentPerTypeStrategy = AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ASSIGN_TYPES_TO_ALIGN, (IElementType)JavaElementType.ASSIGNMENT_EXPRESSION, (boolean)true);
            if (alignmentPerTypeStrategy == null) {
                SubsequentAssignmentAligner.$$$reportNull$$$0(1);
            }
            return alignmentPerTypeStrategy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/formatter/java/SubsequentVariablesAlignerConfigurations$SubsequentAssignmentAligner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/formatter/java/SubsequentVariablesAlignerConfigurations$SubsequentAssignmentAligner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAlign";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SubsequentVariableAligner
    implements CompositeAligner.AlignerConfiguration {
        private SubsequentVariableAligner() {
        }

        @Override
        public boolean shouldAlign(@NotNull ASTNode child) {
            if (child == null) {
                SubsequentVariableAligner.$$$reportNull$$$0(0);
            }
            return child.getElementType() == JavaElementType.DECLARATION_STATEMENT && StringUtil.countNewLines((CharSequence)child.getChars()) == 0;
        }

        @Override
        @NotNull
        public AlignmentStrategy createStrategy() {
            AlignmentStrategy.AlignmentPerTypeStrategy alignmentPerTypeStrategy = AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)LOCAL_VAR_TYPES_TO_ALIGN, (IElementType)JavaElementType.LOCAL_VARIABLE, (boolean)true);
            if (alignmentPerTypeStrategy == null) {
                SubsequentVariableAligner.$$$reportNull$$$0(1);
            }
            return alignmentPerTypeStrategy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/formatter/java/SubsequentVariablesAlignerConfigurations$SubsequentVariableAligner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/formatter/java/SubsequentVariablesAlignerConfigurations$SubsequentVariableAligner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAlign";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

