/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScopedClassHierarchy {
    private static final TObjectHashingStrategy<PsiClass> CLASS_HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            return StringUtil.notNullize((String)object.getQualifiedName()).hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            String qname1 = o1.getQualifiedName();
            if (qname1 != null) {
                return qname1.equals(o2.getQualifiedName());
            }
            return o1.getManager().areElementsEquivalent((PsiElement)o1, (PsiElement)o2);
        }
    };
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"ScopedClassHierarchy");
    private final PsiClass myPlaceClass;
    private final GlobalSearchScope myResolveScope;
    private volatile Map<PsiClass, PsiClassType.ClassResolveResult> mySupersWithSubstitutors;
    private volatile List<PsiClassType.ClassResolveResult> myImmediateSupersWithCapturing;
    private final Map<LanguageLevel, Map<PsiClass, PsiSubstitutor>> myAllSupersWithCapturing = ConcurrentFactoryMap.createMap(this::calcAllMemberSupers);

    ScopedClassHierarchy(PsiClass psiClass, GlobalSearchScope resolveScope) {
        this.myPlaceClass = psiClass;
        this.myResolveScope = resolveScope;
    }

    void visitType(@NotNull PsiClassType type2, Map<PsiClass, PsiClassType.ClassResolveResult> map2) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (type2 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(0);
        }
        if ((psiClass = (resolveResult = type2.resolveGenerics()).getElement()) == null || InheritanceImplUtil.hasObjectQualifiedName(psiClass) || map2.containsKey(psiClass)) {
            return;
        }
        map2.put(psiClass, resolveResult);
        for (PsiType superType : ScopedClassHierarchy.getSuperTypes(psiClass)) {
            Object object = superType = type2.isRaw() && superType instanceof PsiClassType ? ((PsiClassType)superType).rawType() : resolveResult.getSubstitutor().substitute(superType);
            if (!((superType = PsiClassImplUtil.correctType(superType, this.myResolveScope)) instanceof PsiClassType)) continue;
            this.visitType((PsiClassType)superType, map2);
        }
    }

    @NotNull
    private static List<PsiType> getSuperTypes(PsiClass psiClass) {
        ArrayList superTypes = ContainerUtil.newArrayList();
        if (psiClass instanceof PsiAnonymousClass) {
            ContainerUtil.addIfNotNull((Collection)superTypes, (Object)((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        Collections.addAll(superTypes, psiClass.getExtendsListTypes());
        Collections.addAll(superTypes, psiClass.getImplementsListTypes());
        ArrayList arrayList = superTypes;
        if (arrayList == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    static ScopedClassHierarchy getHierarchy(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        if (psiClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(2);
        }
        if (resolveScope == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(3);
        }
        ScopedClassHierarchy scopedClassHierarchy = (ScopedClassHierarchy)((Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(resolveScope1 -> new ScopedClassHierarchy(psiClass, (GlobalSearchScope)resolveScope1));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        })).get(resolveScope);
        if (scopedClassHierarchy == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(4);
        }
        return scopedClassHierarchy;
    }

    @Nullable
    static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiClass superClass) {
        PsiClassType.ClassResolveResult resolveResult;
        if (derivedClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(6);
        }
        if (superClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(7);
        }
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(derivedClass, scope);
        THashMap map2 = hierarchy.mySupersWithSubstitutors;
        if (map2 == null) {
            map2 = ContainerUtil.newTroveMap(CLASS_HASHING_STRATEGY);
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            hierarchy.visitType(JavaPsiFacade.getElementFactory((Project)derivedClass.getProject()).createType(derivedClass, PsiSubstitutor.EMPTY), (Map<PsiClass, PsiClassType.ClassResolveResult>)map2);
            if (stamp.mayCacheNow()) {
                hierarchy.mySupersWithSubstitutors = map2;
            }
        }
        if ((resolveResult = (PsiClassType.ClassResolveResult)map2.get(superClass)) == null) {
            return null;
        }
        PsiClass cachedClass = (PsiClass)ObjectUtils.assertNotNull((Object)resolveResult.getElement());
        PsiSubstitutor cachedSubstitutor = resolveResult.getSubstitutor();
        return cachedClass == superClass ? cachedSubstitutor : ScopedClassHierarchy.mirrorSubstitutor(superClass, cachedClass, cachedSubstitutor);
    }

    @NotNull
    private static PsiSubstitutor mirrorSubstitutor(@NotNull PsiClass from, @NotNull PsiClass to, @NotNull PsiSubstitutor substitutor) {
        if (from == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(8);
        }
        if (to == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(9);
        }
        if (substitutor == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(10);
        }
        Iterator baseParams = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)to);
        Iterator candidateParams = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)from);
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        while (baseParams.hasNext()) {
            if (!candidateParams.hasNext()) {
                PsiSubstitutor psiSubstitutor = JavaClassSupersImpl.createRawSubstitutor(to);
                if (psiSubstitutor == null) {
                    ScopedClassHierarchy.$$$reportNull$$$0(11);
                }
                return psiSubstitutor;
            }
            answer = answer.put((PsiTypeParameter)baseParams.next(), substitutor.substitute((PsiTypeParameter)candidateParams.next()));
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(12);
        }
        return psiSubstitutor;
    }

    @NotNull
    List<PsiClassType.ClassResolveResult> getImmediateSupersWithCapturing() {
        List list = this.myImmediateSupersWithCapturing;
        if (list == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            list = (List)ourGuard.doPreventingRecursion((Object)this, true, () -> this.calcImmediateSupersWithCapturing());
            if (list == null) {
                List<PsiClassType.ClassResolveResult> list2 = Collections.emptyList();
                if (list2 == null) {
                    ScopedClassHierarchy.$$$reportNull$$$0(13);
                }
                return list2;
            }
            if (stamp.mayCacheNow()) {
                this.myImmediateSupersWithCapturing = list;
            }
        }
        List list3 = list;
        if (list3 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(14);
        }
        return list3;
    }

    @NotNull
    private List<PsiClassType.ClassResolveResult> calcImmediateSupersWithCapturing() {
        PsiUtilCore.ensureValid((PsiElement)this.myPlaceClass);
        ArrayList list = ContainerUtil.newArrayList();
        for (PsiClassType type2 : this.myPlaceClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult result;
            PsiClass superClass;
            PsiUtil.ensureValidType((PsiType)type2);
            PsiClassType corrected = PsiClassImplUtil.correctType(type2, this.myResolveScope);
            if (corrected == null || (superClass = (result = ((PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)corrected, (PsiElement)this.myPlaceClass)).resolveGenerics()).getElement()) == null || !PsiSearchScopeUtil.isInScope((GlobalSearchScope)this.myResolveScope, (PsiElement)superClass)) continue;
            list.add(result);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private Map<PsiClass, PsiSubstitutor> calcAllMemberSupers(LanguageLevel level) {
        THashMap map2 = ContainerUtil.newTroveMap();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myPlaceClass.getProject());
        new PairProcessor<PsiClass, PsiSubstitutor>((Map)map2, factory, level){
            final /* synthetic */ Map val$map;
            final /* synthetic */ PsiElementFactory val$factory;
            final /* synthetic */ LanguageLevel val$level;
            {
                this.val$map = map2;
                this.val$factory = psiElementFactory;
                this.val$level = languageLevel;
            }

            public boolean process(PsiClass eachClass, PsiSubstitutor eachSubstitutor) {
                if (!this.val$map.containsKey(eachClass)) {
                    this.val$map.put(eachClass, eachSubstitutor);
                    PsiClassImplUtil.processSuperTypes(eachClass, eachSubstitutor, this.val$factory, this.val$level, ScopedClassHierarchy.this.myResolveScope, this);
                }
                return true;
            }
        }.process(this.myPlaceClass, PsiSubstitutor.EMPTY);
        THashMap tHashMap = map2;
        if (tHashMap == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(16);
        }
        return tHashMap;
    }

    @Nullable
    PsiSubstitutor getSuperMembersSubstitutor(@NotNull PsiClass superClass, @NotNull LanguageLevel level) {
        if (superClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(17);
        }
        if (level == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(18);
        }
        return this.myAllSupersWithCapturing.get(level).get(superClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ScopedClassHierarchy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ScopedClassHierarchy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mirrorSubstitutor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateSupersWithCapturing";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImmediateSupersWithCapturing";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAllMemberSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitType";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mirrorSubstitutor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMembersSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

