/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaDirectoryServiceImpl
extends CoreJavaDirectoryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.JavaDirectoryServiceImpl");

    @Override
    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        VirtualFile virtualFile;
        Project project;
        ProjectFileIndex projectFileIndex;
        String packageName;
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(0);
        }
        if ((packageName = (projectFileIndex = ProjectRootManager.getInstance((Project)(project = dir.getProject())).getFileIndex()).getPackageNameByDirectory(virtualFile = dir.getVirtualFile())) == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
    }

    @Override
    @Nullable
    public PsiPackage getPackageInSources(@NotNull PsiDirectory dir) {
        VirtualFile virtualFile;
        ProjectFileIndex fileIndex;
        PsiPackage aPackage;
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(1);
        }
        if ((aPackage = this.getPackage(dir)) != null && (fileIndex = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex()).isInSourceContent(virtualFile = dir.getVirtualFile()) && !fileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.RESOURCES)) {
            return aPackage;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(2);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(3);
        }
        PsiClass psiClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, "Class");
        if (psiClass == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(6);
        }
        if (templateName == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(7);
        }
        PsiClass psiClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (psiClass == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(8);
        }
        return psiClass;
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(9);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(10);
        }
        if (templateName == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(11);
        }
        return this.createClass(dir, name, templateName, askForUndefinedVariables, Collections.emptyMap());
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(12);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(13);
        }
        if (templateName == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(14);
        }
        if (additionalProperties == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(15);
        }
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName, askForUndefinedVariables, additionalProperties);
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        String templateName;
        PsiClass someClass;
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(16);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(17);
        }
        if (!(someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName = "Interface")).isInterface()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(18);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        String templateName;
        PsiClass someClass;
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(19);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(20);
        }
        if (!(someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName = "Enum")).isEnum()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(21);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        String templateName;
        PsiClass someClass;
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(22);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(23);
        }
        if (!(someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName = "AnnotationType")).isAnnotationType()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(24);
        }
        return psiClass;
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName) throws IncorrectOperationException {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(25);
        }
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName, false, Collections.emptyMap());
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName, boolean askToDefineVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        PsiElement element;
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(26);
        }
        if (additionalProperties == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(27);
        }
        if (askToDefineVariables) {
            LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed());
        }
        Project project = dir.getProject();
        FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", name);
        for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        String ext = StdFileTypes.JAVA.getDefaultExtension();
        String fileName = name + "." + ext;
        try {
            element = askToDefineVariables ? new CreateFromTemplateDialog(project, dir, template, null, properties).create() : FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)dir);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (element == null) {
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)element.getContainingFile();
        PsiClass[] classes2 = file.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, project));
        }
        if (template.isLiveTemplateEnabled()) {
            CreateFromTemplateActionBase.startLiveTemplate((PsiFile)file);
        }
        return classes2[0];
    }

    private static String getIncorrectTemplateMessage(String templateName, Project project) {
        return PsiBundle.message((String)"psi.error.incorrect.class.template.message", (Object[])new Object[]{FileTemplateManager.getInstance((Project)project).internalTemplateToSubject(templateName), templateName});
    }

    @Override
    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(28);
        }
        if (name == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(29);
        }
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, name);
    }

    public static void checkCreateClassOrInterface(@NotNull PsiDirectory directory, String name) throws IncorrectOperationException {
        String qualifiedName;
        if (directory == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(30);
        }
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)name);
        String fileName = name + "." + StdFileTypes.JAVA.getDefaultExtension();
        directory.checkCreateFile(fileName);
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)directory.getProject());
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = qualifiedName = aPackage == null ? null : aPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qualifiedName) && !helper.isQualifiedName(qualifiedName)) {
            throw new IncorrectOperationException("Cannot create class in invalid package: '" + qualifiedName + "'");
        }
    }

    @Override
    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(31);
        }
        VirtualFile file = dir.getVirtualFile();
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex().getSourceRootForFile(file);
        return file.equals(sourceRoot);
    }

    @Override
    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        if (dir == null) {
            JavaDirectoryServiceImpl.$$$reportNull$$$0(32);
        }
        return JavaPsiImplementationHelper.getInstance(dir.getProject()).getEffectiveLanguageLevel(dir.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/JavaDirectoryServiceImpl";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalProperties";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/JavaDirectoryServiceImpl";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterface";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnum";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInSources";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 21: 
            case 24: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createInterface";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEnum";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationType";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createClassFromTemplate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateClass";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateClassOrInterface";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSourceRoot";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

