/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ParametrizedDuplicates;
import com.intellij.refactoring.extractMethod.VariableDataSnapshot;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodSnapshot {
    public static final Key<ExtractMethodSnapshot> SNAPSHOT_KEY = Key.create((String)"ExtractMethodSnapshot");
    public final Project myProject;
    public final String myMethodName;
    public final boolean myStatic;
    public final boolean myIsChainedConstructor;
    public final String myMethodVisibility;
    public final Nullability myNullability;
    @Nullable
    public final SmartTypePointer myReturnType;
    @NotNull
    public final List<SmartPsiElementPointer<PsiVariable>> myOutputVariables;
    @Nullable
    public final SmartPsiElementPointer<PsiVariable> myOutputVariable;
    @Nullable
    public final SmartPsiElementPointer<PsiVariable> myArtificialOutputVariable;
    @NotNull
    public final List<VariableDataSnapshot> myVariableDatum;
    public final boolean myFoldable;
    @Nullable
    public final SmartPsiElementPointer<PsiClass> myTargetClass;

    public ExtractMethodSnapshot(@NotNull ExtractMethodProcessor from) {
        if (from == null) {
            ExtractMethodSnapshot.$$$reportNull$$$0(0);
        }
        this.myProject = from.getProject();
        this.myMethodName = from.myMethodName;
        this.myStatic = from.myStatic;
        this.myIsChainedConstructor = from.myIsChainedConstructor;
        this.myMethodVisibility = from.myMethodVisibility;
        this.myNullability = from.myNullability;
        SmartTypePointerManager typePointerManager = SmartTypePointerManager.getInstance((Project)this.myProject);
        this.myReturnType = typePointerManager.createSmartTypePointer(from.myReturnType);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myOutputVariables = StreamEx.of((Object[])from.myOutputVariables).map(arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0)).toList();
        this.myOutputVariable = (SmartPsiElementPointer)ContainerUtil.getFirstItem(this.myOutputVariables);
        this.myArtificialOutputVariable = from.myArtificialOutputVariable != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)from.myArtificialOutputVariable) : null;
        this.myVariableDatum = StreamEx.of((Object[])from.myVariableDatum).map(data -> new VariableDataSnapshot((VariableData)((Object)data), this.myProject)).toList();
        this.myFoldable = from.myInputVariables.isFoldable();
        this.myTargetClass = from.myTargetClass != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)from.myTargetClass) : null;
    }

    public ExtractMethodSnapshot(@NotNull ExtractMethodSnapshot from, @NotNull PsiElement[] pattern, @NotNull PsiElement[] copy) {
        if (from == null) {
            ExtractMethodSnapshot.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            ExtractMethodSnapshot.$$$reportNull$$$0(2);
        }
        if (copy == null) {
            ExtractMethodSnapshot.$$$reportNull$$$0(3);
        }
        this.myProject = from.myProject;
        this.myMethodName = from.myMethodName;
        this.myStatic = from.myStatic;
        this.myIsChainedConstructor = from.myIsChainedConstructor;
        this.myMethodVisibility = from.myMethodVisibility;
        this.myNullability = from.myNullability;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)from.myProject);
        PsiElement copyContext = copy[copy.length - 1];
        PsiType fromReturnType = from.myReturnType != null ? from.myReturnType.getType() : null;
        PsiType copyReturnType = fromReturnType != null ? factory.createTypeFromText(fromReturnType.getCanonicalText(), copyContext) : null;
        this.myReturnType = copyReturnType != null ? SmartTypePointerManager.getInstance((Project)from.myProject).createSmartTypePointer(copyReturnType) : null;
        HashMap variableMap = new HashMap();
        ParametrizedDuplicates.collectCopyMapping(pattern, copy, unused -> false, (unused1, unused2) -> {}, variableMap::put);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myOutputVariables = StreamEx.of(from.myOutputVariables).map(e -> (PsiVariable)e.getElement()).nonNull().map(variableMap::get).nonNull().map(arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0)).toList();
        this.myOutputVariable = (SmartPsiElementPointer)ContainerUtil.getFirstItem(this.myOutputVariables);
        this.myArtificialOutputVariable = Optional.ofNullable(from.myArtificialOutputVariable).map(SmartPsiElementPointer::getElement).map(variableMap::get).map(arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0)).orElse(null);
        this.myVariableDatum = new ArrayList<VariableDataSnapshot>();
        for (VariableDataSnapshot fromData : from.myVariableDatum) {
            PsiVariable copyVariable = (PsiVariable)variableMap.get(fromData.getVariable());
            PsiType fromType = fromData.getType();
            PsiType copyType = fromType != null ? factory.createTypeFromText(fromType.getCanonicalText(), copyContext) : null;
            VariableDataSnapshot copyData = new VariableDataSnapshot(copyVariable, copyType, fromData.name, fromData.originalName, fromData.passAsParameter, from.myProject);
            this.myVariableDatum.add(copyData);
        }
        this.myFoldable = from.myFoldable;
        this.myTargetClass = Optional.ofNullable(from.getTargetClass()).map(PsiElement::getTextRange).map(range -> ExtractMethodSnapshot.findTargetClassInRange(copy[0].getContainingFile(), range)).map(arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0)).orElse(null);
    }

    @Nullable
    private static PsiClass findTargetClassInRange(@Nullable PsiFile file, @NotNull TextRange range) {
        if (range == null) {
            ExtractMethodSnapshot.$$$reportNull$$$0(4);
        }
        return file != null ? CodeInsightUtil.findElementInRange(file, range.getStartOffset(), range.getEndOffset(), PsiClass.class) : null;
    }

    @Nullable
    public PsiClass getTargetClass() {
        return this.myTargetClass != null ? (PsiClass)this.myTargetClass.getElement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodSnapshot";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetClassInRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

