/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReferenceReflectionAccessorBase;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReflectionAccessor
extends ReferenceReflectionAccessorBase<FieldDescriptor> {
    private static final Logger LOG = Logger.getInstance(FieldReflectionAccessor.class);

    public FieldReflectionAccessor(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        if (psiClass == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(1);
        }
        super(psiClass, elementFactory);
    }

    @Override
    @Nullable
    protected FieldDescriptor createDescriptor(@NotNull PsiReferenceExpression expression2) {
        PsiField field;
        PsiElement resolved;
        if (expression2 == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(2);
        }
        if ((resolved = expression2.resolve()) instanceof PsiField && !Objects.equals((field = (PsiField)resolved).getContainingClass(), this.getOuterClass()) && FieldReflectionAccessor.needReplace(field, expression2)) {
            return new FieldDescriptor(field, expression2);
        }
        return null;
    }

    @Override
    protected void grantAccess(@NotNull FieldDescriptor descriptor) {
        PsiElement parent;
        if (descriptor == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(3);
        }
        if ((parent = descriptor.expression.getParent()) instanceof PsiAssignmentExpression && Objects.equals(descriptor.expression, ((PsiAssignmentExpression)parent).getLExpression())) {
            this.grantUpdateAccess((PsiAssignmentExpression)parent, descriptor);
        } else {
            this.grantReadAccess(descriptor);
        }
    }

    private void grantReadAccess(@NotNull FieldDescriptor descriptor) {
        if (descriptor == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(4);
        }
        PsiClass outerClass = this.getOuterClass();
        PsiMethod newMethod = this.createPsiMethod(descriptor, FieldAccessType.GET);
        if (newMethod == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        String qualifier = FieldReflectionAccessor.qualify(descriptor);
        String methodCall = newMethod.getName() + "(" + (qualifier == null ? "null" : qualifier) + ", null)";
        descriptor.expression.replace((PsiElement)this.getElementFactory().createExpressionFromText(methodCall, (PsiElement)descriptor.expression));
    }

    private void grantUpdateAccess(@NotNull PsiAssignmentExpression assignmentExpression, @NotNull FieldDescriptor descriptor) {
        if (assignmentExpression == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(6);
        }
        PsiClass outerClass = this.getOuterClass();
        PsiMethod newMethod = this.createPsiMethod(descriptor, FieldAccessType.SET);
        if (newMethod == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        PsiExpression rightExpression = assignmentExpression.getRExpression();
        if (rightExpression == null) {
            LOG.warn("Expression representing a new field value not found");
            return;
        }
        String newValue = rightExpression.getText();
        String qualifier = FieldReflectionAccessor.qualify(descriptor);
        String args = (qualifier == null ? "null" : qualifier) + ", " + newValue;
        String methodCallExpression = newMethod.getName() + "(" + args + ")";
        PsiExpression newMethodCallExpression = this.getElementFactory().createExpressionFromText(methodCallExpression, (PsiElement)descriptor.expression);
        assignmentExpression.replace((PsiElement)newMethodCallExpression);
    }

    @Nullable
    private PsiMethod createPsiMethod(@NotNull FieldDescriptor descriptor, FieldAccessType accessType) {
        if (descriptor == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(7);
        }
        PsiClass outerClass = this.getOuterClass();
        PsiClass containingClass = descriptor.field.getContainingClass();
        String className = containingClass == null ? null : ClassUtil.getJVMClassName((PsiClass)containingClass);
        String fieldName = descriptor.field.getName();
        if (className == null || fieldName == null) {
            LOG.warn("Code is incomplete. Class name or field name not found");
            return null;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, "accessToField" + StringUtil.capitalize((String)fieldName));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        if (FieldAccessType.GET.equals((Object)accessType)) {
            String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)descriptor.expression, FieldReflectionAccessor.resolveFieldType(descriptor));
            if (returnType == null) {
                LOG.warn("Could not resolve field type");
                return null;
            }
            methodBuilder.accessedField(className, fieldName).setReturnType(returnType);
        } else {
            methodBuilder.updatedField(className, fieldName).setReturnType("void");
        }
        methodBuilder.setStatic(outerClass.hasModifierProperty("static")).addParameter("java.lang.Object", "object").addParameter("java.lang.Object", "value");
        return methodBuilder.build(this.getElementFactory(), (PsiElement)outerClass);
    }

    private static boolean needReplace(@NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
        if (field == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(8);
        }
        if (expression2 == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(9);
        }
        return !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)field) || !PsiReflectionAccessUtil.isQualifierAccessible(expression2.getQualifierExpression());
    }

    @NotNull
    private static PsiType resolveFieldType(@NotNull FieldDescriptor descriptor) {
        if (descriptor == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(10);
        }
        PsiType rawType = descriptor.field.getType();
        PsiType psiType = descriptor.expression.advancedResolve(false).getSubstitutor().substitute(rawType);
        if (psiType == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(11);
        }
        return psiType;
    }

    @Nullable
    private static String qualify(@NotNull FieldDescriptor descriptor) {
        PsiClass containingClass;
        String qualifier;
        if (descriptor == null) {
            FieldReflectionAccessor.$$$reportNull$$$0(12);
        }
        if ((qualifier = PsiReflectionAccessUtil.extractQualifier(descriptor.expression)) == null && !descriptor.field.hasModifierProperty("static") && (containingClass = descriptor.field.getContainingClass()) != null) {
            qualifier = containingClass.getQualifiedName() + ".this";
        }
        return qualifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/FieldReflectionAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/FieldReflectionAccessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "grantAccess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "grantReadAccess";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "grantUpdateAccess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPsiMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "needReplace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveFieldType";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "qualify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FieldDescriptor
    implements ItemToReplaceDescriptor {
        public final PsiField field;
        public final PsiReferenceExpression expression;

        public FieldDescriptor(@NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
            if (field == null) {
                FieldDescriptor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                FieldDescriptor.$$$reportNull$$$0(1);
            }
            this.field = field;
            this.expression = expression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "field";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/FieldReflectionAccessor$FieldDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

