/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.FinalListener;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.introduceVariable.VariableExtractor;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVariableInplaceIntroducer
extends AbstractJavaInplaceIntroducer {
    private SmartPsiElementPointer<? extends PsiElement> myPointer;
    private JCheckBox myCanBeFinalCb;
    private JCheckBox myCanBeVarTypeCb;
    private final IntroduceVariableSettings mySettings;
    private final SmartPsiElementPointer<PsiElement> myChosenAnchor;
    private final boolean myCantChangeFinalModifier;
    private final boolean myHasTypeSuggestion;
    private ResolveSnapshotProvider.ResolveSnapshot myConflictResolver;
    private final TypeExpression myExpression;
    private final boolean myReplaceSelf;
    private boolean myDeleteSelf = true;
    private final boolean mySkipTypeExpressionOnStart;
    private final PsiFile myFile;
    private final boolean myCanBeVarType;

    public JavaVariableInplaceIntroducer(Project project, IntroduceVariableSettings settings, PsiElement chosenAnchor, Editor editor, PsiExpression expr, boolean cantChangeFinalModifier, PsiExpression[] occurrences, TypeSelectorManagerImpl selectorManager, String title) {
        super(project, editor, RefactoringUtil.outermostParenthesizedExpression(expr), null, occurrences, selectorManager, title);
        this.mySettings = settings;
        this.myChosenAnchor = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(chosenAnchor);
        this.myFile = chosenAnchor.getContainingFile();
        this.myCantChangeFinalModifier = cantChangeFinalModifier;
        this.myHasTypeSuggestion = selectorManager.getTypesForAll().length > 1;
        this.myTitle = title;
        this.myExpression = new TypeExpression(this.myProject, this.isReplaceAllOccurrences() ? this.myTypeSelectorManager.getTypesForAll() : this.myTypeSelectorManager.getTypesForOne());
        List rangeMarkers = this.getOccurrenceMarkers();
        editor.putUserData(ReassignVariableUtil.OCCURRENCES_KEY, (Object)rangeMarkers.toArray(new RangeMarker[0]));
        PsiElement parent = ((PsiExpression)this.myExpr).getParent();
        this.myReplaceSelf = parent instanceof PsiExpressionStatement && !(parent.getParent() instanceof PsiSwitchLabeledRuleStatement);
        this.mySkipTypeExpressionOnStart = !(this.myExpr instanceof PsiFunctionalExpression) || !this.myReplaceSelf;
        this.myCanBeVarType = IntroduceVariableBase.canBeExtractedWithoutExplicitType((PsiExpression)this.myExpr);
    }

    protected void beforeTemplateStart() {
        ResolveSnapshotProvider resolveSnapshotProvider;
        if (!this.mySkipTypeExpressionOnStart) {
            PsiTypeElement typeElement;
            PsiVariable variable = this.getVariable();
            PsiTypeElement psiTypeElement = typeElement = variable != null ? variable.getTypeElement() : null;
            if (typeElement != null) {
                this.myEditor.getCaretModel().moveToOffset(typeElement.getTextOffset());
            }
        }
        this.myConflictResolver = (resolveSnapshotProvider = (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(this.myScope.getLanguage())) != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
        super.beforeTemplateStart();
    }

    @Nullable
    protected PsiVariable getVariable() {
        PsiElement declarationStatement;
        PsiElement psiElement = declarationStatement = this.myPointer != null ? this.myPointer.getElement() : null;
        if (declarationStatement instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements = ((PsiDeclarationStatement)declarationStatement).getDeclaredElements();
            return declaredElements.length == 0 ? null : (PsiVariable)declaredElements[0];
        }
        return declarationStatement instanceof PsiVariable ? (PsiVariable)declarationStatement : null;
    }

    protected String getActionName() {
        return "IntroduceVariable";
    }

    protected String getRefactoringId() {
        return "refactoring.extractVariable";
    }

    @Override
    protected void restoreState(@NotNull PsiVariable psiField) {
        if (psiField == null) {
            JavaVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState(psiField);
    }

    protected boolean ensureValid() {
        PsiVariable variable = this.getVariable();
        return variable != null && this.isIdentifier(this.getInputName(), variable.getLanguage());
    }

    protected void performCleanup() {
        super.performCleanup();
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> super.restoreState(variable), null, null);
        }
    }

    protected void deleteTemplateField(PsiVariable variable) {
        if (!this.myDeleteSelf) {
            return;
        }
        if (this.myReplaceSelf) {
            variable.replace((PsiElement)variable.getInitializer());
        } else {
            super.deleteTemplateField((PsiNameIdentifierOwner)variable);
        }
    }

    protected PsiExpression getBeforeExpr() {
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            return variable.getInitializer();
        }
        return (PsiExpression)super.getBeforeExpr();
    }

    protected void performIntroduce() {
        PsiVariable psiVariable = this.getVariable();
        if (psiVariable == null) {
            return;
        }
        TypeSelectorManagerImpl.typeSelected(psiVariable.getType(), this.myTypeSelectorManager.getDefaultType());
        if (this.myCanBeFinalCb != null) {
            JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = psiVariable.hasModifierProperty("final");
        }
        if (this.myCanBeVarTypeCb != null) {
            JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_VAR_TYPE = this.myCanBeVarTypeCb.isSelected();
        }
        Document document = this.myEditor.getDocument();
        LOG.assertTrue(psiVariable.isValid());
        JavaVariableInplaceIntroducer.adjustLine(psiVariable, document);
        int startOffset = this.getExprMarker() != null && this.getExprMarker().isValid() ? this.getExprMarker().getStartOffset() : psiVariable.getTextOffset();
        PsiFile file = psiVariable.getContainingFile();
        PsiReference referenceAt = file.findReferenceAt(startOffset);
        if (referenceAt != null && referenceAt.resolve() instanceof PsiVariable) {
            startOffset = referenceAt.getElement().getTextRange().getEndOffset();
        } else {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
            if (declarationStatement != null) {
                startOffset = declarationStatement.getTextRange().getEndOffset();
            }
        }
        this.myEditor.getCaretModel().moveToOffset(startOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (this.myConflictResolver != null && this.myInsertedName != null && this.isIdentifier(this.myInsertedName, psiVariable.getLanguage())) {
                this.myConflictResolver.apply(psiVariable.getName());
            }
            if (psiVariable.getInitializer() != null) {
                JavaVariableInplaceIntroducer.appendTypeCasts(this.getOccurrenceMarkers(), file, this.myProject, psiVariable);
            }
        });
    }

    public boolean isReplaceAllOccurrences() {
        return this.mySettings.isReplaceAllOccurrences();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceVariableHandler && super.startsOnTheSameElement(handler, element);
    }

    @Nullable
    protected JComponent getComponent() {
        if (!(!this.myCantChangeFinalModifier || this.myCanBeVarType && this.getVariable() instanceof PsiLocalVariable)) {
            return null;
        }
        if (!this.myCantChangeFinalModifier) {
            this.myCanBeFinalCb = new NonFocusableCheckBox("Declare final");
            this.myCanBeFinalCb.setSelected(this.createFinals());
            this.myCanBeFinalCb.setMnemonic('f');
            final FinalListener finalListener = new FinalListener(this.myEditor);
            this.myCanBeFinalCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WriteCommandAction.writeCommandAction((Project)JavaVariableInplaceIntroducer.this.myProject).withName(JavaVariableInplaceIntroducer.this.getCommandName()).withGroupId(JavaVariableInplaceIntroducer.this.getCommandName()).run(() -> {
                        PsiDocumentManager.getInstance((Project)JavaVariableInplaceIntroducer.this.myProject).commitDocument(JavaVariableInplaceIntroducer.this.myEditor.getDocument());
                        PsiVariable variable = JavaVariableInplaceIntroducer.this.getVariable();
                        if (variable != null) {
                            finalListener.perform(JavaVariableInplaceIntroducer.this.myCanBeFinalCb.isSelected(), variable);
                        }
                    });
                }
            });
        }
        if (this.myCanBeVarType && this.getVariable() instanceof PsiLocalVariable) {
            this.myCanBeVarTypeCb = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.var.type"));
            this.myCanBeVarTypeCb.setSelected(IntroduceVariableBase.createVarType());
            this.myCanBeVarTypeCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WriteCommandAction.writeCommandAction((Project)JavaVariableInplaceIntroducer.this.myProject).withName(JavaVariableInplaceIntroducer.this.getCommandName()).withGroupId(JavaVariableInplaceIntroducer.this.getCommandName()).run(() -> {
                        PsiVariable variable = JavaVariableInplaceIntroducer.this.getVariable();
                        if (variable != null) {
                            PsiTypeElement typeElement = variable.getTypeElement();
                            LOG.assertTrue(typeElement != null);
                            if (JavaVariableInplaceIntroducer.this.myCanBeVarTypeCb.isSelected()) {
                                IntroduceVariableBase.expandDiamondsAndReplaceExplicitTypeWithVar(typeElement, (PsiElement)variable);
                            } else if ((typeElement = PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement)) != null) {
                                IntroduceVariableBase.simplifyVariableInitializer(variable.getInitializer(), typeElement.getType());
                            }
                        }
                    });
                }
            });
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5), 0, 0);
        if (this.myCanBeFinalCb != null) {
            panel.add((Component)this.myCanBeFinalCb, gridBagConstraints);
        }
        if (this.myCanBeVarTypeCb != null) {
            panel.add((Component)this.myCanBeVarTypeCb, gridBagConstraints);
        }
        gridBagConstraints.fill = 1;
        panel.add((Component)Box.createVerticalBox(), gridBagConstraints);
        return panel;
    }

    protected void addAdditionalVariables(TemplateBuilderImpl builder) {
        PsiTypeElement typeElement;
        PsiVariable variable = this.getVariable();
        if (variable != null && (typeElement = variable.getTypeElement()) != null) {
            builder.replaceElement((PsiElement)typeElement, "Variable_Type", AbstractJavaInplaceIntroducer.createExpression(this.myExpression, typeElement.getText()), true, this.mySkipTypeExpressionOnStart);
        }
    }

    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            JavaVariableInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (this.isReplaceAllOccurrences()) {
            for (PsiExpression expression2 : (PsiExpression[])this.getOccurrences()) {
                LOG.assertTrue(expression2.isValid(), (Object)expression2.getText());
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expression2, (Object)new TextRange(0, expression2.getTextLength())));
            }
        } else if (this.getExpr() != null && !this.myReplaceSelf && ((PsiExpression)this.getExpr()).getParent() != this.getVariable()) {
            PsiExpression expr = (PsiExpression)this.getExpr();
            LOG.assertTrue(expr.isValid(), (Object)expr.getText());
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expr, (Object)new TextRange(0, expr.getTextLength())));
        }
    }

    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
        PsiExpression expr;
        if (!this.isReplaceAllOccurrences() && ((expr = (PsiExpression)this.getExpr()) == null && !this.myReplaceSelf || expr != null && expr.getParent() == this.getVariable())) {
            return;
        }
        super.addReferenceAtCaret(refs);
    }

    private static void appendTypeCasts(List<RangeMarker> occurrenceMarkers, PsiFile file, Project project, @Nullable PsiVariable psiVariable) {
        if (occurrenceMarkers != null) {
            for (RangeMarker occurrenceMarker : occurrenceMarkers) {
                PsiElement refVariableElement = file.findElementAt(occurrenceMarker.getStartOffset());
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiReferenceExpression.class);
                if (referenceExpression == null) continue;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiVariable) {
                    JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project, (PsiVariable)parent);
                    continue;
                }
                if (!(parent instanceof PsiReferenceExpression) || psiVariable == null) continue;
                PsiExpression initializer = psiVariable.getInitializer();
                LOG.assertTrue(initializer != null);
                PsiType type2 = initializer.getType();
                if (((PsiReferenceExpression)parent).resolve() != null || type2 == null || type2.equals(psiVariable.getType())) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression castedExpr = elementFactory.createExpressionFromText("((" + type2.getCanonicalText() + ")" + referenceExpression.getText() + ")", parent);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(referenceExpression.replace((PsiElement)castedExpr));
            }
        }
        if (psiVariable != null && psiVariable.isValid()) {
            JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project, psiVariable);
        }
    }

    private static void createCastInVariableDeclaration(Project project, PsiVariable psiVariable) {
        PsiExpression initializer = psiVariable.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiType type2 = psiVariable.getType();
        PsiType initializerType = initializer.getType();
        if (initializerType != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)initializerType) && !PsiTypesUtil.hasUnresolvedComponents((PsiType)type2)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression castExpr = elementFactory.createExpressionFromText("(" + type2.getCanonicalText() + ")" + initializer.getText(), (PsiElement)psiVariable);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(initializer.replace((PsiElement)castExpr));
        }
    }

    @Nullable
    private static String getAdvertisementText(PsiDeclarationStatement declaration2, PsiType type2, boolean hasTypeSuggestion) {
        Shortcut[] shortcuts;
        VariablesProcessor processor = ReassignVariableUtil.findVariablesOfType(declaration2, type2);
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        if (processor.size() > 0 && (shortcuts = keymap.getShortcuts("IntroduceVariable")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to reassign existing variable";
        }
        if (hasTypeSuggestion && (shortcuts = keymap.getShortcuts("PreviousTemplateVariable")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to change type";
        }
        return null;
    }

    protected boolean createFinals() {
        return IntroduceVariableBase.createFinals(this.myFile);
    }

    public static void adjustLine(PsiVariable psiVariable, Document document) {
        int modifierListOffset = psiVariable.getTextRange().getStartOffset();
        int varLineNumber = document.getLineNumber(modifierListOffset);
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager.getInstance((Project)psiVariable.getProject()).doPostponedOperationsAndUnblockDocument(document);
            CodeStyleManager.getInstance((Project)psiVariable.getProject()).adjustLineIndent(document, document.getLineStartOffset(varLineNumber));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names, PsiType psiType) {
        PsiIdentifier identifier;
        PsiVariable variable = this.introduceVariable();
        PsiVariable restoredVar = this.getVariable();
        if (restoredVar != null) {
            variable = restoredVar;
        }
        if (this.isReplaceAllOccurrences()) {
            ArrayList occurrences = new ArrayList();
            ReferencesSearch.search((PsiElement)variable).forEach(reference -> occurrences.add(this.createMarker(reference.getElement())));
            this.setOccurrenceMarkers(occurrences);
            this.myOccurrences = new PsiExpression[occurrences.size()];
        }
        if ((identifier = variable.getNameIdentifier()) != null) {
            this.myEditor.getCaretModel().moveToOffset(identifier.getTextOffset());
        }
        try {
            this.myDeleteSelf = false;
            this.restoreState(variable);
        }
        finally {
            this.myDeleteSelf = true;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
        this.initOccurrencesMarkers();
        return variable;
    }

    protected PsiVariable introduceVariable() {
        PsiVariable variable = VariableExtractor.introduce(this.myProject, (PsiExpression)this.myExpr, this.myEditor, this.myChosenAnchor.getElement(), (PsiExpression[])this.getOccurrences(), this.mySettings);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        if (variable instanceof PsiField || variable instanceof PsiResourceVariable) {
            this.myPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)variable);
        } else {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (declarationStatement != null) {
                SmartPsiElementPointer pointer;
                this.myPointer = pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)declarationStatement);
                this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, (Object)pointer);
                this.setAdvertisementText(JavaVariableInplaceIntroducer.getAdvertisementText(declarationStatement, variable.getType(), this.myHasTypeSuggestion));
            }
        }
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
        return variable;
    }

    protected int getCaretOffset() {
        PsiIdentifier identifier;
        PsiVariable variable = this.getVariable();
        if (variable != null && (identifier = variable.getNameIdentifier()) != null) {
            return identifier.getTextOffset();
        }
        return super.getCaretOffset();
    }

    public void finish(boolean success) {
        super.finish(success);
        this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, null);
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceVariableBase.getSuggestedName((PsiType)defaultType, (PsiExpression)((PsiExpression)this.myExpr)).names;
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.LOCAL_VARIABLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceVariable/JavaVariableInplaceIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElementsToRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

