/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceparameterobject.ParameterObjectBuilder;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaIntroduceParameterObjectClassDescriptor
extends IntroduceParameterObjectClassDescriptor<PsiMethod, ParameterInfoImpl> {
    private static final Logger LOG = Logger.getInstance(JavaIntroduceParameterObjectClassDescriptor.class);
    private final Set<PsiTypeParameter> myTypeParameters;
    private final Map<ParameterInfoImpl, ParameterBean> myExistingClassProperties;
    private final MoveDestination myMoveDestination;

    public JavaIntroduceParameterObjectClassDescriptor(@NotNull String className, String packageName, MoveDestination moveDestination, boolean useExistingClass, boolean createInnerClass, String newVisibility, ParameterInfoImpl[] paramsToMerge, PsiMethod method, boolean generateAccessors) {
        if (className == null) {
            JavaIntroduceParameterObjectClassDescriptor.$$$reportNull$$$0(0);
        }
        super(className, JavaIntroduceParameterObjectClassDescriptor.calcPackageName(packageName, createInnerClass, method), useExistingClass, createInnerClass, newVisibility, generateAccessors, (ParameterInfo[])paramsToMerge);
        this.myTypeParameters = new LinkedHashSet<PsiTypeParameter>();
        this.myExistingClassProperties = new HashMap<ParameterInfoImpl, ParameterBean>();
        this.myMoveDestination = moveDestination;
        PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
        for (ParameterInfoImpl parameterInfo : paramsToMerge) {
            parameterInfo.getTypeWrapper().getType((PsiElement)method).accept((PsiTypeVisitor)searcher);
        }
        this.myTypeParameters.addAll(searcher.getTypeParameters());
    }

    private static String calcPackageName(String packageName, boolean createInnerClass, PsiMethod method) {
        if (createInnerClass) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                String qualifiedName = containingClass.getQualifiedName();
                return qualifiedName != null ? qualifiedName : "";
            }
            return packageName;
        }
        return packageName;
    }

    public Set<PsiTypeParameter> getTypeParameters() {
        return this.myTypeParameters;
    }

    public MoveDestination getMoveDestination() {
        return this.myMoveDestination;
    }

    public String createFakeClassTypeText() {
        String text2 = StringUtil.getQualifiedName((String)this.getPackageName(), (String)this.getClassName());
        if (!this.myTypeParameters.isEmpty()) {
            text2 = text2 + "<" + StringUtil.join(this.myTypeParameters, PsiNamedElement::getName, (String)", ") + ">";
        }
        return text2;
    }

    public PsiClass getExistingClass() {
        return (PsiClass)super.getExistingClass();
    }

    public String getGetter(ParameterInfoImpl param) {
        ParameterBean bean = this.getBean(param);
        return bean != null ? bean.getGetter() : null;
    }

    public String getSetter(ParameterInfoImpl param) {
        ParameterBean bean = this.getBean(param);
        return bean != null ? bean.getSetter() : null;
    }

    public String getSetterName(ParameterInfoImpl parameterInfo, @NotNull PsiElement context) {
        ParameterBean bean;
        String setter;
        if (context == null) {
            JavaIntroduceParameterObjectClassDescriptor.$$$reportNull$$$0(1);
        }
        String string = setter = (bean = this.getBean(parameterInfo)) != null ? bean.getSetter() : null;
        if (setter == null) {
            setter = bean != null && bean.getField() != null ? GenerateMembersUtil.suggestSetterName(bean.getField()) : GenerateMembersUtil.suggestSetterName(parameterInfo.getName(), parameterInfo.getTypeWrapper().getType(context), context.getProject());
        }
        return setter;
    }

    public String getGetterName(ParameterInfoImpl paramInfo, @NotNull PsiElement context) {
        ParameterBean bean;
        String getter;
        if (context == null) {
            JavaIntroduceParameterObjectClassDescriptor.$$$reportNull$$$0(2);
        }
        String string = getter = (bean = this.getBean(paramInfo)) != null ? bean.getGetter() : null;
        if (getter == null) {
            getter = bean != null && bean.getField() != null ? GenerateMembersUtil.suggestGetterName(bean.getField()) : GenerateMembersUtil.suggestGetterName(paramInfo.getName(), paramInfo.getTypeWrapper().getType(context), context.getProject());
        }
        return getter;
    }

    public PsiMethod findCompatibleConstructorInExistingClass(PsiMethod method) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)method.getProject());
        String qualifiedName = StringUtil.getQualifiedName((String)this.getPackageName(), (String)this.getClassName());
        PsiClass existingClass = psiFacade.findClass(qualifiedName, method.getResolveScope());
        this.setExistingClass((PsiElement)existingClass);
        return this.findCompatibleConstructor(existingClass);
    }

    @Nullable
    public PsiField getField(ParameterInfoImpl parameter2) {
        ParameterBean bean = this.getBean(parameter2);
        return bean != null ? bean.getField() : null;
    }

    public ParameterBean getBean(ParameterInfoImpl param) {
        return this.myExistingClassProperties.get(param);
    }

    @Nullable
    private PsiMethod findCompatibleConstructor(@NotNull PsiClass aClass) {
        ParameterInfoImpl[] paramsToMerge;
        if (aClass == null) {
            JavaIntroduceParameterObjectClassDescriptor.$$$reportNull$$$0(3);
        }
        if ((paramsToMerge = (ParameterInfoImpl[])this.getParamsToMerge()).length == 1) {
            ParameterInfoImpl parameterInfo = paramsToMerge[0];
            PsiType paramType = parameterInfo.getTypeWrapper().getType((PsiElement)aClass);
            if (TypeConversionUtil.isPrimitiveWrapper((String)aClass.getQualifiedName())) {
                ParameterBean bean = new ParameterBean();
                bean.setField(aClass.findFieldByName("value", false));
                bean.setGetter(paramType.getCanonicalText() + "Value");
                this.myExistingClassProperties.put(parameterInfo, bean);
                PsiMethod[] psiMethodArray = aClass.getConstructors();
                int n = psiMethodArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiMethod constructor = psiMethodArray[i];
                    if (!JavaIntroduceParameterObjectClassDescriptor.isConstructorCompatible(constructor, new ParameterInfoImpl[]{parameterInfo}, (PsiElement)aClass)) continue;
                    return constructor;
                }
            }
        }
        PsiMethod[] constructors = aClass.getConstructors();
        PsiMethod compatibleConstructor = null;
        for (PsiMethod constructor : constructors) {
            if (!JavaIntroduceParameterObjectClassDescriptor.isConstructorCompatible(constructor, paramsToMerge, (PsiElement)aClass)) continue;
            compatibleConstructor = constructor;
            break;
        }
        PsiField[] fields = aClass.getFields();
        if (compatibleConstructor == null && !JavaIntroduceParameterObjectClassDescriptor.areTypesCompatible((ParameterInfoImpl[])this.getParamsToMerge(), (PsiVariable[])fields, (PsiElement)aClass)) {
            return null;
        }
        PsiField[] constructorParams = compatibleConstructor != null ? compatibleConstructor.getParameterList().getParameters() : fields;
        for (int i = 0; i < ((ParameterInfoImpl[])this.getParamsToMerge()).length; ++i) {
            PsiMethod setterForField;
            PsiField field;
            int oldIndex = ((ParameterInfoImpl[])this.getParamsToMerge())[i].getOldIndex();
            ParameterInfoImpl methodParam = (ParameterInfoImpl)this.getParameterInfo(oldIndex);
            ParameterBean bean = new ParameterBean();
            this.myExistingClassProperties.put(methodParam, bean);
            PsiField var = constructorParams[i];
            PsiField psiField = field = var instanceof PsiParameter ? JavaIntroduceParameterObjectClassDescriptor.findFieldAssigned((PsiParameter)var, compatibleConstructor) : var;
            if (field == null) {
                return null;
            }
            bean.setField(field);
            PsiMethod getterForField = PropertyUtilBase.findGetterForField((PsiField)field);
            if (getterForField != null) {
                bean.setGetter(getterForField.getName());
            }
            if ((setterForField = PropertyUtilBase.findSetterForField((PsiField)field)) == null) continue;
            bean.setSetter(setterForField.getName());
        }
        return compatibleConstructor;
    }

    private static boolean isConstructorCompatible(PsiMethod constructor, ParameterInfoImpl[] paramsToMerge, PsiElement context) {
        PsiParameterList parameterList = constructor.getParameterList();
        PsiParameter[] constructorParams = parameterList.getParameters();
        return JavaIntroduceParameterObjectClassDescriptor.areTypesCompatible(paramsToMerge, (PsiVariable[])constructorParams, context);
    }

    private static boolean areTypesCompatible(ParameterInfoImpl[] expected, PsiVariable[] actual, PsiElement context) {
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < actual.length; ++i) {
            if (TypeConversionUtil.isAssignable((PsiType)actual[i].getType(), (PsiType)expected[i].getTypeWrapper().getType(context))) continue;
            return false;
        }
        return true;
    }

    private static PsiField findFieldAssigned(PsiParameter param, PsiMethod constructor) {
        ParamAssignmentFinder visitor = new ParamAssignmentFinder(param);
        constructor.accept((PsiElementVisitor)visitor);
        return visitor.getFieldAssigned();
    }

    public PsiClass createClass(PsiMethod method, ReadWriteAccessDetector.Access[] accessors) {
        if (this.isUseExistingClass()) {
            return this.getExistingClass();
        }
        ParameterObjectBuilder beanClassBuilder = new ParameterObjectBuilder();
        beanClassBuilder.setVisibility(this.isCreateInnerClass() ? "private" : "public");
        beanClassBuilder.setProject(method.getProject());
        beanClassBuilder.setFile(method.getContainingFile());
        beanClassBuilder.setTypeArguments(this.getTypeParameters());
        beanClassBuilder.setClassName(this.getClassName());
        beanClassBuilder.setPackageName(this.getPackageName());
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        ParameterInfoImpl[] parameterInfos = (ParameterInfoImpl[])this.getParamsToMerge();
        for (int i = 0; i < parameterInfos.length; ++i) {
            PsiParameter parameter2 = parameters2[parameterInfos[i].getOldIndex()];
            boolean setterRequired = accessors[i] == ReadWriteAccessDetector.Access.Write;
            String newName = parameterInfos[i].getName();
            beanClassBuilder.addField(parameter2, newName, parameterInfos[i].getTypeWrapper().getType((PsiElement)method), setterRequired);
        }
        String classString = beanClassBuilder.buildBeanClass();
        try {
            PsiDirectory directory;
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)method.getProject());
            PsiJavaFile newFile = (PsiJavaFile)factory.createFileFromText(this.getClassName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)classString);
            if (this.isCreateInnerClass()) {
                PsiClass containingClass = method.getContainingClass();
                PsiClass[] classes2 = newFile.getClasses();
                assert (classes2.length > 0) : classString;
                PsiClass innerClass = (PsiClass)containingClass.add((PsiElement)classes2[0]);
                PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"static", (boolean)true);
                return (PsiClass)JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)innerClass);
            }
            PsiFile containingFile = method.getContainingFile();
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            MoveDestination moveDestination = this.getMoveDestination();
            if (moveDestination != null) {
                directory = moveDestination.getTargetDirectory(containingDirectory);
            } else {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
                directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.getPackageName(), containingDirectory, true, true);
            }
            if (directory != null) {
                PsiFile file = directory.findFile(newFile.getName());
                if (file == null) {
                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)method.getManager().getProject());
                    PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)newFile);
                    PsiElement reformattedFile = codeStyleManager.reformat(shortenedFile);
                    file = (PsiFile)directory.add(reformattedFile);
                }
                return ((PsiJavaFile)file).getClasses()[0];
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceparameterobject/JavaIntroduceParameterObjectClassDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetterName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getGetterName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCompatibleConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ParameterBean {
        private PsiField myField;
        private String myGetter;
        private String mySetter;

        private ParameterBean() {
        }

        public PsiField getField() {
            return this.myField;
        }

        public void setField(PsiField field) {
            this.myField = field;
        }

        public String getGetter() {
            return this.myGetter;
        }

        public void setGetter(String getter) {
            this.myGetter = getter;
        }

        public String getSetter() {
            return this.mySetter;
        }

        public void setSetter(String setter) {
            this.mySetter = setter;
        }
    }

    private static class ParamAssignmentFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiParameter param;
        private PsiField fieldAssigned;

        ParamAssignmentFinder(PsiParameter param) {
            this.param = param;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = assignment.getRExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(this.param)) {
                return;
            }
            PsiElement assigned = ((PsiReference)lhs).resolve();
            if (!(assigned instanceof PsiField)) {
                return;
            }
            this.fieldAssigned = (PsiField)assigned;
        }

        public PsiField getFieldAssigned() {
            return this.fieldAssigned;
        }
    }
}

