/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticOverloadsRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            AutomaticOverloadsRenamerFactory.$$$reportNull$$$0(0);
        }
        if (element.getLanguage() == JavaLanguage.INSTANCE && element instanceof PsiMethod && !((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && containingClass.findMethodsByName(((PsiMethod)element).getName(), false).length > 1;
        }
        return false;
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.overloads");
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isRenameOverloads();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameOverloads(enabled);
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        AutomaticOverloadsRenamer automaticOverloadsRenamer = new AutomaticOverloadsRenamer((PsiMethod)element, newName);
        if (automaticOverloadsRenamer == null) {
            AutomaticOverloadsRenamerFactory.$$$reportNull$$$0(1);
        }
        return automaticOverloadsRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

