/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.TypeCookViewDescriptor;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.builder.Result;
import com.intellij.refactoring.typeCook.deductive.builder.SystemBuilder;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import com.intellij.refactoring.typeCook.deductive.resolver.ResolverTree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeCookProcessor
extends BaseRefactoringProcessor {
    private PsiElement[] myElements;
    private final Settings mySettings;
    private Result myResult;

    public TypeCookProcessor(Project project, PsiElement[] elements, Settings settings) {
        super(project);
        this.myElements = elements;
        this.mySettings = settings;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            TypeCookProcessor.$$$reportNull$$$0(0);
        }
        TypeCookViewDescriptor typeCookViewDescriptor = new TypeCookViewDescriptor(this.myElements);
        if (typeCookViewDescriptor == null) {
            TypeCookProcessor.$$$reportNull$$$0(1);
        }
        return typeCookViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ReductionSystem[] systems;
        SystemBuilder systemBuilder = new SystemBuilder(this.myProject, this.mySettings);
        ReductionSystem commonSystem = systemBuilder.build(this.myElements);
        this.myResult = new Result(commonSystem);
        for (ReductionSystem system : systems = commonSystem.isolate()) {
            if (system == null) continue;
            ResolverTree tree = new ResolverTree(system);
            tree.resolve();
            Binding solution = tree.getBestSolution();
            if (solution == null) continue;
            this.myResult.incorporateSolution(solution);
        }
        Set<PsiElement> changedItems = this.myResult.getCookedElements();
        UsageInfo[] usages = new UsageInfo[changedItems.size()];
        int i = 0;
        for (final PsiElement element : changedItems) {
            if (!(element instanceof PsiTypeCastExpression)) {
                usages[i++] = new UsageInfo(element){

                    public String getTooltipText() {
                        return TypeCookProcessor.this.myResult.getCookedType(element).getCanonicalText();
                    }
                };
                continue;
            }
            usages[i++] = new UsageInfo(element);
        }
        if (usages == null) {
            TypeCookProcessor.$$$reportNull$$$0(2);
        }
        return usages;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            TypeCookProcessor.$$$reportNull$$$0(3);
        }
        this.myElements = elements;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            TypeCookProcessor.$$$reportNull$$$0(4);
        }
        HashSet<PsiElement> victims = new HashSet<PsiElement>();
        for (UsageInfo usage : usages) {
            victims.add(usage.getElement());
        }
        this.myResult.apply(victims);
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo(this.myResult.getReport());
    }

    protected boolean isGlobalUndoAction() {
        return true;
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"type.cook.command");
        if (string == null) {
            TypeCookProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public List<PsiElement> getElements() {
        return ContainerUtil.immutableList((Object[])this.myElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeCook/TypeCookProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeCook/TypeCookProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

