/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.spi.SPIFileType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFile
extends PsiFileBase {
    public SPIFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            SPIFile.$$$reportNull$$$0(0);
        }
        super(viewProvider, (Language)SPILanguage.INSTANCE);
    }

    @NotNull
    public PsiReference getReference() {
        SPIFileName2ClassReference sPIFileName2ClassReference = new SPIFileName2ClassReference((PsiFile)this, (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClass((PsiManager)this.getManager(), (String)this.getName(), null, (boolean)true, (GlobalSearchScope)this.getResolveScope())));
        if (sPIFileName2ClassReference == null) {
            SPIFile.$$$reportNull$$$0(1);
        }
        return sPIFileName2ClassReference;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])ReadAction.compute(() -> {
            int d;
            ArrayList<SPIFileName2PackageReference> refs = new ArrayList<SPIFileName2PackageReference>();
            int idx = 0;
            String fileName = this.getName();
            while ((d = fileName.indexOf(".", idx)) > -1) {
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(fileName.substring(0, d));
                if (aPackage != null) {
                    refs.add(new SPIFileName2PackageReference((PsiFile)this, (PsiElement)aPackage));
                }
                idx = d + 1;
            }
            PsiReference reference = this.getReference();
            PsiElement resolve = reference.resolve();
            while (resolve instanceof PsiClass) {
                String jvmClassName;
                if ((resolve = ((PsiClass)resolve).getContainingClass()) == null || (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)resolve))) == null) continue;
                refs.add(new SPIFileName2PackageReference((PsiFile)this, resolve));
            }
            refs.add((SPIFileName2PackageReference)reference);
            return refs.toArray(PsiReference.EMPTY_ARRAY);
        });
        if (psiReferenceArray == null) {
            SPIFile.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @NotNull
    public FileType getFileType() {
        SPIFileType sPIFileType = SPIFileType.INSTANCE;
        if (sPIFileType == null) {
            SPIFile.$$$reportNull$$$0(3);
        }
        return sPIFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spi/psi/SPIFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spi/psi/SPIFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SPIFileName2PackageReference
    extends PsiReferenceBase<PsiFile> {
        private final PsiElement myPackageOrContainingClass;

        SPIFileName2PackageReference(PsiFile file, @NotNull PsiElement psiPackage) {
            if (psiPackage == null) {
                SPIFileName2PackageReference.$$$reportNull$$$0(0);
            }
            super((PsiElement)file, new TextRange(0, 0), false);
            this.myPackageOrContainingClass = psiPackage;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myPackageOrContainingClass instanceof PsiPackage ? ((PsiPackage)this.myPackageOrContainingClass).getQualifiedName() : ClassUtil.getJVMClassName((PsiClass)((PsiClass)this.myPackageOrContainingClass));
            if (string == null) {
                SPIFileName2PackageReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myPackageOrContainingClass;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                SPIFileName2PackageReference.$$$reportNull$$$0(2);
            }
            String newPackageQName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)this.getCanonicalText()), (String)newElementName);
            return ((PsiFile)this.getElement()).setName(newPackageQName + ((PsiFile)this.getElement()).getName().substring(this.getCanonicalText().length()));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String className;
            if (element == null) {
                SPIFileName2PackageReference.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiPackage) {
                return this.handleElementRename(((PsiPackage)element).getQualifiedName());
            }
            if (element instanceof PsiClass && (className = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                return this.handleElementRename(className);
            }
            return this.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiPackage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spi/psi/SPIFile$SPIFileName2PackageReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spi/psi/SPIFile$SPIFileName2PackageReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SPIFileName2ClassReference
    extends PsiReferenceBase<PsiFile> {
        private final PsiClass myClass;

        SPIFileName2ClassReference(PsiFile file, PsiClass aClass) {
            super((PsiElement)file, new TextRange(0, 0), false);
            this.myClass = aClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myClass;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            String className;
            if (newElementName == null) {
                SPIFileName2ClassReference.$$$reportNull$$$0(0);
            }
            if (this.myClass != null && (className = ClassUtil.getJVMClassName((PsiClass)this.myClass)) != null) {
                String newFileName = className.substring(0, className.lastIndexOf(this.myClass.getName())) + newElementName;
                return ((PsiFile)this.getElement()).setName(newFileName);
            }
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String className;
            if (element == null) {
                SPIFileName2ClassReference.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiClass && (className = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                return ((PsiFile)this.getElement()).setName(className);
            }
            return this.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spi/psi/SPIFile$SPIFileName2ClassReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleElementRename";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bindToElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

