/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NoExplicitFinalizeCallsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("FinalizeCalledExplicitly" == null) {
            NoExplicitFinalizeCallsInspection.$$$reportNull$$$0(0);
        }
        return "FinalizeCalledExplicitly";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("finalize.called.explicitly.display.name", new Object[0]);
        if (string == null) {
            NoExplicitFinalizeCallsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.called.explicitly.problem.descriptor", new Object[0]);
        if (string == null) {
            NoExplicitFinalizeCallsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoExplicitFinalizeCallsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/finalization/NoExplicitFinalizeCallsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NoExplicitFinalizeCallsVisitor
    extends BaseInspectionVisitor {
        private NoExplicitFinalizeCallsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                NoExplicitFinalizeCallsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, null, (PsiType)PsiType.VOID, "finalize", new PsiType[0])) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (containingMethod == null || MethodUtils.isFinalize(containingMethod)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/finalization/NoExplicitFinalizeCallsInspection$NoExplicitFinalizeCallsVisitor", "visitMethodCallExpression"));
        }
    }
}

