/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnicodeEscapeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryUnicodeEscapeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Character c = (Character)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessary.unicode.escape.problem.descriptor", c);
        if (string == null) {
            UnnecessaryUnicodeEscapeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnicodeEscapeFix(((Character)infos[0]).charValue(), (RangeMarker)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnicodeEscapeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryUnicodeEscapeVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnicodeEscapeVisitor() {
        }

        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file) || !file.isPhysical()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            String text2 = file.getText();
            Charset charset = LoadTextUtil.extractCharsetFromFileContent((Project)file.getProject(), (VirtualFile)virtualFile, (CharSequence)text2);
            CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer charBuffer = CharBuffer.allocate(1);
            ByteBuffer byteBuffer = ByteBuffer.allocate(10);
            int length = text2.length();
            for (int i = 0; i < length; ++i) {
                int escapeEnd;
                char d;
                int type2;
                int nextChar;
                char c = text2.charAt(i);
                if (c != '\\') continue;
                boolean isEscape = true;
                for (int previousChar = i - 1; previousChar >= 0 && text2.charAt(previousChar) == '\\'; --previousChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                for (nextChar = i + 1; nextChar < length && text2.charAt(nextChar) == 'u'; ++nextChar) {
                }
                if (nextChar == i + 1 || nextChar + 3 >= length || !StringUtil.isHexDigit((char)text2.charAt(nextChar)) || !StringUtil.isHexDigit((char)text2.charAt(nextChar + 1)) || !StringUtil.isHexDigit((char)text2.charAt(nextChar + 2)) || !StringUtil.isHexDigit((char)text2.charAt(nextChar + 3)) || (type2 = Character.getType(d = (char)Integer.parseInt(text2.substring(nextChar, escapeEnd = nextChar + 4), 16))) == 15 || type2 == 16 || type2 == 18 || type2 == 19 || type2 == 0 || type2 == 13 || type2 == 14 || type2 == 12 && d != ' ') continue;
                byteBuffer.clear();
                charBuffer.clear();
                charBuffer.put(d).rewind();
                CoderResult coderResult = encoder.encode(charBuffer, byteBuffer, true);
                if (coderResult.isError()) continue;
                PsiElement element = file.findElementAt(i);
                if (element != null && UnnecessaryUnicodeEscapeInspection.this.isSuppressedFor(element)) {
                    return;
                }
                RangeMarker rangeMarker = document.createRangeMarker(i, escapeEnd);
                this.registerErrorAtOffset((PsiElement)file, i, escapeEnd - i, Character.valueOf(d), rangeMarker);
            }
        }
    }

    private static class UnnecessaryUnicodeEscapeFix
    extends InspectionGadgetsFix {
        private final char c;
        private final RangeMarker myRangeMarker;

        UnnecessaryUnicodeEscapeFix(char c, RangeMarker rangeMarker) {
            this.c = c;
            this.myRangeMarker = rangeMarker;
        }

        @NotNull
        public String getName() {
            String string = "Replace with '" + this.c + "'";
            if (string == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with character" == null) {
                UnnecessaryUnicodeEscapeFix.$$$reportNull$$$0(1);
            }
            return "Replace with character";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            this.myRangeMarker.getDocument().replaceString(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset(), (CharSequence)String.valueOf(this.c));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/internationalization/UnnecessaryUnicodeEscapeInspection$UnnecessaryUnicodeEscapeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

